/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.storage.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.business.detail.storage.impl.DetailCacheIDProvider;
import kd.ebg.aqap.business.detail.storage.impl.DetailCacheNameProvider;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.DetailSyncRecord;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class DetailCache {
    @Autowired
    private DetailCacheNameProvider nameProvider;
    @Autowired
    private DetailCacheIDProvider idProvider;

    public void put(DetailSyncRecord record, List<DetailInfo> details) {
        this.put(this.nameProvider.cacheName(record), this.idProvider.genID(record), details);
    }

    public List<DetailInfo> get(DetailSyncRecord record) {
        return this.get(this.nameProvider.cacheName(record), this.idProvider.genID(record));
    }

    public void put(String cacheName, String id, List<DetailInfo> details) {
        if (CollectionUtil.isEmpty(details)) {
            CosmicCache.addList((String)(cacheName + id), (String[])new String[0]);
        }
        String[] val = new String[details.size()];
        for (int i = 0; i < details.size(); ++i) {
            val[i] = JSONObject.toJSONString((Object)details.get(i));
        }
        CosmicCache.addList((String)(cacheName + id), (String[])val);
    }

    public void put(String cacheName, String id, long timestamp) {
        String key = cacheName + id;
        CosmicCache.put((String)key, (String)String.valueOf(timestamp));
    }

    public long getSyncTime(String cacheName, String id) {
        String val = CosmicCache.get((String)(cacheName + id));
        if (StringUtils.isEmpty((String)val)) {
            return 0L;
        }
        return Long.parseLong(val);
    }

    public List<DetailInfo> get(String cacheName, String id) {
        String[] val = CosmicCache.getList((String)(cacheName + id));
        if (val != null && val.length > 0) {
            ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(1);
            for (int i = 0; i < val.length; ++i) {
                result.add((DetailInfo)JSONObject.parseObject((String)val[i], DetailInfo.class));
            }
            return result;
        }
        return new ArrayList<DetailInfo>(1);
    }

    public void remove(DetailSyncRecord record) {
        this.remove(this.nameProvider.cacheName(record), this.idProvider.genID(record));
    }

    public void remove(String cacheName, String id) {
        CosmicCache.delete((String)(cacheName + id));
    }
}

