/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.storage.sync;

import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.business.detail.storage.sync.SyncPeriod;

public class SyncCalculateUtil {
    private static final int EB_ALLOWCROSS = 3;

    public static List<SyncPeriod> calculateSyncPeriod(List<LocalDate> date2Sync, int allowCross) {
        if (date2Sync.isEmpty()) {
            return new ArrayList<SyncPeriod>(1);
        }
        date2Sync.sort((d1, d2) -> {
            if (d1.isBefore((ChronoLocalDate)d2)) {
                return -1;
            }
            if (d1.isAfter((ChronoLocalDate)d2)) {
                return 1;
            }
            return 0;
        });
        ArrayList<SyncPeriod> result = new ArrayList<SyncPeriod>(1);
        SyncPeriod tempPeriod = new SyncPeriod();
        tempPeriod.setStartDate(date2Sync.get(0));
        tempPeriod.setEndDate(date2Sync.get(0).plusDays(allowCross));
        for (LocalDate localDate : date2Sync) {
            if (localDate.isAfter(tempPeriod.getEndDate())) {
                tempPeriod.setEndDate(tempPeriod.getEndDate().minusDays(allowCross));
                result.add(tempPeriod);
                tempPeriod = new SyncPeriod();
                tempPeriod.setStartDate(localDate);
                tempPeriod.setEndDate(localDate.plusDays(allowCross));
                continue;
            }
            tempPeriod.setEndDate(localDate.plusDays(allowCross));
        }
        LocalDate lastInDate2Sync = date2Sync.get(date2Sync.size() - 1);
        if (tempPeriod.getEndDate().isAfter(lastInDate2Sync)) {
            tempPeriod.setEndDate(lastInDate2Sync);
        }
        result.add(tempPeriod);
        return result;
    }

    public static List<SyncPeriod> getEBSyncPeriod(List<LocalDate> dates2Sync) {
        if (dates2Sync.isEmpty()) {
            return new ArrayList<SyncPeriod>(1);
        }
        return SyncCalculateUtil.calculateSyncPeriod(dates2Sync, 3);
    }
}

