/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.utils;

import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class DetailCurrencyFilterUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailCurrencyFilterUtils.class);

    public static List<DetailInfo> filterCurrency(List<DetailInfo> detailInfoList, String isoCurrency) {
        boolean isOpenFilter = BusinessPropertyConfig.isOpenCurrencyFilter();
        if (isOpenFilter) {
            return detailInfoList.stream().filter(detailInfo -> isoCurrency.equals(detailInfo.getCurrency())).collect(Collectors.toList());
        }
        for (DetailInfo detailInfo2 : detailInfoList) {
            if (isoCurrency.equals(detailInfo2.getCurrency())) continue;
            logger.info("\u6b64\u8d26\u53f7\u5728\u65e5\u671f{}\u7684\u54cd\u5e94\u5e01\u79cd{}\u4e0e\u4e0a\u9001\u5e01\u79cd{}\u4e0d\u4e00\u81f4\uff0c\u94f6\u884c\u6d41\u6c34\u53f7\u4e3a{}\uff0c\u4f46\u662f\u7531\u4e8e\u5173\u95ed\u4e86\u8fc7\u6ee4\u5f00\u5173\uff0c\u6240\u4ee5\u672c\u6b21\u4e0d\u8fc7\u6ee4\u8bb0\u5f55\uff0c\u5c06\u5e01\u79cd\u4fee\u6539\u4e3a\u4e0a\u9001\u5e01\u79cd\uff0c\u6b63\u5e38\u8fd4\u56de", new Object[]{LocalDateUtil.formatDate((LocalDate)detailInfo2.getTransDate(), (String)"yyyy-MM-dd"), detailInfo2.getCurrency(), isoCurrency, detailInfo2.getBankDetailNo()});
            detailInfo2.setCurrency(isoCurrency);
        }
        return detailInfoList;
    }
}

