/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.utils;

import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.ebg.aqap.business.detail.bank.SecondDetailRequest;
import kd.ebg.aqap.business.detail.task.SecondDetailTask;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.bank.login.BankLoginRel;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SecondDetailUtil {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SecondDetailUtil.class);
    private BankLoginService bankLoginService = (BankLoginService)SpringContextUtil.getBean(BankLoginService.class);
    private BankAcntService bankAcntService = (BankAcntService)SpringContextUtil.getBean(BankAcntService.class);

    public void init(LocalDate startDate, LocalDate endDate) {
        List bankLogins = this.bankLoginService.getNotDeleteByCustomId(RequestContext.get().getTenantId());
        if (CollectionUtil.isNotEmpty((Collection)bankLogins)) {
            this.logger.info("\u83b7\u53d6\u672a\u5220\u9664\u524d\u7f6e\u673a{}\u4e2a", (Object)bankLogins.size());
            List bankLoginRels = this.bankLoginService.getAllDetailBankLoginRel();
            HashMap<String, String> relMap = new HashMap<String, String>(16);
            if (CollectionUtil.isNotEmpty((Collection)bankLoginRels)) {
                this.logger.info("\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6\u4e13\u5c5e\u524d\u7f6e\u673a{}\u4e2a", (Object)bankLoginRels.size());
                for (BankLoginRel bankLoginRel : bankLoginRels) {
                    relMap.put(bankLoginRel.getMasterNumber(), bankLoginRel.getExclusiveNumber());
                }
            }
            HashMap<String, List<BankAcnt>> groupMap = new HashMap<String, List<BankAcnt>>(16);
            for (BankLogin bankLogin : bankLogins) {
                String bankLoginId = bankLogin.getKey().getBankLoginId();
                List bankAcnts = this.bankAcntService.getNotDeleteAcntByBankLoginIDAndCustomID(bankLoginId, RequestContext.get().getTenantId());
                if (!CollectionUtil.isNotEmpty((Collection)bankAcnts)) continue;
                if (relMap.get(bankLoginId) != null) {
                    bankLoginId = (String)relMap.get(bankLoginId);
                }
                if (groupMap.get(bankLoginId) != null) {
                    ((List)groupMap.get(bankLoginId)).addAll(bankAcnts);
                    continue;
                }
                groupMap.put(bankLoginId, bankAcnts);
            }
            this.sync(groupMap, startDate, endDate);
        } else {
            this.logger.info("\u5f53\u524d\u4e0d\u5b58\u5728\u672a\u5220\u9664\u7684\u524d\u7f6e\u673a\u5217\u8868\uff0c\u8df3\u8fc7\u672c\u6b21\u4efb\u52a1");
        }
    }

    public void sync(Map<String, List<BankAcnt>> groupMap, LocalDate startDate, LocalDate endDate) {
        if (!groupMap.isEmpty()) {
            this.logger.info("\u5f53\u524d\u6709{}\u4e2a\u524d\u7f6e\u673a\u5b58\u5728\u8d26\u53f7\u9700\u53d1\u9001\u4ea4\u6613\u660e\u7ec6\u8bf7\u6c42", (Object)groupMap.size());
            for (Map.Entry<String, List<BankAcnt>> entry : groupMap.entrySet()) {
                this.submit(entry.getKey(), entry.getValue(), startDate, endDate);
            }
        }
    }

    private void submit(String bankLoginID, List<BankAcnt> BankAcnts, LocalDate startDate, LocalDate endDate) {
        String bizType = "secondDetail";
        String customId = RequestContext.get().getTenantId();
        String traceId = RequestContext.get().getTraceId();
        if (StringUtils.isEmpty((String)traceId)) {
            traceId = String.valueOf(System.currentTimeMillis());
        }
        String bizSeqID = Sequence.gen18Sequence();
        this.logger.info("\u5f53\u524d\u8282\u70b9\u5904\u7406\u63d0\u4ea4\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e8c\u901a\u9053traceId\u4e3a" + traceId);
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).requestSeqID("").bizName(bizType).subBizName(bizType).bankVersionID(BankAcnts.get(0).getBankVersionId()).bankLoginID(bankLoginID).bizSeqID(Sequence.gen18Sequence()).requestSeqID(Sequence.genSequence()).logBizSeqID(bizSeqID).logRequestSeqID(Sequence.gen18Sequence()).loggerBatchNo(bizSeqID).loggerDetailNo(bizSeqID).loggerBankNo(Sequence.gen18Sequence()).schedule(true).build();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo("");
        context.setBankAcnt(bankAcnt);
        EBContext.setContext((EBContext)context);
        SecondDetailRequest request = new SecondDetailRequest();
        request.setBankAcnts(BankAcnts);
        request.setStartDate(startDate);
        request.setEndDate(endDate);
        BankHeader header = new BankHeader();
        header.setBizType(bizType);
        header.setSubBizType(bizType);
        header.setCustomerID(customId);
        request.setHeader(header);
        this.logger.info(String.format("\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e8c\u901a\u9053\u63d0\u4ea4\u7ebf\u7a0b\u6c60\uff08%s,%s\uff09", customId, bankLoginID));
        String taskID = EBThreadPools.createBizTask(context);
        SecondDetailTask bankDetailTask = new SecondDetailTask(request, context);
        bankDetailTask.setTaskId(taskID);
        EBThreadPools.getSecondDetailThreadPool(customId, bankLoginID).submit((Callable)((Object)bankDetailTask));
        this.logger.info("\u63d0\u4ea4\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e8c\u901a\u9053\u7ebf\u7a0b\u6c60\u6210\u529f\uff08{},{}\uff09", new Object[]{customId, bankLoginID});
    }
}

