/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.file;

import java.net.MalformedURLException;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.file.atomic.IDownload;
import kd.ebg.aqap.business.file.bank.BankDownLoadFileRequest;
import kd.ebg.aqap.business.file.bank.BankDownLoadFileResponse;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.common.entity.biz.file.DownLoadFileRequest;
import kd.ebg.aqap.common.entity.biz.file.DownLoadFileRequestBody;
import kd.ebg.aqap.common.entity.biz.file.DownLoadFileResponse;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import org.slf4j.MDC;

public class DownLoadFileMethod
implements EBServiceMethod<DownLoadFileRequest, DownLoadFileResponse> {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DownLoadFileMethod.class);

    public DownLoadFileResponse executeClientRequest(DownLoadFileRequest request, EBContext context) throws MalformedURLException {
        AccessUtils.checkQueryAllowed(context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        EBContext.initParameter();
        String bankVersionId = EBContext.getContext().getBankVersionID();
        FEPAccess access = null;
        IDownload download = null;
        download = (IDownload)BankBundleManager.getInstance().getImpl(bankVersionId, IDownload.class, (Object)request);
        if (download == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u627e\u5230IDownload\u5b9e\u73b0\u7c7b\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\u5b9e\u73b0", (String)"DownLoadFileMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        BankDownLoadFileResponse response = null;
        try {
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
            response = download.detail(this.buildRequest(context.getAcnt(), request));
        }
        catch (Throwable e) {
            try {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38", e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38", (String)"DownLoadFileMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                FEPAccessUtil.release(access);
                throw throwable;
            }
        }
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        FEPAccessUtil.release((FEPAccess)access);
        return this.buildResponse(response);
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u670d\u52a1", (String)"DownLoadFileMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    private BankDownLoadFileRequest buildRequest(BankAcnt acnt, DownLoadFileRequest detailRequest) {
        BankDownLoadFileRequest request = new BankDownLoadFileRequest();
        BankHeader header = new BankHeader();
        request.setHeader(header);
        header.setAcnt(acnt);
        header.setBizType(detailRequest.getHeader().getBizType());
        header.setSubBizType(detailRequest.getHeader().getSubBizType());
        header.setClientName(detailRequest.getHeader().getClientName());
        header.setClientVersion(detailRequest.getHeader().getClientVersion());
        header.setExtData(detailRequest.getHeader().getExtData());
        header.setBankVersionID(acnt.getBankVersionId());
        header.setBankLoginID(acnt.getBankLoginId());
        header.setBizSeqID(detailRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(detailRequest.getHeader().getCustomId());
        request.setBatchSeqId(detailRequest.getBody().getBatchSeqId());
        request.setFileList(detailRequest.getBody().getFileList());
        return request;
    }

    private DownLoadFileResponse buildResponse(BankDownLoadFileResponse ebBankDetailResponse) {
        DownLoadFileResponse response = new DownLoadFileResponse();
        DownLoadFileRequestBody body = new DownLoadFileRequestBody();
        response.setBody(body);
        body.setBatchSeqId(ebBankDetailResponse.getBatchSeqId());
        body.setFileList(ebBankDetailResponse.getFileList());
        return response;
    }
}

