/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.financing.util;

import com.google.common.base.Preconditions;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.entity.biz.financing.buy.BuyFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.buy.BuyFinancingRequestDetail;
import kd.ebg.aqap.common.entity.biz.financing.redeem.RedeemFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.redeem.RedeemFinancingRequestDetail;
import kd.ebg.aqap.common.framework.services.FinancingService;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;

public class FinancingChecker {
    public static void checkStructure(BuyFinancingRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)MultiLang.getRequestEmptyTip());
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)MultiLang.getRequestHeaderEmptyTip());
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)MultiLang.getRequestBodyEmptyTip());
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"FinancingChecker_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
    }

    public static void checkStructure(RedeemFinancingRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)MultiLang.getRequestEmptyTip());
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)MultiLang.getRequestHeaderEmptyTip());
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)MultiLang.getRequestBodyEmptyTip());
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"FinancingChecker_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
    }

    public static void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)MultiLang.getBatchNotEmptyTip());
        Preconditions.checkState((!FinancingService.getInstance().batchSeqIDExist(batchSeqID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"batchSeqID \u5df2\u7ecf\u5b58\u5728\u3002", (String)"FinancingChecker_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
    }

    public static void checkBizNo(BuyFinancingRequest request) {
        for (BuyFinancingRequestDetail detail : request.getBody().getDetails()) {
            if (StringUtils.isEmpty((String)detail.getDetailBizNo())) {
                throw EBExceiptionUtil.duplicateException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u660e\u7ec6\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FinancingChecker_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            boolean flag = FinancingService.getInstance().existsByDetailBizNo(detail.getDetailBizNo());
            if (flag) {
                throw EBExceiptionUtil.duplicateException((String)String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u8bf7\u6c42\u7591\u4f3c\u91cd\u590d\u88ab\u62e6\u622a\uff0c\u5df2\u5b58\u5728\u4e1a\u52a1\u5b8c\u6210\u6216\u5728\u9014\u7684\u4e1a\u52a1\u53f7[%s]\u3002", (String)"FinancingChecker_13", (String)"ebg-aqap-business", (Object[])new Object[0]), detail.getDetailBizNo()));
            }
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)detail.getDetailSeqID()), (Object)ResManager.loadKDString((String)"\u4e1a\u52a1\u660e\u7ec6ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FinancingChecker_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)detail.getAccNo()), (Object)ResManager.loadKDString((String)"\u8d2d\u4e70\u7406\u8d22\u8d26\u6237\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FinancingChecker_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)detail.getProductCode()), (Object)ResManager.loadKDString((String)"\u8d2d\u4e70\u7406\u8d22\u4ea7\u54c1\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FinancingChecker_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((!StringUtils.isEmpty((String)detail.getAmount()) || !StringUtils.isEmpty((String)detail.getNumber()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8d2d\u4e70\u91d1\u989d\u548c\u4efd\u6570\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"FinancingChecker_7", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((!"0".equalsIgnoreCase(detail.getAmount()) || !"0".equalsIgnoreCase(detail.getNumber()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8d2d\u4e70\u91d1\u989d\u548c\u4efd\u6570\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a0\u3002", (String)"FinancingChecker_8", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }

    public static void checkBizNo(RedeemFinancingRequest request) {
        for (RedeemFinancingRequestDetail detail : request.getBody().getDetails()) {
            if (StringUtils.isEmpty((String)detail.getDetailBizNo())) {
                throw EBExceiptionUtil.duplicateException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u660e\u7ec6\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FinancingChecker_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
            boolean flag = FinancingService.getInstance().existsByDetailBizNo(detail.getDetailBizNo());
            if (flag) {
                throw EBExceiptionUtil.duplicateException((String)String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u8bf7\u6c42\u7591\u4f3c\u91cd\u590d\u88ab\u62e6\u622a\uff0c\u5df2\u5b58\u5728\u4e1a\u52a1\u5b8c\u6210\u6216\u5728\u9014\u7684\u4e1a\u52a1\u53f7[%s]\u3002", (String)"FinancingChecker_13", (String)"ebg-aqap-business", (Object[])new Object[0]), detail.getDetailBizNo()));
            }
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)detail.getDetailSeqID()), (Object)ResManager.loadKDString((String)"\u4e1a\u52a1\u660e\u7ec6ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FinancingChecker_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)detail.getAccNo()), (Object)ResManager.loadKDString((String)"\u8d4e\u56de\u7406\u8d22\u8d26\u6237\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FinancingChecker_9", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)detail.getProductCode()), (Object)ResManager.loadKDString((String)"\u8d4e\u56de\u7406\u8d22\u4ea7\u54c1\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"FinancingChecker_10", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((!StringUtils.isEmpty((String)detail.getAmount()) || !StringUtils.isEmpty((String)detail.getNumber()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8d4e\u56de\u91d1\u989d\u548c\u4efd\u6570\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"FinancingChecker_11", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((!"0".equalsIgnoreCase(detail.getAmount()) || !"0".equalsIgnoreCase(detail.getNumber()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8d4e\u56de\u91d1\u989d\u548c\u4efd\u6570\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a0\u3002", (String)"FinancingChecker_12", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }
}

