/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.other;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.entity.biz.banklogindetail.BankLoginDetailRequest;
import kd.ebg.aqap.common.entity.biz.banklogindetail.BankLoginDetailResponse;
import kd.ebg.aqap.common.entity.biz.banklogindetail.BankLoginDetailResponseBody;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankLoginDetailMethod
implements EBServiceMethod<BankLoginDetailRequest, BankLoginDetailResponse> {
    private BankLoginService bankLoginService;
    private BankLoginConfigService bankLoginConfigService;

    public BankLoginDetailResponse executeClientRequest(BankLoginDetailRequest request, EBContext context) {
        String bankLoginID = request.getBody().getBankLoginID();
        Preconditions.checkArgument((boolean)Objects.nonNull(bankLoginID), (Object)ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u524d\u7f6e\u673a\u3002", (String)"BankLoginDetailMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        String customId = context.getCustomID();
        this.bankLoginService = (BankLoginService)SpringContextUtil.getBean(BankLoginService.class);
        BankLogin bankLogin = this.bankLoginService.getByCustomIdAndLoginId(customId, bankLoginID);
        if (bankLogin == null || bankLogin.getKey() == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6b64\u524d\u7f6e\u673a\u4e0d\u5b58\u5728[%s]\u3002", (String)"BankLoginDetailMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]), bankLoginID));
        }
        this.bankLoginConfigService = (BankLoginConfigService)SpringContextUtil.getBean(BankLoginConfigService.class);
        List bankLoginConfigs = BankBundleManager.getInstance().getBankLoginConfig(bankLogin.getBankVersionId());
        HashSet returnField = new HashSet();
        bankLoginConfigs.stream().filter(b -> StringUtils.isEmpty((String)b.getBankConfigValue())).forEach(c -> returnField.add(c.getKey().getBankConfigId()));
        List bankLoginConfigKVNList = this.bankLoginConfigService.getBankLoginConfigKVNList(bankLoginID, customId);
        bankLoginConfigKVNList = bankLoginConfigKVNList.stream().filter(b -> returnField.contains(b.getBankConfigID())).collect(Collectors.toList());
        BankLoginDetailResponse response = new BankLoginDetailResponse();
        BankLoginDetailResponseBody body = new BankLoginDetailResponseBody();
        response.setBody(body);
        body.setBankLoginID(bankLoginID);
        body.setBankLoginName(bankLogin.getBankLoginName());
        body.setConfigs(bankLoginConfigKVNList);
        return response;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "bankLoginDetail";
    }
}

