/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.other;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kd.ebg.aqap.common.entity.biz.BankDetail;
import kd.ebg.aqap.common.entity.biz.BankFunInfo;
import kd.ebg.aqap.common.entity.biz.listbank.ListBankRequest;
import kd.ebg.aqap.common.entity.biz.listbank.ListBankResponse;
import kd.ebg.aqap.common.entity.biz.listbank.ListBankResponseBody;
import kd.ebg.aqap.common.framework.frame.Bank;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.frame.BankVersion;
import kd.ebg.aqap.common.framework.properties.BankPropertyFunItem;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.service.tenant.TenantService;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.file.FieldUtils;

public class ListBankMethod
implements EBServiceMethod<ListBankRequest, ListBankResponse> {
    private TenantService tenantService;

    public ListBankResponse executeClientRequest(ListBankRequest request, EBContext context) {
        this.tenantService = (TenantService)SpringContextUtil.getBean(TenantService.class);
        ListBankResponse response = new ListBankResponse();
        ListBankResponseBody responseBody = new ListBankResponseBody();
        response.setBody(responseBody);
        Collection banks = BankBundleManager.getInstance().getBanks();
        ArrayList<BankDetail> bankDetails = new ArrayList<BankDetail>(1);
        banks.stream().forEach(b -> ListBankMethod.addBankVersions(bankDetails, b, this.tenantService.isJDY(request.getHeader().getCustomId())));
        responseBody.setDetails(bankDetails);
        bankDetails.sort(Comparator.comparing(BankDetail::getBankVersionID));
        return response;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "listBank";
    }

    private static void addBankVersions(List<BankDetail> bankDetails, Bank bank, boolean isJDY) {
        for (BankVersion bankVersion : bank.getBankVersions()) {
            if (isJDY && (!isJDY || !bankVersion.isShowInJdy())) continue;
            BankDetail detail = new BankDetail();
            detail.setBankName(bank.getBankName());
            detail.setBankVersionName(bankVersion.getBankVersionName());
            detail.setBankVersionID(bankVersion.getBankVersionID());
            detail.setBankShortName(bank.getBankShortName());
            detail.setAlias(bank.getBankShortName());
            detail.setBankFunInfos(ListBankMethod.convert(bankVersion.getBankPropertyFunItems()));
            bankDetails.add(detail);
        }
    }

    static List<BankFunInfo> convert(List<BankPropertyFunItem> bankPropertyFunItems) {
        ArrayList<BankFunInfo> result = new ArrayList<BankFunInfo>(1);
        if (CollectionUtil.isNotEmpty(bankPropertyFunItems)) {
            bankPropertyFunItems.forEach(b -> {
                BankFunInfo bankFunInfo = new BankFunInfo();
                FieldUtils.fieldsCopy((Object)b, (Object)bankFunInfo);
                result.add(bankFunInfo);
            });
        }
        return result;
    }
}

