/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.other;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.entity.biz.listlicense.LicenseDetailInfo;
import kd.ebg.aqap.common.entity.biz.listlicense.ListLicenseDetailRequest;
import kd.ebg.aqap.common.entity.biz.listlicense.ListLicenseDetailResponse;
import kd.ebg.aqap.common.entity.biz.listlicense.ListLicenseDetailResponseBody;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.license.EbgLicenseModuleEnum;
import kd.ebg.egf.common.license.LicenseCache;
import kd.ebg.egf.common.license.TenantInfo;
import kd.ebg.egf.common.model.license.LicenseDetail;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ListLicenseDetailMethod
implements EBServiceMethod<ListLicenseDetailRequest, ListLicenseDetailResponse> {
    public ListLicenseDetailResponse executeClientRequest(ListLicenseDetailRequest listLicenseDetailRequest, EBContext context) {
        ListLicenseDetailResponse listLicenseDetailResponse = new ListLicenseDetailResponse();
        ListLicenseDetailResponseBody listLicenseDetailResponseBody = new ListLicenseDetailResponseBody();
        String customId = listLicenseDetailRequest.getHeader().getCustomId();
        if (StringUtils.isEmpty((String)customId)) {
            throw new EBPreCheckException(ResManager.loadKDString((String)"\u79df\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ListLicenseDetailMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        RequestContext current = RequestContext.get();
        if (!current.getTenantId().equalsIgnoreCase(customId)) {
            throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u79df\u6237\u53f7%1$s\u4e0e\u5f53\u524d\u73af\u5883\u79df\u6237\u53f7%2$s\u4e0d\u4e00\u81f4", (String)"ListLicenseDetailMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]), customId, current.getTenantId()));
        }
        TenantInfo tenant = LicenseCache.getTenant();
        List infos = tenant.getInfos();
        Map<String, List<LicenseDetail>> map = infos.stream().collect(Collectors.groupingBy(LicenseDetail::getModuleCode));
        listLicenseDetailResponseBody.setLicenseTotalCount(tenant.getTotalLicenseCount());
        listLicenseDetailResponseBody.setLicenseRemainCount(tenant.getUnusedLicenseCount());
        ArrayList licenseDetailInfos = new ArrayList(3);
        ArrayList ebgLicenseModuleEnums = Lists.newArrayList((Object[])EbgLicenseModuleEnum.values());
        Iterator iterator = ebgLicenseModuleEnums.iterator();
        while (iterator.hasNext()) {
            EbgLicenseModuleEnum next = (EbgLicenseModuleEnum)iterator.next();
            if (!"EBG_NOTE".equalsIgnoreCase(next.getModuleCode())) continue;
            iterator.remove();
        }
        List<EbgLicenseModuleEnum> sortList = ebgLicenseModuleEnums.stream().sorted(Comparator.comparing(EbgLicenseModuleEnum::getSort)).collect(Collectors.toList());
        sortList.forEach(ebgLicenseModuleEnum -> {
            LicenseDetailInfo licenseDetailInfo = new LicenseDetailInfo();
            String moduleCode = ebgLicenseModuleEnum.getModuleCode();
            String moduleName = ebgLicenseModuleEnum.getModuleName();
            licenseDetailInfo.setModuleCode(moduleCode);
            licenseDetailInfo.setModuleName(moduleName);
            List licenseDetails = (List)map.get(moduleCode);
            licenseDetailInfo.setUsedCount(CollectionUtil.isEmpty((Collection)licenseDetails) ? 0 : licenseDetails.size());
            licenseDetailInfos.add(licenseDetailInfo);
        });
        listLicenseDetailResponseBody.setDetails(licenseDetailInfos);
        listLicenseDetailResponse.setBody(listLicenseDetailResponseBody);
        return listLicenseDetailResponse;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "listLicenseDetail";
    }
}

