/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.other;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.business.apply.atomic.IApply;
import kd.ebg.aqap.business.apply.bank.BankApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankApplyResponse;
import kd.ebg.aqap.business.apply.utils.ApplyConvert;
import kd.ebg.aqap.common.entity.biz.apply.ApplyRequest;
import kd.ebg.aqap.common.entity.biz.apply.ApplyRequestBody;
import kd.ebg.aqap.common.entity.biz.tenant.UpdateTenantRequest;
import kd.ebg.aqap.common.entity.biz.tenant.UpdateTenantResponse;
import kd.ebg.aqap.common.entity.biz.tenant.UpdateTenantResponseBody;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.model.repository.DetailInfoRepository;
import kd.ebg.aqap.common.model.repository.DetailSyncRecordRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.tenant.Tenants;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginConfigRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.repository.tenant.TenantRespository;
import kd.ebg.egf.common.utils.CipherInfoUtil;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class UpdateTenantMethod
implements EBServiceMethod<UpdateTenantRequest, UpdateTenantResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(UpdateTenantMethod.class);
    private TenantRespository respository = (TenantRespository)SpringContextUtil.getBean(TenantRespository.class);
    private BankAcntRepository bankAcntRepository = (BankAcntRepository)SpringContextUtil.getBean(BankAcntRepository.class);
    private BankLoginRepository bankLoginRepository = (BankLoginRepository)SpringContextUtil.getBean(BankLoginRepository.class);
    private BankLoginConfigRepository bankLoginConfigRepository = (BankLoginConfigRepository)SpringContextUtil.getBean(BankLoginConfigRepository.class);
    private DetailSyncRecordRepository detailSyncRecordRepository = (DetailSyncRecordRepository)SpringContextUtil.getBean(DetailSyncRecordRepository.class);
    private DetailInfoRepository detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
    private CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);

    public UpdateTenantResponse executeClientRequest(UpdateTenantRequest request, EBContext context) {
        String oldCustomID = request.getBody().getOldCustomID();
        String newCustomID = request.getBody().getNewCustomID();
        this.logger.info("\u8c03\u7528\u79df\u6237\u66f4\u6539\u65b9\u6cd5\uff0c\u7531{}\u66f4\u65b0\u4e3a{}", new Object[]{oldCustomID, newCustomID});
        boolean isCosmic = request.getBody().isCosmic();
        DynamicObject oldTenants = null;
        if (!isCosmic) {
            oldTenants = this.checkCustomerID(oldCustomID, newCustomID);
        } else {
            this.checkCustomerIdCosmic(oldCustomID, newCustomID);
        }
        TXHandle h = TX.requiresNew();
        try {
            if (!isCosmic) {
                this.updateTenant(oldTenants, newCustomID);
            }
            this.updateAccnos(oldCustomID, newCustomID);
            this.updateBankLogin(oldCustomID, newCustomID);
            this.updateBankLoginConfig(oldCustomID, newCustomID);
            this.updateDetailSyncRecord(oldCustomID, newCustomID);
            this.updateDetailInfo(oldCustomID, newCustomID);
            this.updateCert(oldCustomID, newCustomID);
        }
        catch (Exception ex) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4fdd\u5b58\u62a5\u9519\uff1a", (String)"UpdateTenantMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]), (Throwable)ex);
        }
        finally {
            try {
                h.close();
            }
            catch (Throwable throwable) {}
        }
        if (!isCosmic) {
            this.updatePab(oldCustomID, newCustomID);
        }
        return new UpdateTenantResponse(new UpdateTenantResponseBody(true, ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"UpdateTenantMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0])));
    }

    private void updatePab(String oldCustomID, String newCustomID) {
        List acnts = this.bankAcntRepository.findByCustomID(newCustomID);
        if (acnts != null && acnts.size() > 0) {
            for (BankAcnt bankAcnt : acnts) {
                if (!"PAB_OPA".equals(bankAcnt.getBankVersionId())) continue;
                this.reApply(bankAcnt, oldCustomID, newCustomID);
            }
        }
    }

    private void reApply(BankAcnt acnt, String oldCustomID, String newCustomID) {
        EBContext context = EBContext.getContext();
        ApplyRequest request = new ApplyRequest();
        ApplyRequestBody body = new ApplyRequestBody();
        try {
            request.setBody(body);
            body.setAccNo(acnt.getAccNo());
            body.setAccName(acnt.getAccName());
            body.setFunKey("DETAIL,BALANCE");
            context.setCustomID(oldCustomID);
            this.apply(acnt.getBankVersionId(), acnt.getBankLoginId(), request, context, "D");
        }
        catch (Exception ex) {
            this.logger.info("\u5e73\u5b89\u8d26\u53f7{}\u5728\u65e7\u79df\u6237\u53f7{}\u89e3\u7ea6\u5931\u8d25{}", new Object[]{acnt.getAccNo(), oldCustomID, ex.getMessage()});
        }
        try {
            context.setCustomID(newCustomID);
            this.apply(acnt.getBankVersionId(), acnt.getBankLoginId(), request, context, "A");
        }
        catch (Exception ex) {
            this.logger.info("\u5e73\u5b89\u8d26\u53f7{}\u5728\u65b0\u79df\u6237\u53f7{}\u7b7e\u7ea6\u5931\u8d25{}", new Object[]{acnt.getAccNo(), newCustomID, ex.getMessage()});
        }
    }

    private void updateCert(String oldCustomID, String newCustomID) {
        DynamicObject[] dynamicObjects = this.certRepository.loadByCustomID(oldCustomID);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("custom_id", (Object)newCustomID);
                this.logger.info("\u79df\u6237\u53f7{}\u7684\u8bc1\u4e66\u9700\u6839\u636e\u65b0\u79df\u6237\u53f7\u91cd\u65b0\u52a0\u5bc6", (Object)oldCustomID);
                try {
                    String oldCert = dynamicObject.getString("bank_config_value_tag");
                    CipherInfo cipherInfo = CipherInfoUtil.getCipherInfo((String)oldCert);
                    byte[] bytes = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)oldCustomID, (int)cipherInfo.getCipherVersion(), (String)"");
                    this.logger.info("\u79df\u6237\u53f7{}\u7684\u8bc1\u4e66\u89e3\u5bc6\u6210\u529f", (Object)oldCustomID);
                    String newCert = DesUtil.encryptProxyCert((byte[])bytes, (String)newCustomID);
                    this.logger.info("\u79df\u6237\u53f7{}\u7684\u8bc1\u4e66\u91cd\u65b0\u52a0\u5bc6\u6210\u529f", (Object)oldCustomID);
                    dynamicObject.set("bank_config_value_tag", (Object)newCert);
                }
                catch (Exception ex) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bc1\u4e66\u91cd\u65b0\u52a0\u5bc6\u5931\u8d25\uff1a", (String)"UpdateTenantMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]), (Throwable)ex);
                }
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    private void updateDetailSyncRecord(String oldCustomID, String newCustomID) {
        DynamicObject[] dynamicObjects = this.detailSyncRecordRepository.loadByCustomID(oldCustomID);
        this.save(dynamicObjects, newCustomID);
    }

    private void updateDetailInfo(String oldCustomID, String newCustomID) {
        DynamicObject[] dynamicObjects = this.detailInfoRepository.loadByCustomID(oldCustomID);
        this.save(dynamicObjects, newCustomID);
    }

    private void updateBankLoginConfig(String oldCustomID, String newCustomID) {
        DynamicObject[] dynamicObjects = this.bankLoginConfigRepository.loadByCustomID(oldCustomID);
        this.save(dynamicObjects, newCustomID);
    }

    private void updateBankLogin(String oldCustomID, String newCustomID) {
        DynamicObject[] dynamicObjects = this.bankLoginRepository.loadByCustomID(oldCustomID);
        this.save(dynamicObjects, newCustomID);
    }

    private void updateTenant(DynamicObject oldTenant, String newCustomID) {
        oldTenant.set("modifytime", (Object)new Date());
        oldTenant.set("custom_id", (Object)newCustomID);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oldTenant});
    }

    private void updateAccnos(String oldCustomID, String newCustomID) {
        DynamicObject[] dynamicObjects = this.bankAcntRepository.loadByCustomID(oldCustomID);
        this.save(dynamicObjects, newCustomID);
    }

    private void save(DynamicObject[] dynamicObjects, String newCustomID) {
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("custom_id", (Object)newCustomID);
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    private void checkCustomerIdCosmic(String oldCustomID, String newCustomID) {
        if (StringUtils.isEmpty((String)oldCustomID)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u539f\u79df\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"UpdateTenantMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)newCustomID)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65b0\u79df\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"UpdateTenantMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }

    private DynamicObject checkCustomerID(String oldCustomID, String newCustomID) {
        this.checkCustomerIdCosmic(oldCustomID, newCustomID);
        if (!(newCustomID.startsWith("JDY") || newCustomID.startsWith("YKJ") || newCustomID.startsWith("PRO"))) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65b0\u79df\u6237\u53f7\u7ec4\u6210\u4e0d\u7b26\u5408\u89c4\u5219", (String)"UpdateTenantMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        DynamicObject tenants = this.respository.loadByCustomID(oldCustomID);
        if (tenants == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u539f\u79df\u6237\u53f7\u672a\u627e\u5230\u76f8\u5173\u79df\u6237\u6ce8\u518c\u8bb0\u5f55\uff0c\u65e0\u6cd5\u4fee\u6539", (String)"UpdateTenantMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        Tenants newTenants = this.respository.findByCustomNo(newCustomID);
        if (newTenants != null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65b0\u79df\u6237\u53f7\u5df2\u5b58\u5728\u76f8\u5173\u79df\u6237\u6ce8\u518c\u8bb0\u5f55\uff0c\u65e0\u6cd5\u4fee\u6539", (String)"UpdateTenantMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        return tenants;
    }

    public EBBankApplyResponse apply(String bankVersionID, String bankLoginID, ApplyRequest request, EBContext context, String applyType) {
        IApply apply = (IApply)BankBundleManager.getInstance().getImpl(bankVersionID, IApply.class, (Object)request);
        context.setBankVersionID(bankVersionID);
        context.setBankLoginID(bankLoginID);
        context.initParameter();
        EBHeader header = new EBHeader();
        header.setBizType("apply");
        header.setSubBizType("apply");
        header.setLogBizSeqID(context.getLogBizSeqID());
        header.setCustomId(context.getCustomID());
        request.setHeader(header);
        BankApplyRequest bankApplyRequest = ApplyConvert.convert(request);
        bankApplyRequest.setApplyType(applyType);
        return apply.apply(bankApplyRequest);
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return ResManager.loadKDString((String)"\u79df\u6237\u53f7\u53d8\u66f4", (String)"UpdateTenantMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }
}

