/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.file.atomic.IUpload;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.business.payment.exception.InvalidPaymentResult;
import kd.ebg.aqap.business.payment.intercept.PayControlManager;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.business.payment.utils.OverseaPaymentConvertUtil;
import kd.ebg.aqap.business.payment.utils.PaymentConvert;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.pay.OverseaPayRequest;
import kd.ebg.aqap.common.entity.biz.pay.OverseaPayResponse;
import kd.ebg.aqap.common.entity.biz.pay.PayRequest;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBDuplicateException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.service.file.PayAttachmentService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OverseaPayMethod
implements EBServiceMethod<OverseaPayRequest, OverseaPayResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(OverseaPayMethod.class);

    public OverseaPayRequest mappingCurrency(OverseaPayRequest request) {
        List list = request.getBody().getDetails();
        HashMap currencyMap = new HashMap(16);
        list.stream().forEach(item -> {
            String currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(item.getPayCurrency(), currencyMap);
            item.setPayCurrency(currency);
            currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(item.getPayerFeeCurrency(), currencyMap);
            item.setPayerFeeCurrency(currency);
            currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(item.getExchangeCurrency(), currencyMap);
            item.setExchangeCurrency(currency);
            currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(item.getProxyFeeCurrency(), currencyMap);
            item.setProxyFeeCurrency(currency);
        });
        return request;
    }

    public OverseaPayResponse mappingCurrency(OverseaPayResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getDetails();
            HashMap currencyMap = new HashMap(16);
            list.stream().forEach(item -> {
                String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getPayCurrency(), currencyMap);
                item.setPayCurrency(currency);
                currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getPayerFeeCurrency(), currencyMap);
                item.setPayerFeeCurrency(currency);
                currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getExchangeCurrency(), currencyMap);
                item.setExchangeCurrency(currency);
                currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getProxyFeeCurrency(), currencyMap);
                item.setProxyFeeCurrency(currency);
            });
        }
        return response;
    }

    public OverseaPayResponse executeClientRequest(OverseaPayRequest request, EBContext context) {
        Set<List<PaymentInfo>> set;
        List<PaymentInfo> validPaymentInfos;
        List<PaymentInfo> paymentInfos;
        AccessUtils.checkPaymentAllowed(context);
        boolean isBatchRollBack = PaymentUtil.isBatchPayRollBack((EBRequest)request);
        InvalidPaymentResult paymentResult = new InvalidPaymentResult(isBatchRollBack);
        try {
            this.checkStructure(request);
            String batchSeqID = request.getBody().getBatchSeqID();
            this.checkBatchSeqIDUnique(batchSeqID);
            PaymentUtil.checkExplanationSpecialCharPool((EBRequest)request, paymentResult);
            PaymentUtil.checkBizNO((EBRequest)request);
            PayRequest payRequest = OverseaPaymentConvertUtil.getPayRequest(request);
            paymentInfos = PaymentConvert.convertPay(payRequest);
            PaymentUtil.checkInvalidPayments(paymentInfos, paymentResult);
            OverseaPaymentConvertUtil.complementOverseaPayDetail(paymentInfos, request, paymentResult);
            PaymentUtil.checkBookingTime(paymentInfos);
            PaymentUtil.payRouteTrace(paymentInfos);
            PaymentUtil.payPriority(paymentInfos);
            PaymentUtil.preTreatment(paymentInfos, paymentResult);
            PaymentUtil.execCheck(paymentInfos, paymentResult);
            PayControlManager.checkPaymentInfos(paymentInfos);
            validPaymentInfos = paymentResult.getValidPaymentInfoList(paymentInfos);
            set = PaymentUtil.packagePay(validPaymentInfos);
            PaymentUtil.recountTotalAmount(set);
        }
        catch (IllegalArgumentException | EBServiceException e) {
            throw EBExceiptionUtil.preCheckException((String)e.getMessage(), (Throwable)e);
        }
        catch (EBDuplicateException e) {
            throw EBExceiptionUtil.duplicateException((String)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.preCheckException((String)e.getMessage(), (Throwable)e);
        }
        this.handlePayAttachment(validPaymentInfos);
        PaymentUtil.insertPay(validPaymentInfos);
        PaymentUtil.async(set, (EBRequest)request);
        return OverseaPaymentConvertUtil.convert2OverseaPaymentResponse(paymentInfos, request);
    }

    private void handlePayAttachment(List<PaymentInfo> validPaymentInfos) {
        for (int i = 0; i < validPaymentInfos.size(); ++i) {
            ArrayList<PayAttachment> attachments = new ArrayList<PayAttachment>(validPaymentInfos.size());
            PaymentInfo paymentInfo = validPaymentInfos.get(i);
            String fileList = paymentInfo.getFileList();
            if (StringUtils.isNotEmpty((String)fileList)) {
                String[] fileLists;
                IUpload iUpload = null;
                try {
                    PayAttachment attachment = new PayAttachment();
                    iUpload = (IUpload)BankBundleManager.getInstance().getImpl(paymentInfo.getBankVersionID(), IUpload.class, (Object)attachment);
                }
                catch (EBPreCheckException e) {
                    this.logger.info(e.getMessage());
                    continue;
                }
                for (String fileUrl : fileLists = fileList.split(";")) {
                    PayAttachment payAttachment = new PayAttachment();
                    payAttachment.setCustomID(paymentInfo.getCustomID());
                    payAttachment.setBankVersionID(paymentInfo.getBankVersionID());
                    payAttachment.setBankLoginID(paymentInfo.getBankLoginID());
                    payAttachment.setBankBatchSeqID(paymentInfo.getBankBatchSeqID());
                    payAttachment.setBankDetailSeqID(paymentInfo.getBankDetailSeqID());
                    try {
                        fileUrl = URLDecoder.decode(fileUrl, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    payAttachment.setDownloadUrl(fileUrl);
                    String path = fileUrl.substring(fileUrl.lastIndexOf("path=/") + 6);
                    payAttachment.setFilePath(path);
                    payAttachment.setFileName(path.substring(path.lastIndexOf("/") + 1));
                    payAttachment.setStatus(Integer.valueOf(AttachmentState.INITIAL.getId()));
                    payAttachment.setStatusName(AttachmentState.INITIAL.getEnName());
                    payAttachment.setStatusMsg(AttachmentState.INITIAL.getCnName());
                    payAttachment.setEnable(Integer.valueOf(Integer.parseInt("1")));
                    payAttachment.setImplClassName(iUpload.getClass().getName());
                    payAttachment.setQueryImplClassName("");
                    payAttachment.setInsertTime(LocalDateTime.now());
                    payAttachment.setUpdateTime(LocalDateTime.now());
                    attachments.add(payAttachment);
                }
            }
            if (attachments.size() <= 0) continue;
            PayAttachmentService attachmentService = (PayAttachmentService)SpringContextUtil.getBean(PayAttachmentService.class);
            attachmentService.saveAttachments(attachments);
        }
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return BizName.OVERSEAPAY.name();
    }

    private void checkStructure(OverseaPayRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)MultiLang.getRequestEmptyTip());
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)MultiLang.getRequestHeaderEmptyTip());
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)MultiLang.getRequestBodyEmptyTip());
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OverseaPayMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)MultiLang.getBatchNotEmptyTip());
        Preconditions.checkState((!PaymentInfoService.getInstance().batchSeqIDExist(batchSeqID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"batchSeqID \u5df2\u7ecf\u5b58\u5728\u3002", (String)"OverseaPayMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
    }
}

