/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment;

import com.google.common.base.Preconditions;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.business.payment.utils.LinkPayUtils;
import kd.ebg.aqap.common.entity.biz.paystatus.PayStatusDetail;
import kd.ebg.aqap.common.entity.biz.paystatus.PayStatusRequest;
import kd.ebg.aqap.common.entity.biz.paystatus.PayStatusResponse;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.entity.biz.status.UpdateOpState;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.services.LinkPaymentInfoService;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.LinkPaymentInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class UpdatePayStatusMethod
implements EBServiceMethod<PayStatusRequest, PayStatusResponse> {
    public PayStatusResponse executeClientRequest(PayStatusRequest request, EBContext context) {
        this.checkStructure(request);
        List details = request.getBody().getDetails();
        HashSet bathSeqID = new HashSet();
        details.forEach(detail -> {
            Preconditions.checkArgument((detail.getModifyStatus() == 12 || detail.getModifyStatus() == 13 ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u679a\u4e3e\u6709\u8bef\u3002", (String)"UpdatePayStatusMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((!StrUtil.isEmpty((String)detail.getUpdateReason()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u4fee\u6539\u7406\u7531\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdatePayStatusMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            bathSeqID.add(detail.getBatchSeqID());
        });
        bathSeqID.forEach(id -> this.checkBatchSeqIDUnique((String)id));
        PaymentInfoService service = PaymentInfoService.getInstance();
        List detailList = request.getBody().getDetails();
        for (PayStatusDetail detail2 : detailList) {
            List infos = service.selectByBatchSeqIDAndDetailSeqID(detail2.getBatchSeqID(), detail2.getDetailSeqID());
            if (infos.size() == 1) {
                PaymentInfo info = (PaymentInfo)infos.get(0);
                PaymentState paymentState = PaymentState.getEnumById((int)info.getStatus());
                EbStatus status = EbStatus.convertBankState2EBG((PaymentState)paymentState);
                int currentStatus = info.getStatus();
                if (currentStatus != PaymentState.UNKNOWN.getId() && currentStatus != PaymentState.SUCCESS.getId() && currentStatus != PaymentState.FAIL.getId()) {
                    detail2.setEbStatus(status.getName());
                    detail2.setUpdateStatus("BANK_FAIL");
                    detail2.setEbStatusMsg(ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff0c\u5f53\u524d\u4ed8\u6b3e\u72b6\u6001\u4e0d\u5728\u53ef\u4fee\u6539\u72b6\u6001\u8303\u56f4\u5185\u3002", (String)"UpdatePayStatusMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    continue;
                }
                String setEbStatusMsg = "";
                String tip = info.getStatusMsg();
                if (info.isBookPayFlag() && info.getBookingTime() != null) {
                    String payDate = info.getBookingTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    tip = String.format(ResManager.loadKDString((String)"\u672c\u7b14\u4ed8\u6b3e\u4e3a\u9884\u7ea6\u4ed8\u6b3e\uff0c\u9884\u7ea6\u65e5\u671f\u4e3a%1$s\uff1b%2$s", (String)"PaymentConvert_3", (String)"ebg-aqap-business", (Object[])new Object[0]), payDate, tip);
                }
                setEbStatusMsg = PaymentState.FAIL.getId() == info.getStatus().intValue() && !StringUtils.isEmpty((String)info.getBankMsg()) ? String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%1$s\uff0c\u539f\u56e0\uff1a%2$s\u3002", (String)"UpdatePayStatusMethod_25", (String)"ebg-aqap-business", (Object[])new Object[0]), tip, info.getBankMsg()) : (StringUtils.isEmpty((String)info.getErrorMsg()) || info.getErrorMsg().startsWith(info.getStatusMsg()) ? String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%s\u3002", (String)"PaymentConvert_24", (String)"ebg-aqap-business", (Object[])new Object[0]), tip) : String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%1$s,%2$s", (String)"PaymentConvert_26", (String)"ebg-aqap-business", (Object[])new Object[0]), tip, info.getErrorMsg()));
                info.setBackStatus(info.getStatus());
                info.setBackStatusMsg(info.getStatusMsg());
                PaymentInfo infoClone = new PaymentInfo();
                FieldUtils.fieldsCopy((Object)info, (Object)infoClone);
                PaymentState state = PaymentState.getEnumById((int)detail2.getModifyStatus());
                info.setStatus(Integer.valueOf(state.getId()));
                info.setStatusName(state.getEnName());
                info.setStatusMsg(state.getCnName());
                info.setUpdateOperation(UpdateOpState.MANUAL.getId());
                info.setReason(detail2.getUpdateReason());
                info.setOperator(detail2.getOperator());
                try {
                    service.updateInManual(infos);
                    String statusMsg = ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u5b8c\u6210", (String)"UpdatePayStatusMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]);
                    statusMsg = statusMsg + "(" + info.bankMsgDetails() + ";" + setEbStatusMsg + ")";
                    detail2.setEbStatusMsg(statusMsg);
                }
                catch (Exception e) {
                    detail2.setUpdateStatus("BANK_FAIL");
                    detail2.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff1a%s\u3002", (String)"UpdatePayStatusMethod_12", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage()));
                }
                infos = service.selectByBatchSeqIDAndDetailSeqID(detail2.getBatchSeqID(), detail2.getDetailSeqID());
                paymentState = PaymentState.getEnumById((int)((PaymentInfo)infos.get(0)).getStatus());
                status = EbStatus.convertBankState2EBG((PaymentState)paymentState);
                detail2.setEbStatus(status.getName());
                if (paymentState.getId() == detail2.getModifyStatus()) {
                    detail2.setUpdateStatus("BANK_SUCCESS");
                    continue;
                }
                detail2.setUpdateStatus("BANK_FAIL");
                continue;
            }
            if (infos.size() == 0) {
                this.updateLinkPayment(detail2);
                continue;
            }
            detail2.setEbStatusMsg(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u591a\u6761\u8bb0\u5f55\u653e\u5f03\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"UpdatePayStatusMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail2.setUpdateStatus("BANK_FAIL");
        }
        PayStatusResponse response = new PayStatusResponse();
        response.setBody(request.getBody());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkPayment(PayStatusDetail detail) {
        LinkPaymentInfoService linkPayService = LinkPaymentInfoService.getInstance();
        List linkPaymentInfos = linkPayService.selectByBatchSeqIdAndDetailSeqId(detail.getBatchSeqID(), detail.getDetailSeqID());
        if (linkPaymentInfos.size() == 1) {
            LinkPaymentInfo linkPaymentInfo = (LinkPaymentInfo)linkPaymentInfos.get(0);
            PaymentInfoService paymentInfoService = PaymentInfoService.getInstance();
            List paymentInfos = paymentInfoService.selectByBatchSeqIDAndLinkpayDetailSeqId(linkPaymentInfo.getBatchSeqId(), linkPaymentInfo.getDetailSeqId());
            ListIterator infoIterator = paymentInfos.listIterator();
            while (infoIterator.hasNext()) {
                PaymentInfo paymentInfo = (PaymentInfo)infoIterator.next();
                boolean isUnknown = paymentInfo.getStatus().intValue() == PaymentState.UNKNOWN.getId();
                boolean isManual = UpdateOpState.MANUAL.getId().equalsIgnoreCase(paymentInfo.getUpdateOperation());
                if (isUnknown || isManual) continue;
                infoIterator.remove();
            }
            if (paymentInfos.isEmpty()) {
                detail.setUpdateStatus(EbStatus.BANK_FAIL.getName());
                detail.setEbStatus(linkPaymentInfo.getEbStatus());
                detail.setEbStatusMsg(ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff0c\u5f53\u524d\u4ed8\u6b3e\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"UpdatePayStatusMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
            } else {
                PaymentState state = PaymentState.getEnumById((int)detail.getModifyStatus());
                for (PaymentInfo info : paymentInfos) {
                    info.setStatus(Integer.valueOf(state.getId()));
                    info.setStatusName(state.getEnName());
                    info.setStatusMsg(state.getCnName());
                    info.setUpdateOperation(UpdateOpState.MANUAL.getId());
                    info.setReason(detail.getUpdateReason());
                    info.setOperator(detail.getOperator());
                    try (TXHandle h = TX.requiresNew();){
                        paymentInfoService.updateInManual(paymentInfos);
                        if ("linkPay_pay".equalsIgnoreCase(info.getLinkpayType())) {
                            EbStatus status = EbStatus.convertBankState2EBG((PaymentState)state);
                            linkPaymentInfo.setEbStatus(status.getName());
                            linkPaymentInfo.setEbStatusMsg(status == EbStatus.BANK_SUCCESS ? LinkPayUtils.LINKPAY_STATUS_SUCCESS_MANUAL : LinkPayUtils.LINKPAY_STATUS_FAIL_MANUAL);
                        } else {
                            linkPaymentInfo.setEbStatus(EbStatus.BANK_FAIL.getName());
                            linkPaymentInfo.setEbStatusMsg(LinkPayUtils.LINKPAY_STATUS_FAIL_MANUAL);
                        }
                        linkPayService.updateLinkPaymentInfo(linkPaymentInfos);
                        detail.setEbStatusMsg(ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u5b8c\u6210", (String)"UpdatePayStatusMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    }
                    List payInfos = paymentInfoService.selectByBatchSeqIDAndDetailSeqID(info.getBatchSeqID(), info.getDetailSeqID());
                    PaymentState paymentState = PaymentState.getEnumById((int)((PaymentInfo)payInfos.get(0)).getStatus());
                    if (paymentState.getId() == detail.getModifyStatus()) {
                        detail.setUpdateStatus(EbStatus.BANK_SUCCESS.getName());
                    } else {
                        detail.setUpdateStatus(EbStatus.BANK_FAIL.getName());
                    }
                    EbStatus status = EbStatus.convertBankState2EBG((PaymentState)paymentState);
                    detail.setEbStatus(status.getName());
                }
            }
        } else if (linkPaymentInfos.size() == 0) {
            detail.setEbStatusMsg(ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u6b64\u4ed8\u6b3e\u8bb0\u5f55\u3002", (String)"UpdatePayStatusMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail.setUpdateStatus("BANK_FAIL");
        } else {
            detail.setEbStatusMsg(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u591a\u6761\u8bb0\u5f55\u653e\u5f03\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"UpdatePayStatusMethod_9", (String)"ebg-aqap-business", (Object[])new Object[0]));
            detail.setUpdateStatus("BANK_FAIL");
        }
    }

    private void checkStructure(PayStatusRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)MultiLang.getRequestEmptyTip());
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)MultiLang.getRequestHeaderEmptyTip());
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)MultiLang.getRequestBodyEmptyTip());
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u4fee\u6539\u4ed8\u6b3e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UpdatePayStatusMethod_10", (String)"ebg-aqap-business", (Object[])new Object[0]));
                if (request.getBody().getDetails() != null) {
                    Preconditions.checkArgument((request.getBody().getTotalCount() == request.getBody().getDetails().size() ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u66f4\u65b0\u7b14\u6570\u4e0e\u5b9e\u9645\u4e0d\u7b26\u3002", (String)"UpdatePayStatusMethod_11", (String)"ebg-aqap-business", (Object[])new Object[0]));
                }
            }
        }
    }

    private void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)MultiLang.getBatchNotEmptyTip());
        Preconditions.checkState((boolean)PaymentInfoService.getInstance().batchSeqIDExist(batchSeqID), (Object)MultiLang.getBatchEmptyTip());
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return BizName.UPDATE_PAY_STATUS.name();
    }
}

