/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.exception;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.aqap.business.payment.duplication.DuplicationPaymentResult;
import kd.ebg.aqap.business.payment.exception.IllegalPaymentResult;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.LinkPaymentInfo;
import kd.ebg.aqap.common.model.PaymentInfo;

public class InvalidPaymentResult {
    private boolean batchRollBack;
    private boolean hasInvalid;
    private Map<String, String> InvalidPayments = new HashMap<String, String>(16);

    public InvalidPaymentResult() {
    }

    public InvalidPaymentResult(boolean isBatchRollBack) {
        this.batchRollBack = isBatchRollBack;
    }

    public void addIllegalPaymentResult(IllegalPaymentResult result) {
        this.setHasInvalid(result.isHasIllegal() || this.isHasInvalid());
        if (result.getIllegalPayments() != null) {
            for (Map.Entry<String, String> entry : result.getIllegalPayments().entrySet()) {
                if (this.InvalidPayments.containsKey(entry.getKey())) {
                    String errorMsg = this.InvalidPayments.get(entry.getKey()) + "\uff1b" + entry.getValue();
                    this.InvalidPayments.put(entry.getKey(), errorMsg);
                    continue;
                }
                this.InvalidPayments.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addDuplicationPaymentResult(DuplicationPaymentResult result) {
        this.setHasInvalid(result.isHasDuplication() || this.isHasInvalid());
        if (result.getDuplicationPayments() != null) {
            for (Map.Entry<String, String> entry : result.getDuplicationPayments().entrySet()) {
                if (this.InvalidPayments.containsKey(entry.getKey())) {
                    String errorMsg = this.InvalidPayments.get(entry.getKey()) + "\uff1b" + entry.getValue();
                    this.InvalidPayments.put(entry.getKey(), errorMsg);
                    continue;
                }
                this.InvalidPayments.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean isHasInvalid() {
        return this.hasInvalid;
    }

    public void setHasInvalid(boolean hasInvalid) {
        this.hasInvalid = hasInvalid;
    }

    public List<PaymentInfo> getValidPaymentInfoList(List<PaymentInfo> paymentInfos) {
        if (this.isBatchRollBack()) {
            return paymentInfos;
        }
        ArrayList<PaymentInfo> paymentInfoList = new ArrayList<PaymentInfo>(16);
        paymentInfos.stream().forEach(paymentInfo -> {
            if (!this.InvalidPayments.containsKey(paymentInfo.getDetailSeqID())) {
                paymentInfo.setErrorMsg("");
                paymentInfoList.add((PaymentInfo)paymentInfo);
            } else {
                paymentInfo.setStatus(Integer.valueOf(PaymentState.ROLL_BACK.getId()));
                paymentInfo.setStatusName(PaymentState.ROLL_BACK.getEnName());
                paymentInfo.setStatusMsg(PaymentState.ROLL_BACK.getCnName());
                paymentInfo.setErrorMsg(this.InvalidPayments.get(paymentInfo.getDetailSeqID()));
            }
        });
        return paymentInfoList;
    }

    public List<String> getValidLinkPaymentDetailSeqList(List<LinkPaymentInfo> linkPaymentInfos) {
        ArrayList<String> detailSeqList = new ArrayList<String>(16);
        if (this.isBatchRollBack()) {
            linkPaymentInfos.stream().forEach(paymentInfo -> detailSeqList.add(paymentInfo.getDetailSeqId()));
        } else {
            linkPaymentInfos.stream().forEach(paymentInfo -> {
                if (!this.InvalidPayments.containsKey(paymentInfo.getDetailSeqId())) {
                    detailSeqList.add(paymentInfo.getDetailSeqId());
                } else {
                    paymentInfo.setEbStatus(EbStatus.EB_ROLL_BACK.getName());
                    paymentInfo.setEbStatusMsg(this.InvalidPayments.get(paymentInfo.getDetailSeqId()));
                }
            });
        }
        return detailSeqList;
    }

    public boolean isBatchRollBack() {
        return this.batchRollBack;
    }

    public void setBatchRollBack(boolean batchRollBack) {
        this.batchRollBack = batchRollBack;
    }
}

