/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.intercept;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.intercept.IPayControl;
import kd.ebg.aqap.business.payment.intercept.IStringConvert;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.log.EBGLogger;

public abstract class PayControlAction
implements IPayControl,
IStringConvert {
    EBGLogger log = EBGLogger.getInstance().getLogger(PayControlAction.class);
    private Boolean legal;
    private Map<Integer, String> showErrors = new HashMap<Integer, String>(16);
    private List<String> baseLines;
    private Map<PaymentInfo, String> reasons = new HashMap<PaymentInfo, String>(16);

    @Override
    public final boolean legalPay(List<PaymentInfo> payments, List<String> baseLines) {
        this.baseLines = baseLines;
        this.legal = Boolean.TRUE;
        for (int i = 0; i < payments.size(); ++i) {
            PaymentInfo info = payments.get(i);
            Object targetValue = this.getValue(info);
            if (Objects.isNull(targetValue)) continue;
            boolean triggered = this.trigger(targetValue, baseLines);
            if (triggered) {
                String reason = this.echo(targetValue);
                this.showErrors.put(i + 1, reason);
                this.reasons.put(info, reason);
            }
            this.legal = !triggered && this.legal != false;
            if (this.onlyOnce()) break;
        }
        this.legal = this.legal != false && this.afterAll();
        if (this.legal.booleanValue()) {
            this.log.info("\u5f53\u524d\u4ed8\u6b3e\u4fe1\u606f\u5168\u6ee1\u8db3\u4ed8\u6b3e\u63a7\u5236\u7b56\u7565");
        }
        return this.legal;
    }

    protected abstract Object getValue(PaymentInfo var1);

    protected boolean trigger(Object value, List<String> forbiddenValues) {
        return forbiddenValues.contains(this.stringValue(value));
    }

    @Override
    public final String echos() {
        if (this.legal != null && !this.legal.booleanValue()) {
            return MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u6761\u4ed8\u6b3e\u4fe1\u606f\u4e0d\u6ee1\u8db3\u6309{1}\u63a7\u5236\u7b56\u7565\uff0c\u57fa\u51c6\u7b56\u7565\u503c\u4e3a\uff1a{2}\uff0c\u6240\u4f20\u503c\u4e0d\u5408\u6cd5\uff01", (String)"PayControlAction_0", (String)"ebg-aqap-business", (Object[])new Object[0]), this.showErrors.keySet(), this.getStrategy().getDesc(), this.baseLines);
        }
        return null;
    }

    private String echo(Object currentValue) {
        String echo = ResManager.loadKDString((String)"\u8be5\u4ed8\u6b3e\u4fe1\u606f\u4e0d\u6ee1\u8db3\u6309{0}\u63a7\u5236\u7b56\u7565\uff0c\u5df2\u8bbe\u7f6e\u7981\u6b62\u51fa\u73b0\u503c\u4e3a{1}\uff0c\u5f53\u524d\u503c\u4e3a{2}\uff0c\u4e0d\u5408\u6cd5\u3002", (String)"PayControlAction_1", (String)"ebg-aqap-business", (Object[])new Object[0]);
        return MessageFormat.format(echo, this.getStrategy().getDesc(), this.baseLines, this.stringValue(currentValue));
    }

    @Override
    public List<PaymentInfo> getIntecepts() {
        return Arrays.asList(this.reasons.keySet().toArray(new PaymentInfo[this.reasons.size()]));
    }

    @Override
    public Map<PaymentInfo, String> reasons() {
        return this.reasons;
    }

    protected boolean afterAll() {
        return true;
    }

    protected boolean onlyOnce() {
        return false;
    }

    public EBGLogger getLog() {
        return this.log;
    }

    public void setLog(EBGLogger log) {
        this.log = log;
    }

    public Boolean getLegal() {
        return this.legal;
    }

    public void setLegal(Boolean legal) {
        this.legal = legal;
    }

    public Map<Integer, String> getShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(Map<Integer, String> showErrors) {
        this.showErrors = showErrors;
    }

    public List<String> getBaseLines() {
        return this.baseLines;
    }

    public void setBaseLines(List<String> baseLines) {
        this.baseLines = baseLines;
    }

    public Map<PaymentInfo, String> getReasons() {
        return this.reasons;
    }

    public void setReasons(Map<PaymentInfo, String> reasons) {
        this.reasons = reasons;
    }
}

