/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.priority;

import java.math.BigDecimal;
import kd.ebg.aqap.business.payment.priority.PayPriority;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PayRuleInfo {
    private String key;
    private String condition;
    private String value;

    public PayRuleInfo(String key, String condition, String value) {
        this.key = key;
        this.condition = condition;
        this.value = value;
    }

    public boolean match(PayPriority payPriority) {
        if ("subBizType".equalsIgnoreCase(this.key)) {
            for (String subType : this.value.split(";")) {
                if (!subType.equalsIgnoreCase(payPriority.getSubBizType())) continue;
                return true;
            }
        } else if ("amount".equalsIgnoreCase(this.key)) {
            BigDecimal amount = new BigDecimal(this.value);
            if ("=".equalsIgnoreCase(this.condition)) {
                return payPriority.getAmount().compareTo(amount) == 0;
            }
            if (">=".equalsIgnoreCase(this.condition)) {
                return payPriority.getAmount().compareTo(amount) >= 0;
            }
            if (">".equalsIgnoreCase(this.condition)) {
                return payPriority.getAmount().compareTo(amount) > 0;
            }
            if ("<=".equalsIgnoreCase(this.condition)) {
                return payPriority.getAmount().compareTo(amount) <= 0;
            }
            if ("<".equalsIgnoreCase(this.condition)) {
                return payPriority.getAmount().compareTo(amount) < 0;
            }
        } else {
            if ("currency".equalsIgnoreCase(this.key)) {
                return payPriority.getCurrency().equalsIgnoreCase(this.value);
            }
            if ("explanation".equalsIgnoreCase(this.key) || "useCn".equalsIgnoreCase(this.key)) {
                String str = payPriority.getExplanation();
                if ("useCn".equalsIgnoreCase(this.key)) {
                    str = payPriority.getUseCn();
                }
                if ("like".equalsIgnoreCase(this.condition)) {
                    return str.indexOf(this.value) >= 0;
                }
                if ("not like".equalsIgnoreCase(this.condition)) {
                    return str.indexOf(this.value) < 0;
                }
                if ("null".equalsIgnoreCase(this.condition)) {
                    return StringUtils.isEmpty((String)str);
                }
                if ("not null".equalsIgnoreCase(this.condition)) {
                    return StringUtils.isNotEmpty((String)str);
                }
                return str.equalsIgnoreCase(this.value);
            }
            if ("individual".equalsIgnoreCase(this.key)) {
                return payPriority.isIndividual() == Boolean.parseBoolean(this.value);
            }
            if ("sameBank".equalsIgnoreCase(this.key)) {
                return payPriority.isSameBank() == Boolean.parseBoolean(this.value);
            }
            if ("merge".equalsIgnoreCase(this.key)) {
                return payPriority.isMerge() == Boolean.parseBoolean(this.value);
            }
        }
        return false;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

