/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.route;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.route.PayRoute;
import kd.ebg.aqap.business.payment.route.PayRouteEnum;
import kd.ebg.aqap.business.payment.route.PayRouteTNode;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PayRouteCollection {
    EBGLogger logger = EBGLogger.getInstance().getLogger(PayRouteCollection.class);
    private List<PayRoute> payRouteList = new ArrayList<PayRoute>(16);

    public void addPayRoute(PayRoute payRoute) {
        this.payRouteList.add(payRoute);
    }

    public PayRoute query(PaymentInfo paymentInfo) {
        ArrayList<PayRoute> realRouteList = new ArrayList<PayRoute>(16);
        String subBizType = paymentInfo.getSubBizType();
        String individual = String.valueOf(paymentInfo.is2Individual());
        String merge = String.valueOf(paymentInfo.is2Merge());
        String sameBank = String.valueOf(paymentInfo.is2SameBank());
        String useCn = paymentInfo.getUseCN();
        List routeList = this.payRouteList.stream().filter(r -> r.getBizType().equalsIgnoreCase(subBizType)).collect(Collectors.toList());
        for (PayRoute payRoute : routeList) {
            boolean isMatch = true;
            if (StringUtils.isNotEmpty((String)payRoute.getIndividual()) && !(isMatch = payRoute.getIndividual().equalsIgnoreCase(individual)) || StringUtils.isNotEmpty((String)payRoute.getMerge()) && !(isMatch = payRoute.getMerge().equalsIgnoreCase(merge)) || StringUtils.isNotEmpty((String)payRoute.getSameBank()) && !(isMatch = payRoute.getSameBank().equalsIgnoreCase(sameBank)) || payRoute.getUseCn() != null && !(isMatch = StringUtils.isEmpty((String)payRoute.getUseCn().replaceAll(" ", "")) ? !ResManager.loadKDString((String)"\u5de5\u8d44", (String)"PayRouteCollection_0", (String)"ebg-aqap-business", (Object[])new Object[0]).equalsIgnoreCase(useCn) : payRoute.getUseCn().equalsIgnoreCase(useCn))) continue;
            if (StringUtils.isNotEmpty((String)payRoute.getBusconfig())) {
                ObjectPropertiesRepository propertiesRepository = (ObjectPropertiesRepository)SpringContextUtil.getBean(ObjectPropertiesRepository.class);
                Map busConfigMap = (Map)JSON.parse((String)payRoute.getBusconfig());
                for (Map.Entry entry : busConfigMap.entrySet()) {
                    String expectValue = (String)entry.getValue();
                    ObjectPropertiesKey key = new ObjectPropertiesKey();
                    key.setAttrKey((String)entry.getKey());
                    key.setObjectName("BANK_BUSINESS");
                    key.setObjectID(payRoute.getBankVersionID());
                    ObjectProperties objectProp = propertiesRepository.findById(key);
                    isMatch = expectValue != null && objectProp != null && expectValue.equalsIgnoreCase(objectProp.getAttrValue());
                    if (isMatch) continue;
                    break;
                }
                if (!isMatch) continue;
            }
            if (!isMatch) continue;
            realRouteList.add(payRoute);
        }
        if (realRouteList.size() > 0) {
            this.logger.info("\u6ee1\u8db3\u4ed8\u6b3e\u8def\u7531\u65b9\u6848\u4e2a\u6570\uff1a" + realRouteList.size());
            return (PayRoute)realRouteList.get(0);
        }
        return null;
    }

    public PayRoute query(String id) {
        for (PayRoute payRoute : this.payRouteList) {
            if (!payRoute.getId().equalsIgnoreCase(id)) continue;
            return payRoute;
        }
        return null;
    }

    private PayRouteTNode getParentNode(Map<Integer, Map<String, PayRouteTNode>> collections, PayRouteEnum payRouteEnum, String nodeName, String exceptValue, String id) {
        PayRoute payRouteNow = this.query(id);
        if (StringUtils.isEmpty((String)nodeName)) {
            nodeName = payRouteEnum.getName();
        }
        if (StringUtils.isNotEmpty((String)exceptValue)) {
            for (Map.Entry<Integer, Map<String, PayRouteTNode>> mapEntry : collections.entrySet()) {
                Map<String, PayRouteTNode> payRouteTNodes = mapEntry.getValue();
                for (Map.Entry<String, PayRouteTNode> payRouteTNodeEntry : payRouteTNodes.entrySet()) {
                    PayRoute payRoute;
                    PayRouteTNode payRouteTNode = payRouteTNodeEntry.getValue();
                    if (payRouteTNode.getId() == null || !nodeName.equalsIgnoreCase(payRouteTNode.getNodeName()) || !exceptValue.equalsIgnoreCase(payRouteTNode.getExpectValue()) || !payRouteNow.isSameNode(payRouteEnum, payRoute = this.query(payRouteTNode.getId()))) continue;
                    return payRouteTNode;
                }
            }
        }
        return null;
    }

    public Map<Integer, Map<String, PayRouteTNode>> transTNodes() {
        HashMap<Integer, Map<String, PayRouteTNode>> collections = new HashMap<Integer, Map<String, PayRouteTNode>>(16);
        for (PayRoute payRoute : this.payRouteList) {
            PayRouteTNode curParentNode = null;
            curParentNode = this.createTNode(collections, curParentNode, PayRouteEnum.BANK_VERSION, payRoute.getBankVersionID(), payRoute.getId());
            curParentNode = this.createTNode(collections, curParentNode, PayRouteEnum.BIZ_TYPE, payRoute.getBizType(), payRoute.getId());
            curParentNode = this.createTNode(collections, curParentNode, PayRouteEnum.INDIVIDUAL, payRoute.getIndividual(), payRoute.getId());
            curParentNode = this.createTNode(collections, curParentNode, PayRouteEnum.MERGE, payRoute.getMerge(), payRoute.getId());
            curParentNode = this.createTNode(collections, curParentNode, PayRouteEnum.SAME_BANK, payRoute.getSameBank(), payRoute.getId());
            curParentNode = this.createTNode(collections, curParentNode, PayRouteEnum.USE_CN, payRoute.getUseCn(), payRoute.getId());
            curParentNode = this.createTNode(collections, curParentNode, PayRouteEnum.CURRENCY, payRoute.getCurrency(), payRoute.getId());
            curParentNode = this.createTNode(collections, curParentNode, PayRouteEnum.SINGLE, payRoute.getSingle(), payRoute.getId());
            curParentNode = this.createTNode(collections, curParentNode, PayRouteEnum.BUS_CONFIG, payRoute.getBusconfig(), payRoute.getId());
            curParentNode = this.createTNode(collections, curParentNode, PayRouteEnum.URGENT, payRoute.getUrgent(), payRoute.getId());
            int level = curParentNode.getLevel();
            this.addChildNode(collections, curParentNode, PayRouteEnum.IMPL, payRoute.getImpl(), level, payRoute.getId());
        }
        return collections;
    }

    private PayRouteTNode createTNode(Map<Integer, Map<String, PayRouteTNode>> collections, PayRouteTNode curParentNode, PayRouteEnum payRouteEnum, String value, String id) {
        PayRouteTNode child = this.getParentNode(collections, payRouteEnum, null, value, id);
        if (child != null && curParentNode.getNodeId().equalsIgnoreCase(child.getParentId())) {
            curParentNode = child;
        } else {
            int level = 0;
            if (payRouteEnum == PayRouteEnum.BUS_CONFIG) {
                level = curParentNode.getLevel();
                child = this.addChildNodeByBusConfig(collections, curParentNode, payRouteEnum, value, level, id);
                if (child != null) {
                    child.setBankVersionID(curParentNode.getBankVersionID());
                }
            } else if (payRouteEnum == PayRouteEnum.BANK_VERSION) {
                child = PayRouteTNode.createRoot(payRouteEnum.getName(), value, payRouteEnum.getDesc());
                if (child != null) {
                    child.setBankVersionID(value);
                    this.put(collections, level, child);
                }
            } else {
                level = curParentNode.getLevel();
                child = this.addChildNode(collections, curParentNode, payRouteEnum, value, level, id);
                if (child != null) {
                    child.setBankVersionID(curParentNode.getBankVersionID());
                }
            }
            if (child != null) {
                curParentNode = child;
            }
        }
        return curParentNode;
    }

    private PayRouteTNode addChildNode(Map<Integer, Map<String, PayRouteTNode>> collections, PayRouteTNode payRouteTNode, PayRouteEnum payRouteEnum, String value, int level, String id) {
        if (StringUtils.isNotEmpty((String)value)) {
            PayRouteTNode child = PayRouteTNode.create(payRouteTNode.getNodeId(), payRouteEnum.getName(), value, payRouteEnum.getDesc(), ++level, id);
            child.setPayRouteEnum(payRouteEnum);
            this.put(collections, level, child);
            return child;
        }
        return payRouteTNode;
    }

    private void put(Map<Integer, Map<String, PayRouteTNode>> collections, int level, PayRouteTNode payRouteTNode) {
        if (collections.containsKey(level)) {
            collections.get(level).put(payRouteTNode.getNodeId(), payRouteTNode);
        } else {
            HashMap<String, PayRouteTNode> nodeMap = new HashMap<String, PayRouteTNode>(16);
            nodeMap.put(payRouteTNode.getNodeId(), payRouteTNode);
            collections.put(level, nodeMap);
        }
    }

    private PayRouteTNode addChildNodeByBusConfig(Map<Integer, Map<String, PayRouteTNode>> collections, PayRouteTNode payRouteTNode, PayRouteEnum payRouteEnum, String value, int level, String id) {
        PayRouteTNode child = null;
        String bankVersionID = payRouteTNode.getBankVersionID();
        String parentNodeID = payRouteTNode.getNodeId();
        if (StringUtils.isNotEmpty((String)value)) {
            Map busConfigMap = (Map)JSON.parse((String)value);
            for (Map.Entry entry : busConfigMap.entrySet()) {
                child = this.getParentNode(collections, payRouteEnum, (String)entry.getKey(), (String)entry.getValue(), id);
                if (child == null || child != null && !child.getParentId().equalsIgnoreCase(parentNodeID)) {
                    child = PayRouteTNode.create(parentNodeID, (String)entry.getKey(), (String)entry.getValue(), payRouteEnum.getDesc(), ++level, id);
                    child.setPayRouteEnum(payRouteEnum);
                    child.setBankVersionID(bankVersionID);
                    this.put(collections, level, child);
                    parentNodeID = child.getNodeId();
                    continue;
                }
                parentNodeID = child.getNodeId();
            }
        } else {
            child = payRouteTNode;
        }
        return child;
    }
}

