/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.route;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.route.PayRoute;
import kd.ebg.aqap.business.payment.route.PayRouteCollection;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.model.PaymentInfo;

public class PayRouteUtil {
    public static final String ENTITY = "aqap_pay_route_rec";
    public static final String PROPERTIES = "id,bank_version,sub_biz_type,individual,use_cn,same_bank,merge,currency,single,busconf,accprop,impl,source,urgent";

    public static void route(List<PaymentInfo> paymentInfos) {
        ArrayList<PaymentInfo> nonRoutePaymentInfos = new ArrayList<PaymentInfo>(16);
        String bankVersionID = paymentInfos.get(0).getBankVersionID();
        QFilter filter = QFilter.of((String)"bank_version = ?", (Object[])new Object[]{bankVersionID});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY, (String)PROPERTIES, (QFilter[])filter.toArray());
        PayRouteCollection payRouteCollection = new PayRouteCollection();
        if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                PayRoute payRoute = PayRouteUtil.transFormat(dynamicObject);
                payRouteCollection.addPayRoute(payRoute);
            }
            for (PaymentInfo paymentInfo : paymentInfos) {
                PayRoute route = payRouteCollection.query(paymentInfo);
                if (route != null) {
                    paymentInfo.setImplClassName(route.getImpl());
                    try {
                        IQueryPay queryPayImpl;
                        AbstractPayImpl pay = (AbstractPayImpl)Class.forName(route.getImpl()).newInstance();
                        Class queryPayImplClass = pay.defaultQueryClass();
                        if (!Objects.nonNull(queryPayImplClass) || (queryPayImpl = (IQueryPay)BankBundleManager.getInstance().getImplByClassName(paymentInfo.getBankVersionID(), IQueryPay.class, queryPayImplClass.getName())) == null) continue;
                        paymentInfo.setQueryImplClassName(queryPayImpl.getClass().getName());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                nonRoutePaymentInfos.add(paymentInfo);
            }
        } else {
            nonRoutePaymentInfos.addAll(paymentInfos);
        }
        if (nonRoutePaymentInfos.size() > 0) {
            PaymentUtil.preTreatment(nonRoutePaymentInfos);
        }
    }

    public static PayRoute transFormat(DynamicObject dynamicObject) {
        PayRoute payRoute = new PayRoute();
        payRoute.setId(dynamicObject.getString("id"));
        payRoute.setBankVersionID(dynamicObject.getString("bank_version"));
        payRoute.setBizType(dynamicObject.getString("sub_biz_type"));
        payRoute.setIndividual(dynamicObject.getString("individual"));
        payRoute.setMerge(dynamicObject.getString("merge"));
        payRoute.setSameBank(dynamicObject.getString("same_bank"));
        payRoute.setUseCn(dynamicObject.getString("use_cn"));
        payRoute.setCurrency(dynamicObject.getString("currency"));
        payRoute.setSingle(dynamicObject.getString("single"));
        payRoute.setBusconfig(dynamicObject.getString("busconf"));
        payRoute.setAccprop(dynamicObject.getString("accprop"));
        payRoute.setImpl(dynamicObject.getString("impl"));
        payRoute.setSource(dynamicObject.getString("source"));
        payRoute.setUrgent(dynamicObject.getString("urgent"));
        return payRoute;
    }
}

