/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.schedule;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.service.bank.BankLoginService;
import kd.ebg.egf.common.model.bank.login.BankLogin;

public class PayCheckCache {
    private Map<String, Boolean> accountStatusMap = new HashMap<String, Boolean>(16);
    private Map<String, Boolean> bankVersionStatusMap = new HashMap<String, Boolean>(16);
    private Map<String, Boolean> BankLoginStatusMap = new HashMap<String, Boolean>(16);
    private StringBuilder sb = new StringBuilder();

    public PayCheckCache() {
        String customID = RequestContext.get().getTenantId();
        if (this.accountStatusMap.isEmpty()) {
            QFilter filter = QFilter.of((String)"enable='1' and custom_id=?", (Object[])new Object[]{customID});
            Map map = BusinessDataServiceHelper.loadFromCache((String)"aqap_bank_acnt", (QFilter[])filter.toArray());
            for (Map.Entry entry : map.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                String number = dynamicObject.getString("number");
                this.accountStatusMap.put(this.getKey(number), Boolean.TRUE);
            }
        }
        if (this.BankLoginStatusMap.isEmpty()) {
            List bankLoginList = BankLoginService.getInstance().getByCustomId(customID);
            for (BankLogin bankLogin : bankLoginList) {
                String number = bankLogin.getKey().getBankLoginId();
                Boolean result = bankLogin.getEnable().equals("1");
                this.BankLoginStatusMap.put(this.getKey(number), result);
            }
        }
    }

    public void clearLogMessage() {
        this.sb.delete(0, this.sb.length());
    }

    public void setLogMessage(String message) {
        this.sb.append(message).append("\r\n");
    }

    public String getLogMessage() {
        return this.sb.toString();
    }

    private String getKey(String key) {
        String customID = RequestContext.get().getTenantId();
        String accountID = RequestContext.get().getAccountId();
        StringBuilder sb = new StringBuilder();
        sb.append(customID).append('_').append(accountID).append('_').append(key);
        return sb.toString();
    }

    public boolean isExsist(String accNo, String customID) {
        QFilter filter = QFilter.of((String)"enable='1' and custom_id=?", (Object[])new Object[]{accNo, customID});
        return QueryServiceHelper.exists((String)"aqap_bank_acnt", (QFilter[])filter.toArray());
    }

    public boolean isAccountEnable(String account) {
        String key = this.getKey(account);
        if (this.accountStatusMap.containsKey(key)) {
            return this.accountStatusMap.get(key);
        }
        return false;
    }

    public boolean isBankLoginEnable(String bankLoginID) {
        String key = this.getKey(bankLoginID);
        if (this.BankLoginStatusMap.containsKey(key)) {
            return this.BankLoginStatusMap.get(key);
        }
        return false;
    }

    public boolean isBankPayEnable(String bankVersionID) {
        String key = this.getKey(bankVersionID);
        if (this.bankVersionStatusMap.containsKey(key)) {
            return this.bankVersionStatusMap.get(key);
        }
        Boolean result = BankPropertyConfig.isBankPayAllow((String)bankVersionID);
        this.bankVersionStatusMap.put(key, result);
        return result;
    }

    public void clear() {
        this.accountStatusMap.clear();
        this.BankLoginStatusMap.clear();
        this.bankVersionStatusMap.clear();
    }
}

