/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.schedule;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.cache.CachePayStorage;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.task.BankPayTask;
import kd.ebg.aqap.business.payment.utils.PaymentAmountUtils;
import kd.ebg.aqap.business.util.ScheduleJobPrepareCheck;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.framework.services.EBGNodeService;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class PayScheduleJob
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(PayScheduleJob.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        RequestContext.set((RequestContext)requestContext);
        this.logger.info("\u4ed8\u6b3e\u8c03\u5ea6 tenantid=" + requestContext.getTenantId());
        this.logger.info("\u4ed8\u6b3e\u8c03\u5ea6 accountid=" + requestContext.getAccountId());
        boolean isPaymentAllowed = SystemPropertyConfig.PAYMENT_ALLOW.getCurrentValueAsBoolean();
        if (!isPaymentAllowed) {
            this.logger.info("\u652f\u4ed8\u901a\u9053\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u652f\u4ed8");
            return;
        }
        PaymentInfoService paymentInfoService = PaymentInfoService.getInstance();
        List nonExistences = ((EBGNodeService)SpringContextUtil.getBean(EBGNodeService.class)).getInValidNodes();
        if (CollectionUtil.isNotEmpty((Collection)nonExistences)) {
            this.logger.info("\u4ed8\u6b3e\u8c03\u5ea6\u2014>\u4fee\u6539\u5931\u6548\u8282\u70b9\u7684\u4ed8\u6b3e\u63d0\u4ea4\u4e2d\u4e3a\u672a\u786e\u8ba4");
            paymentInfoService.updateInvalidNodesFromSubmittingToUnknown(nonExistences);
        }
        this.logger.info("\u4ed8\u6b3e\u8c03\u5ea6\u2014>\u67e5\u8be28\u5c0f\u65f6\u5185\u5df2\u6253\u5305\u72b6\u6001\u7684\u4ed8\u6b3e\u4fe1\u606f\uff0c\u53d1\u8d77\u4ed8\u6b3e\u8bf7\u6c42");
        LocalDateTime limitTime = LocalDateTime.now().minus(8L, ChronoUnit.HOURS);
        List paymentInfos = paymentInfoService.findByStatusAndUpdateTimeAfterAndEbgID(PaymentState.PACKAGED.getId(), limitTime);
        if (!paymentInfos.isEmpty()) {
            this.logger.info(String.format("\u83b7\u53d6\u5230\u672c\u8282\u70b9\u672a\u63d0\u4ea4\u7684\u4ed8\u6b3e\uff1a%d\u6761", paymentInfos.size()));
            this.process(paymentInfos, false);
        } else {
            this.logger.info("\u4ed8\u6b3e\u8c03\u5ea6\u2014>\u67e5\u8be2\u975e\u672c\u8282\u70b9\u7684\uff0c\u4f46\u662f\u4e0a\u6b21\u66f4\u65b0\u65f6\u95f4\u8d85\u8fc730\u5206\u949f\u7684\u4ed8\u6b3e");
            LocalDateTime now = LocalDateTime.now();
            paymentInfos = paymentInfoService.findByStatusAndInsertTimeBetweenAndEbgIDNot(PaymentState.PACKAGED.getId(), now.minus(30L, ChronoUnit.MINUTES), now.minus(8L, ChronoUnit.HOURS));
            if (!paymentInfos.isEmpty()) {
                this.logger.info(String.format("\u83b7\u53d6\u5230\u5176\u4ed6\u8282\u70b9\u672a\u63d0\u4ea4\u7684\u4ed8\u6b3e:%d\u6761", paymentInfos.size()));
                this.process(paymentInfos, true);
            }
        }
    }

    private void process(List<PaymentInfo> paymentInfos, boolean isModifyOwnToMe) {
        block6: {
            PaymentInfoService paymentInfoService = PaymentInfoService.getInstance();
            if (paymentInfos.isEmpty()) break block6;
            this.logger.info("\u4ed8\u6b3e\u8c03\u5ea6\u5904\u7406->\u6309\u7167\u4ed8\u6b3e\u6279\u6b21\u53f7\u5206\u7ec4");
            Map<String, List<PaymentInfo>> collect = paymentInfos.stream().collect(Collectors.groupingBy(PaymentInfo::getBankBatchSeqID));
            if (isModifyOwnToMe) {
                for (Map.Entry<String, List<PaymentInfo>> next : collect.entrySet()) {
                    String bankBatchSeqId = next.getKey();
                    List<PaymentInfo> infoList = next.getValue();
                    try {
                        this.logger.info("\u5c1d\u8bd5\u4fee\u6539\u5176\u4ed6\u8282\u70b9\u7684\u4ed8\u6b3e\u6240\u6709\u8005\u4e3a\u672c\u8282\u70b9. bankBatchSeqId:{}", (Object)bankBatchSeqId);
                        List save = paymentInfoService.modifyOwnToMe(infoList, bankBatchSeqId);
                        if (save.isEmpty()) continue;
                        this.submitPay(save);
                    }
                    catch (Exception e) {
                        this.logger.info("\u5c1d\u8bd5\u5904\u7406\u5176\u4ed6\u8282\u70b9\u7684\u4ed8\u6b3e\u5931\u8d25, bankBatchSeqId:{}", (Object)bankBatchSeqId);
                    }
                }
            } else {
                for (Map.Entry<String, List<PaymentInfo>> entry : collect.entrySet()) {
                    this.logger.info(String.format("\u4ed8\u6b3e\u63d0\u4ea4\u7ebf\u7a0b\u6c60\uff0c\u6279\u6b21\u53f7\u4e3a%s", entry.getKey()));
                    this.submitPay(entry.getValue());
                }
            }
        }
    }

    private void submitPay(List<PaymentInfo> paymentInfos) {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String bankVersion = paymentInfo.getBankVersionID();
        String bizType = paymentInfo.getBizType();
        String customerId = paymentInfo.getCustomID();
        String batchSeqId = paymentInfo.getBatchSeqId();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(paymentInfo.getAccNo());
        bankAcnt.setBankLoginId(paymentInfo.getBankLoginID());
        bankAcnt.setBankVersionId(bankVersion);
        String traceId = RequestContext.get().getTraceId();
        if (StringUtils.isEmpty((String)traceId)) {
            traceId = String.valueOf(System.currentTimeMillis());
        }
        this.logger.info("\u5f53\u524d\u8282\u70b9\u5904\u7406\u63d0\u4ea4\u4ed8\u6b3etraceId\u4e3a" + traceId);
        String subBizType = bizType;
        if (StringUtils.isNotEmpty((String)paymentInfo.getLinkpayType())) {
            subBizType = "linkPay";
        }
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID("").bizName(bizType).subBizName(subBizType).bankVersionID(bankVersion).bankLoginID(paymentInfo.getBankLoginID()).bizSeqID(batchSeqId).logBizSeqID(Sequence.gen18Sequence()).logRequestSeqID(traceId).loggerBatchNo(batchSeqId).loggerDetailNo(paymentInfo.getBankBatchSeqID()).loggerBankNo(paymentInfo.getBankBatchSeqID()).build();
        context.setBankAcnt(bankAcnt);
        EBContext.setContext((EBContext)context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)context);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.infoIndex("\u4ed8\u6b3e\u8c03\u5ea6\u2014>{}", (Object)batchSeqId);
        if (!ScheduleJobPrepareCheck.checkAcntEnable(paymentInfo.getAccNo(), customerId)) {
            this.logger.info("\u4ed8\u6b3e\u8c03\u5ea6\u2014>\u5f53\u524d\u6279\u6b21{}\u7684\u8d26\u53f7{}\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8fc7\u6ee4\u6b64\u6279\u6b21\u7684\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u4e0d\u63d0\u4ea4\u5f02\u6b65\u7ebf\u7a0b\u6c60", new Object[]{paymentInfo.getBankBatchSeqId(), paymentInfo.getAccNo()});
            return;
        }
        if (!ScheduleJobPrepareCheck.checkBankLoginEnable(paymentInfo.getBankLoginID(), customerId)) {
            this.logger.info("\u4ed8\u6b3e\u8c03\u5ea6\u2014>\u5f53\u524d\u6279\u6b21{}\u7684\u524d\u7f6e\u673a{}\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8fc7\u6ee4\u6b64\u6279\u6b21\u7684\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u4e0d\u63d0\u4ea4\u5f02\u6b65\u7ebf\u7a0b\u6c60", new Object[]{paymentInfo.getBankBatchSeqId(), paymentInfo.getBankLoginID()});
            return;
        }
        if (!BankPropertyConfig.isBankPayAllow((String)bankVersion)) {
            this.logger.info("\u94f6\u884c[" + bankVersion + "]\u652f\u4ed8\u901a\u9053\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u652f\u4ed8");
        } else {
            this.logger.info("\u51c6\u5907\u63d0\u4ea4\u4ed8\u6b3e\u8c03\u5ea6\u8bb0\u5f55\u6570\uff1a" + paymentInfos.size());
            this.logger.info("\u57cb\u70b91\uff1a\u751f\u6210\u94f6\u884c\u4ed8\u6b3e\u8bf7\u6c42BankPayRequest");
            BankPayRequest request = this.prepareBankPayRequest(paymentInfos);
            String bankLoginId = request.getHeader().getAcnt().getBankLoginId();
            String bankBatchSeqID = paymentInfo.getBankBatchSeqID();
            if (CachePayStorage.checkSubmitLock(bankBatchSeqID)) {
                this.logger.info(String.format("\u4ed8\u6b3e\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u6279\u6b21\u53f7\u4e3a%s\uff0c\u4ed8\u6b3e\u4efb\u52a1\u4e0d\u63d0\u4ea4\u4ed8\u6b3e\u7ebf\u7a0b\u6c60", bankBatchSeqID));
            } else {
                this.logger.info(String.format("\u4ed8\u6b3e\u63d0\u4ea4\u7ebf\u7a0b\u6c60\uff08%s,%s\uff09", customerId, bankLoginId));
                String taskID = EBThreadPools.createScheduleBizTask(context);
                BankPayTask bankPayTask = new BankPayTask(request, context);
                bankPayTask.setTaskId(taskID);
                EBThreadPools.getPayThreadPool(customerId, bankLoginId).submit((Callable)((Object)bankPayTask));
                this.logger.info("\u4ed8\u6b3e\u63d0\u4ea4\u7ebf\u7a0b\u6c60:\u5b8c\u6210");
            }
        }
    }

    private BankPayRequest prepareBankPayRequest(List<PaymentInfo> paymentInfos) {
        BankPayRequest bankPayRequest = new BankPayRequest();
        if (paymentInfos.size() > 0) {
            PaymentInfo info = paymentInfos.get(0);
            bankPayRequest.setPaymentInfos(paymentInfos);
            bankPayRequest.setTotalCount(paymentInfos.size());
            bankPayRequest.setTotalAmount(PaymentAmountUtils.getTotalAmount(paymentInfos));
            bankPayRequest.setBankBatchSeqID(info.getBankBatchSeqID());
            bankPayRequest.setHeader(this.getHeader(info));
        }
        return bankPayRequest;
    }

    private BankHeader getHeader(PaymentInfo info) {
        BankHeader header = new BankHeader();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(info.getAccNo(), info.getCustomID());
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        header.setCustomerID(info.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqID());
        header.setLogBizSeqID(info.getBatchSeqID());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(acnt);
        header.setClientName("ebc_bankPayTask");
        header.setClientVersion("1.0");
        this.logger.info("\u57cb\u70b92\uff1a\u7ec4\u88c5\u94f6\u884c\u4ed8\u6b3e\u8bf7\u6c42\u5934\u5b8c\u6210");
        return header;
    }
}

