/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.task;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.cache.CachePayStorage;
import kd.ebg.aqap.business.payment.intercept.PayControlManager;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.LinkPayStepHelper;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.entity.biz.status.UpdateOpState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.PaymentInfoRecord;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBBaseException;
import kd.ebg.egf.common.exception.EBLoginAccessException;
import kd.ebg.egf.common.exception.EBPayFailException;
import kd.ebg.egf.common.exception.EBRePayException;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class BankPayTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankPayTask.class);
    private BankPayRequest request;
    private EBContext context;

    public BankPayTask(BankPayRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        EBBankPayResponse response = this.submitPay(this.request, this.context);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankPayResponse submitPay(BankPayRequest request, EBContext context) {
        AccessUtils.checkPaymentAllowed(context);
        String bizSeqID = request.getBankBatchSeqID();
        context.setBizSeqID(bizSeqID);
        if (StringUtils.isEmpty((String)context.getBizName())) {
            context.setBizName("pay");
        }
        EBContext.setContext((EBContext)context);
        try {
            List<PaymentInfo> result;
            EBBankPayResponse response;
            FEPAccess access;
            PaymentInfoService paymentInfoService;
            block35: {
                List<PaymentInfo> checkedPaymentInfos;
                IPay pay;
                block34: {
                    List paymentInfos;
                    block33: {
                        block32: {
                            block31: {
                                PaymentUtil.setReDevResult(request.getPaymentInfos().get(0));
                                MDCUtil.clearBussinessMDC();
                                MDCUtil.initMDC((EBContext)context);
                                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                                this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u4ed8\u6b3e\u4e1a\u52a1\u5904\u7406,{}", (Object)bizSeqID);
                                this.logger.info("\u5f00\u59cb\u4ed8\u6b3e,\u603b\u8bb0\u5f55\u6570\uff1a{}\u6761", (Object)request.getPaymentInfos().size());
                                paymentInfos = request.getPaymentInfos();
                                if (paymentInfos.isEmpty()) {
                                    EBBankPayResponse eBBankPayResponse = null;
                                    return eBBankPayResponse;
                                }
                                paymentInfoService = PaymentInfoService.getInstance();
                                if (!paymentInfoService.isBatchOwnMe(request.getBankBatchSeqID())) {
                                    this.logger.warn("\u5f85\u5904\u7406\u4ed8\u6b3e\u8bb0\u5f55\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5b9e\u4f8b\u8282\u70b9\uff0c\u4e2d\u65ad\u672c\u6b21\u6267\u884c");
                                    EBBankPayResponse eBBankPayResponse = null;
                                    return eBBankPayResponse;
                                }
                                Map<PaymentInfo, String> interceptedPayments = PayControlManager.interceptPaymentsAndReasons(request.getPaymentInfos());
                                if (interceptedPayments.size() > 0) {
                                    this.logger.warn("\u4ed8\u6b3e\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38\u8bb0\u5f55\u6570\uff1a{}\u6761", new Object[]{interceptedPayments.size()});
                                    try {
                                        paymentInfoService.save(Arrays.asList(interceptedPayments.keySet().toArray(new PaymentInfo[interceptedPayments.size()])));
                                    }
                                    catch (Throwable e) {
                                        this.logger.error("\u4fdd\u5b58\u5f02\u5e38\u4ed8\u6b3e\u8bb0\u5f55\u51fa\u73b0\u9519\u8bef\uff0c\u4e0d\u4e2d\u65ad\u5f53\u524d\u4ed8\u6b3e\u6d41\u7a0b", e);
                                    }
                                    paymentInfos = paymentInfos.stream().filter(paymentInfo -> !interceptedPayments.containsKey(paymentInfo)).collect(Collectors.toList());
                                }
                                this.logger.debug("\u901a\u8fc7\u4ed8\u6b3e\u7b7e\u540d\u6821\u9a8c\u7684\u8bb0\u5f55\u6570\uff1a{}\u6761", (Object)paymentInfos.size());
                                if (paymentInfos.size() == 0) {
                                    this.logger.info("\u5f53\u524d\u6ca1\u6709\u9700\u8981\u63d0\u4ea4\u7684\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u7ec8\u6b62\u4ed8\u6b3e\u6d41\u7a0b");
                                    EBBankPayResponse e = null;
                                    return e;
                                }
                                String bankVersionID = context.getBankVersionID();
                                String implClassName = paymentInfos.get(0).getImplClassName();
                                pay = (IPay)BankBundleManager.getInstance().getImplByClassName(bankVersionID, IPay.class, implClassName);
                                if ("kd.ebg.aqap.banks.cus.service.payment.PaymentImpl".equals(pay.getClass().getName())) {
                                    this.logger.info("\u94f6\u884c\u63d2\u4ef6\u7684\u5b9e\u73b0\u7c7b\u4e3a\uff1a{}", (Object)pay.getBizDesc());
                                } else {
                                    this.logger.info("\u94f6\u884c\u63d2\u4ef6\u7684\u5b9e\u73b0\u7c7b\u4e3a\uff1a{}", (Object)pay.getClass().getName());
                                }
                                access = null;
                                EBContext.initParameter();
                                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
                                if (AccessUtils.isPaymentAllowed(context)) break block31;
                                EBBankPayResponse eBBankPayResponse = null;
                                FEPAccessUtil.release((FEPAccess)access);
                                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                                return eBBankPayResponse;
                            }
                            paymentInfos = paymentInfoService.compareAndStateState(paymentInfos, PaymentState.PACKAGED, PaymentState.SUBMITTING);
                            if (!Objects.isNull(paymentInfos) && !paymentInfos.isEmpty()) break block32;
                            EBBankPayResponse eBBankPayResponse = null;
                            FEPAccessUtil.release((FEPAccess)access);
                            MDC.put((String)"bussiness_type", (String)"bussiness_process");
                            return eBBankPayResponse;
                        }
                        paymentInfos = paymentInfoService.updateWithVersion(paymentInfos);
                        if (!Objects.isNull(paymentInfos) && !paymentInfos.isEmpty()) break block33;
                        this.logger.error("\u4ed8\u6b3e\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u89e6\u53d1\u6570\u636e\u5e93\u4e50\u89c2\u9501\u673a\u5236\uff0c\u4e2d\u65ad\u672c\u6b21\u6267\u884c\uff0cbankBatchSeqId:{}", new Object[]{request.getBankBatchSeqID()});
                        EBBankPayResponse eBBankPayResponse = null;
                        FEPAccessUtil.release((FEPAccess)access);
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        return eBBankPayResponse;
                    }
                    request.setPaymentInfos(paymentInfos);
                    checkedPaymentInfos = this.checkPaymentInfo(request.getPaymentInfos(), paymentInfoService);
                    if (!Objects.isNull(checkedPaymentInfos) && !checkedPaymentInfos.isEmpty()) break block34;
                    this.logger.error("\u62e6\u622a\u6389\u91cd\u590d\u63d0\u4ea4\u540e\uff0c\u5df2\u6ca1\u6709\u9700\u8981\u652f\u4ed8\u7684\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u4e2d\u65ad\u672c\u6b21\u6267\u884c");
                    EBBankPayResponse eBBankPayResponse = null;
                    FEPAccessUtil.release((FEPAccess)access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    return eBBankPayResponse;
                }
                try {
                    request.setPaymentInfos(checkedPaymentInfos);
                    response = pay.pay(request);
                    if (Objects.nonNull(EBContext.getContext().getThrowableAfterSend())) {
                        this.handleThrowableAfterSend(request.getPaymentInfos());
                        result = request.getPaymentInfos();
                        break block35;
                    }
                    Preconditions.checkState((boolean)Objects.nonNull((Object)response), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankPayTask_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    Preconditions.checkState((boolean)Objects.nonNull(response.getPaymentInfos()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u4ed8\u6b3e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankPayTask_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    result = response.getPaymentInfos();
                }
                catch (Throwable e) {
                    try {
                        this.handleThrowable(e, request.getPaymentInfos());
                        result = request.getPaymentInfos();
                    }
                    catch (Throwable throwable) {
                        FEPAccessUtil.release(access);
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        throw throwable;
                    }
                    FEPAccessUtil.release((FEPAccess)access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                }
            }
            FEPAccessUtil.release((FEPAccess)access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            LocalDateTime submitSuccessTime = LocalDateTime.now();
            result.forEach(r -> {
                this.processSubmitPayFail((PaymentInfo)r);
                if (!UpdateOpState.PAY_FAIL.getId().equalsIgnoreCase(r.getUpdateOperation()) || !UpdateOpState.SUBMIT_PAY_FAIL.getId().equalsIgnoreCase(r.getUpdateOperation())) {
                    r.setSubmitSuccessTime(submitSuccessTime);
                }
            });
            paymentInfoService.save(result);
            if ("linkPay".equalsIgnoreCase(context.getSubBizName())) {
                ArrayList<PaymentInfo> linkPaymentInfos = new ArrayList<PaymentInfo>(result);
                LinkPayStepHelper.doNextStep(linkPaymentInfos);
            }
            response = new EBBankPayResponse();
            response.setHeader(request.getHeader());
            response.setPaymentInfos(request.getPaymentInfos());
            response.setBankBatchSeqID(request.getBankBatchSeqID());
            EBBankPayResponse eBBankPayResponse = response;
            return eBBankPayResponse;
        }
        catch (Throwable e) {
            this.logger.error("\u4ed8\u6b3e\u6d41\u7a0b\u51fa\u73b0\u5f02\u5e38\uff0c\u7ec8\u6b62\u4ed8\u6b3e\u6d41\u7a0b", e);
            EBBankPayResponse eBBankPayResponse = null;
            return eBBankPayResponse;
        }
        finally {
            PaymentUtil.clearReDevResult();
            CachePayStorage.release(bizSeqID);
        }
    }

    public void processSubmitPayFail(PaymentInfo paymentInfo) {
        if (paymentInfo.getStatus().intValue() == PaymentState.SUCCESS.getId()) {
            paymentInfo.setPayFinishDate(LocalDate.now());
        } else if (paymentInfo.getStatus().intValue() == PaymentState.SUBMITTING.getId()) {
            EBGBusinessUtils.setPaymentState(paymentInfo, PaymentState.SUBMITED, "", "", "Pay status submitting change to submitted in ebg_aqap.");
        } else if (paymentInfo.getStatus().intValue() == PaymentState.FAIL.getId() && !UpdateOpState.PAY_FAIL.getId().equalsIgnoreCase(paymentInfo.getUpdateOperation())) {
            paymentInfo.setUpdateOperation(UpdateOpState.SUBMIT_PAY_FAIL.getId());
        }
    }

    public void handleThrowableAfterSend(List<PaymentInfo> paymentInfoList) {
        Throwable t = EBContext.getContext().getThrowableAfterSend();
        this.logger.error("\u4ed8\u6b3e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", t);
        if (t instanceof EBBaseException) {
            if (((EBBaseException)t).getErrorCode().equalsIgnoreCase("ProxyCreateConnectionException")) {
                EBGBusinessUtils.setPaymentState(paymentInfoList, PaymentState.UNKNOWN, "", "", t.getMessage());
            } else if (((EBBaseException)t).getErrorCode().equalsIgnoreCase("ProxyConnectionException")) {
                EBGBusinessUtils.setPaymentState(paymentInfoList, PaymentState.UNKNOWN, "", "", t.getMessage());
            } else {
                EBGBusinessUtils.setPaymentState(paymentInfoList, PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u652f\u4ed8\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u3002", (String)"BankPayTask_4", (String)"ebg-aqap-business", (Object[])new Object[0]), "", t.getMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfoList, PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u652f\u4ed8\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u4ed8\u6b3e\u7ed3\u679c\u3002", (String)"BankPayTask_4", (String)"ebg-aqap-business", (Object[])new Object[0]), "", t.getMessage());
        }
    }

    public void handleThrowable(Throwable e, List<PaymentInfo> paymentInfoList) {
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.error("\u4ed8\u6b3e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", e);
        if (e instanceof EBLoginAccessException) {
            EBGBusinessUtils.setPaymentState(paymentInfoList, PaymentState.PACKAGED, "", "", "");
            for (PaymentInfo info : paymentInfoList) {
                info.setBackErrorMsg(e.getMessage());
                info.setUpdateOperation(UpdateOpState.PAY_FAIL.getId());
            }
            this.logger.error("\u4ed8\u6b3e\u72b6\u6001\u9000\u56de\"\u5df2\u6253\u5305\"\u72b6\u6001");
        } else if (e instanceof EBRePayException) {
            String errorMsg = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BankPayTask_7", (String)"ebg-aqap-business", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                errorMsg = errorMsg + "," + e.getMessage();
            }
            this.logger.error(errorMsg);
            for (PaymentInfo info : paymentInfoList) {
                info.setBackErrorMsg(e.getMessage());
            }
        } else if (e instanceof EBPayFailException) {
            String errorMsg = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BankPayTask_7", (String)"ebg-aqap-business", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                errorMsg = errorMsg + "," + e.getMessage();
            }
            String causeMessage = e.getCause() != null ? e.getCause().getMessage() : "Cause message is empty.";
            EBGBusinessUtils.setPaymentState(paymentInfoList, PaymentState.FAIL, errorMsg, "", causeMessage);
            for (PaymentInfo info : paymentInfoList) {
                info.setBackErrorMsg(e.getMessage());
                info.setUpdateOperation(UpdateOpState.PAY_FAIL.getId());
            }
        } else {
            String errorMsg = e.getMessage();
            EBGBusinessUtils.setPaymentState(paymentInfoList, PaymentState.UNKNOWN, errorMsg, "", e.getMessage());
        }
    }

    private Map<String, List<PaymentInfo>> checkRepeatSubmitPaymentInfo(List<PaymentInfo> paymentInfoList, PaymentInfoService paymentInfoService) {
        this.logger.info("\u51c6\u5907\u4ed8\u6b3e\u9632\u91cd\u63d0\u4ea4\u68c0\u67e5");
        ArrayList<PaymentInfo> distinctPaymentInfos = new ArrayList<PaymentInfo>(1);
        ArrayList<PaymentInfo> repeatSubmitPaymentInfos = new ArrayList<PaymentInfo>(1);
        ArrayList<PaymentInfoRecord> insertRecords = new ArrayList<PaymentInfoRecord>(1);
        ArrayList<PaymentInfoRecord> updateRecords = new ArrayList<PaymentInfoRecord>(1);
        ConcurrentHashMap<String, List<PaymentInfo>> maps = new ConcurrentHashMap<String, List<PaymentInfo>>(2);
        HashSet<List<PaymentInfo>> groupPaymentInfoSet = this.getINQueryGroup(paymentInfoList, 200);
        for (List<PaymentInfo> paymentInfos : groupPaymentInfoSet) {
            Map paymentInfoRecordMap = paymentInfoService.getExistPaymentRecord(paymentInfos);
            for (PaymentInfo paymentInfo : paymentInfos) {
                if (paymentInfoRecordMap.containsKey(paymentInfo.getId())) {
                    repeatSubmitPaymentInfos.add(paymentInfo);
                    PaymentInfoRecord paymentInfoRecord = (PaymentInfoRecord)paymentInfoRecordMap.get(paymentInfo.getId());
                    paymentInfoRecord.setUpdateCount(Integer.valueOf(paymentInfoRecord.getUpdateCount() + 1));
                    paymentInfoRecord.setUpdateTime(LocalDateTime.now());
                    updateRecords.add(paymentInfoRecord);
                    continue;
                }
                distinctPaymentInfos.add(paymentInfo);
                PaymentInfoRecord insertRecord = new PaymentInfoRecord();
                insertRecord.setUpdateCount(Integer.valueOf(0));
                insertRecord.setId(paymentInfo.getId());
                insertRecord.setCreateTime(LocalDateTime.now());
                insertRecords.add(insertRecord);
            }
        }
        maps.put("distinctPaymentInfo", distinctPaymentInfos);
        maps.put("repeatSubmitPaymentInfo", repeatSubmitPaymentInfos);
        paymentInfoService.saveSubmitBankRecord(updateRecords, true);
        paymentInfoService.saveSubmitBankRecord(insertRecords, false);
        this.logger.info("\u4ed8\u6b3e\u9632\u91cd\u63d0\u4ea4\u68c0\u67e5\u5b8c\u6210");
        return maps;
    }

    private HashSet<List<PaymentInfo>> getINQueryGroup(List<PaymentInfo> paymentInfos, int groupSize) {
        HashSet<List<PaymentInfo>> groupPaymentInfoSet = new HashSet<List<PaymentInfo>>(16);
        int totalSize = paymentInfos.size();
        int groupNum = totalSize % groupSize == 0 ? totalSize / groupSize : totalSize / groupSize + 1;
        for (int i = 0; i < groupNum; ++i) {
            int start = i * groupSize;
            int end = (i + 1) * groupSize;
            if (end > totalSize) {
                end = totalSize;
            }
            ArrayList<PaymentInfo> newGroupPaymentInfos = new ArrayList<PaymentInfo>(16);
            for (int j = start; j < end; ++j) {
                newGroupPaymentInfos.add(paymentInfos.get(j));
            }
            groupPaymentInfoSet.add(newGroupPaymentInfos);
        }
        return groupPaymentInfoSet;
    }

    private List<PaymentInfo> checkPaymentInfo(List<PaymentInfo> paymentInfoList, PaymentInfoService paymentInfoService) {
        Map<String, List<PaymentInfo>> paymentMap = this.checkRepeatSubmitPaymentInfo(paymentInfoList, paymentInfoService);
        List<PaymentInfo> distinctPaymentInfo = paymentMap.get("distinctPaymentInfo");
        return distinctPaymentInfo;
    }
}

