/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.task;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ebg.aqap.business.currentandfixed.atomic.IQueryCurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.framework.services.CurAndFixedService;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class BankQueryCurAndFixedTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankQueryCurAndFixedTask.class);
    private static final int QUERY_PAY_INTERVAL_MINUTES = 3;
    private BankCurAndFixedRequest request;
    private EBContext context;

    public BankQueryCurAndFixedTask(BankCurAndFixedRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse = this.submitCaf(this.request, this.context);
        return ebBankCurAndFixedResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankCurAndFixedResponse submitCaf(BankCurAndFixedRequest request, EBContext context) {
        EBBankCurAndFixedResponse ebBankCurAndFixedResponse;
        boolean isException;
        FEPAccess access;
        List<Object> result;
        CurAndFixedService curAndFixedService;
        block13: {
            String bizSeqID = Sequence.gen18Sequence();
            if (StringUtils.isEmpty((String)request.getHeader().getBizSeqID())) {
                request.getHeader().setBizSeqID(bizSeqID);
            }
            context.setBizName("queryCurrentAndFixed");
            MDCUtil.clearBussinessMDC();
            MDCUtil.initMDC((EBContext)context);
            if (SystemPropertyConfig.isScheduleLogOpen()) {
                MDC.put((String)"schedule", (String)"true");
            }
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            EBContext.setContext((EBContext)context);
            this.logger.infoIndex("\u5f00\u59cb\u67e5\u8be2\u5b9a\u6d3b\u4e92\u8f6c\u4e1a\u52a1\u72b6\u6001\u5904\u7406,{}", (Object)bizSeqID);
            this.logger.info("\u5f00\u59cb\u67e5\u8be2\u5b9a\u6d3b\u4e92\u8f6c\u4e1a\u52a1\u72b6\u6001,\u603b\u8bb0\u5f55\u6570\uff1a{}\u6761", (Object)request.getCafInfos().size());
            List<Object> curAndFixedInfos = request.getCafInfos();
            int limitNum = 200;
            curAndFixedInfos = curAndFixedInfos.stream().filter(curAndFixedInfo -> curAndFixedInfo.getSyncCount() == null || Integer.parseInt(curAndFixedInfo.getSyncCount()) < limitNum).collect(Collectors.toList());
            if (curAndFixedInfos.isEmpty()) {
                this.logger.info("\u94f6\u884c\u6279\u6b21\u53f7\uff1a{}, \u540c\u6b65\u6b21\u6570\uff1a{}, \u5141\u8bb8\u7684\u6700\u5927\u540c\u6b65\u6b21\u6570\uff1a{}", new Object[]{request.getCafInfos().get(0).getBatchSeqId(), request.getCafInfos().get(0).getSyncCount(), limitNum});
                return null;
            }
            CurAndFixedState state = CurAndFixedState.getEnumById((int)((CurAndFixedInfo)curAndFixedInfos.get(0)).getStatus());
            if (CurAndFixedState.PACKAGED == state || CurAndFixedState.INITIAL == state) {
                this.logger.info("\u5f53\u524d\u8bf7\u6c42\u4fe1\u606f\u8fd8\u672a\u63d0\u4ea4\u5230\u94f6\u884c\uff0c\u4e0d\u5141\u8bb8\u4ece\u94f6\u884c\u67e5\u8be2\u72b6\u6001");
                return null;
            }
            LocalDateTime submitSuccessTime = ((CurAndFixedInfo)curAndFixedInfos.get(0)).getSubmitSuccessTime();
            LocalDateTime updateTime = ((CurAndFixedInfo)curAndFixedInfos.get(0)).getUpdateTime();
            if (Objects.nonNull(submitSuccessTime) && Objects.nonNull(updateTime) && LocalDateTime.now().plusMinutes(-2L).isAfter(submitSuccessTime) && LocalDateTime.now().plusMinutes(-3L).isBefore(updateTime)) {
                this.logger.info("3\u5206\u949f\u5185\u5df2\u7ecf\u4ece\u94f6\u884c\u540c\u6b65\u8fc7\u4e86,\u672c\u6b21\u4e0d\u518d\u4ece\u94f6\u884c\u67e5\u8be2");
                return null;
            }
            curAndFixedService = CurAndFixedService.getInstance();
            String bankVersionID = context.getBankVersionID();
            IQueryCurAndFixed caf = (IQueryCurAndFixed)BankBundleManager.getInstance().getImpl(bankVersionID, IQueryCurAndFixed.class, (Object)request);
            this.logger.info("\u94f6\u884c\u63d2\u4ef6\u7684\u5b9e\u73b0\u7c7b\u4e3a\uff1a{}", caf.getClass());
            CAFUtil.setCAFInfoUpdateTimeAndStatus(curAndFixedInfos, LocalDateTime.now());
            result = curAndFixedInfos;
            access = null;
            isException = false;
            try {
                EBContext.initParameter();
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
                ebBankCurAndFixedResponse = caf.queryCurrentAndFixed(request);
                if (Objects.nonNull(EBContext.getContext().getThrowableAfterSend())) {
                    CAFUtil.setState(curAndFixedInfos, CurAndFixedState.UNKNOWN, MultiLang.getUnknownStatusTip(), "", "");
                    break block13;
                }
                if (ebBankCurAndFixedResponse == null) {
                    throw new IllegalStateException(MultiLang.getReturnNotEmptyTip());
                }
                if (ebBankCurAndFixedResponse.getDetails() == null) {
                    throw new IllegalStateException(MultiLang.getReturnDataEmptyTip());
                }
                result = ebBankCurAndFixedResponse.getDetails();
            }
            catch (Exception e) {
                try {
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    this.logger.error("\u67e5\u8be2\u5b9a\u6d3b\u76f8\u5173\u4ea4\u6613\u72b6\u6001\u5931\u8d25", (Throwable)e);
                    isException = true;
                }
                catch (Throwable throwable) {
                    FEPAccessUtil.release(access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    throw throwable;
                }
                FEPAccessUtil.release((FEPAccess)access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        for (CurAndFixedInfo curAndFixedInfo2 : result) {
            curAndFixedInfo2.setUpdateTime(LocalDateTime.now());
            if (!this.isWorkingTime() || isException) continue;
            curAndFixedInfo2.addSyncCount();
        }
        curAndFixedService.save(result);
        ebBankCurAndFixedResponse = new EBBankCurAndFixedResponse();
        ebBankCurAndFixedResponse.setHeader(request.getHeader());
        ebBankCurAndFixedResponse.setBatchSeqId(request.getBatchSeqId());
        ebBankCurAndFixedResponse.setDetails(request.getCafInfos());
        return ebBankCurAndFixedResponse;
    }

    private boolean isWorkingTime() {
        LocalDateTime now = LocalDateTime.now();
        int hour = now.getHour();
        int week = now.getDayOfWeek().getValue();
        return week >= 1 && week <= 5 && hour >= 6 && hour <= 17;
    }
}

