/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;

public class CheckUtil {
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String ILLEAGE_WORD_REGEXT = "[.~!@#$%\\^\\+\\*&\\\\\\/\\?\\|:\\.{}()';=\"\uff5e\uff01\uff20\uff03\uff04\uff05\uff3e\uff06\uff0a\uff08\uff09\uff3f\uff0d\uff0b\uff1d\uff0c\uff0e\uff1f\uff0f]";
    private static final String ALIPAY_ILLEAGE_WORD_REGEXT = "^[-\\+]?[\\d]*$|^[a-zA-Z0-9_.-]+@[a-zA-Z0-9_-]+\\.[a-zA-Z0-9_-]+$";
    private static final String ILLEAGE_WORD_REG = "[.~!@#$%\\^\\+\\*&\\\\\\/\\?\\|:\\.{}';=\"\uff5e\uff01\uff20\uff03\uff04\uff05\uff3e\uff06\uff0a\uff3f\uff0d\uff0b\uff1d\uff0c\uff0e\uff1f\uff0f]";
    private static final String NUMBER_REG = "^\\w(\\w*-\\w+)*\\w*$";
    private static final String NUMBER_WORD = "^\\w+$";

    public static BigDecimal checkBigDecimal(String str, String name) {
        int index = (str = CheckUtil.checkStringNotNull(str, name)).indexOf(".");
        if (-1 != index) {
            if (str.length() - 1 - index > 2) {
                throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8f93\u5165:%1$s;%2$s\u7684\u503c\u4e3a%3$s,\u8fc7\u4e8e\u7cbe\u786e\uff0c\u800c\u94f6\u4f01\u4e2d\u95f4\u4ef6\u53ea\u652f\u6301\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d\u7684\u91d1\u989d", (String)"CheckUtil_21", (String)"ebg-aqap-business", (Object[])new Object[0]), str, name, str));
            }
            if (str.length() - 1 - index < 2) {
                throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8f93\u5165:%1$s;%2$s\u7684\u503c\u4e3a%3$s\uff0c\u7cbe\u786e\u5ea6\u4e0d\u591f\uff0c\u94f6\u4f01\u4e2d\u95f4\u4ef6\u8981\u6c42\u91d1\u989d\u6570\u636e\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d", (String)"CheckUtil_18", (String)"ebg-aqap-business", (Object[])new Object[0]), str, name, str));
            }
        } else {
            throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8f93\u5165:%1$s;%2$s\u7684\u503c\u4e3a%3$s\uff0c\u7cbe\u786e\u5ea6\u4e0d\u591f\uff0c\u94f6\u4f01\u4e2d\u95f4\u4ef6\u8981\u6c42\u91d1\u989d\u6570\u636e\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d", (String)"CheckUtil_18", (String)"ebg-aqap-business", (Object[])new Object[0]), str, name, str));
        }
        BigDecimal amount = null;
        try {
            amount = new BigDecimal(str).setScale(2, 1);
        }
        catch (Throwable t) {
            throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8f93\u5165:%1$s;%2$s\u7684\u503c\u4e0d\u662f\u6570\u5b57\u3002", (String)"CheckUtil_22", (String)"ebg-aqap-business", (Object[])new Object[0]), str, name), t);
        }
        return amount;
    }

    public static String checkStringNotNull(String str, String name, String parentName, int num) {
        StringBuilder sb = new StringBuilder();
        if (num >= 0) {
            sb.append("serialNo=");
            sb.append(num + 1);
        }
        sb.append("'");
        sb.append(parentName);
        sb.append("'");
        String position = sb.toString();
        return CheckUtil.checkStringNotNull(str, name, position);
    }

    private static String checkStringNotNull(String str, String name, String position) {
        if (StringUtils.isEmpty((String)str)) {
            throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8f93\u5165:'%1$s'; \u5728%2$s\u4e2d,'%3$s'\u7684\u503c\u4e3a\u7a7a\u3002", (String)"CheckUtil_23", (String)"ebg-aqap-business", (Object[])new Object[0]), str, position, name));
        }
        return str.trim();
    }

    public static String checkStringNotNull(String str, String name) {
        if (StringUtils.isEmpty((String)str)) {
            throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8f93\u5165:'%1$s' ;  %2$s\u7684\u503c\u4e3a\u7a7a", (String)"CheckUtil_20", (String)"ebg-aqap-business", (Object[])new Object[0]), str, name));
        }
        return str.trim();
    }

    public static boolean checkNumber(String str) {
        return str.replaceAll("\u200b", "").matches(NUMBER_REG);
    }

    public static boolean checkAlipayAcnt(String str) {
        return str.matches(ALIPAY_ILLEAGE_WORD_REGEXT);
    }

    public static Object checkObjectNotNull(Object object, String name) {
        if (Objects.isNull(object)) {
            throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8f93\u5165:%1$s\u7684\u503c%2$s\u4e3a\u7a7a", (String)"CheckUtil_27", (String)"ebg-aqap-business", (Object[])new Object[0]), object, name));
        }
        return object;
    }

    public static boolean checkIlleageWordsExt(String str) {
        return !str.matches(ILLEAGE_WORD_REGEXT);
    }

    public static boolean checkNumberWord(String str) {
        return str.matches(NUMBER_WORD);
    }

    public static boolean checkIlleageWords(String str) {
        return !str.matches(ILLEAGE_WORD_REG);
    }

    public static int checkInt(String str, String name) {
        str = CheckUtil.checkStringNotNull(str, name);
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8f93\u5165\uff1a%1$s;%2$s\u7684\u503c\u4e0d\u662f\u6570\u5b57\u3002", (String)"CheckUtil_28", (String)"ebg-aqap-business", (Object[])new Object[0]), str, name), (Throwable)e);
        }
    }

    public static String formatStringMaybeNull(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        return str.trim();
    }

    public static boolean isNotContainSpace(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        return str.split("\\s+", -1).length <= 1;
    }

    public static boolean isChineseStr(String str) {
        String regEx = "[\\u4e00-\\u9fa5]+";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static void checkLength(String param, String value, int length) {
        if (value != null && value.length() > length) {
            throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"%1$s\u5b57\u6bb5\uff1a%2$s\uff0c\u957f\u5ea6\u8d85\u8fc7%3$s\uff0c\u8bf7\u4fee\u6539\u4e1a\u52a1\u5b57\u6bb5\u957f\u5ea6\u3002", (String)"CheckUtil_29", (String)"ebg-aqap-business", (Object[])new Object[0]), param, value, length));
        }
    }
}

