/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.keywords.BankKeyWordsService;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class LinkPayTempCache {
    private Map<String, BankAcnt> bankAcntMap = new HashMap<String, BankAcnt>(16);
    private List<String> bankKeyWords = new ArrayList<String>(16);
    private Map<String, String> bankCurrencyMap = new HashMap<String, String>(16);

    public void clear() {
        this.bankAcntMap.clear();
        this.bankKeyWords.clear();
        this.bankCurrencyMap.clear();
    }

    public BankAcnt getBankAcnt(String accNo) {
        if (this.bankAcntMap.containsKey(accNo)) {
            return this.bankAcntMap.get(accNo);
        }
        BankAcntService bankAcntService = BankAcntService.getInstance();
        BankAcnt bankAcnt = bankAcntService.selectByAccNo(accNo);
        if (bankAcnt != null) {
            this.bankAcntMap.put(accNo, bankAcnt);
        }
        return bankAcnt;
    }

    public boolean isSameBank(String bankVersionID, String payerBankName, String incomeBankName) {
        if (payerBankName.equalsIgnoreCase(incomeBankName) || incomeBankName.contains(payerBankName)) {
            return true;
        }
        List<String> keyWords = this.getBankKeyWords(bankVersionID);
        for (String keyWord : keyWords) {
            if (!incomeBankName.contains(keyWord) && !keyWord.contains(incomeBankName)) continue;
            return true;
        }
        return false;
    }

    public List<String> getBankKeyWords(String bankVersionID) {
        if (this.bankKeyWords.size() == 0) {
            this.bankKeyWords = BankKeyWordsService.getInstance().getKeyWords(bankVersionID);
        }
        return this.bankKeyWords;
    }

    public String getBankCurrency(String currency) {
        if (this.bankCurrencyMap.containsKey(currency)) {
            return this.bankCurrencyMap.get(currency);
        }
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        this.bankCurrencyMap.put(currency, bankCurrency);
        return bankCurrency;
    }
}

