/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import java.time.LocalDateTime;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.utils.LinkPayCacheFactory;
import kd.ebg.aqap.business.payment.utils.LinkPayTempCache;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayDetail;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayRequest;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayRequestBody;
import kd.ebg.aqap.common.entity.biz.pay.PayDetail;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.model.LinkPaymentInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class LinkPayUtils {
    public static final String LINKPAY_TYPE_TRANSDOWN = "linkPay_transDown";
    public static final String LINKPAY_TYPE_TRANSUP = "linkPay_transUp";
    public static final String LINKPAY_TYPE_PAY = "linkPay_pay";
    public static final String LINKPAY_TYPE_NATIVE = "linkPay_native";
    public static final String LINKPAY_STATUS_PROCESSING = LinkPayUtils.getLinkPayStatusProcessing();
    public static final String LINKPAY_STATUS_SUCCESS = LinkPayUtils.getLinkPayStatusSuccess();
    public static final String LINKPAY_STATUS_FAIL = LinkPayUtils.getLinkPayStatusFail();
    public static final String LINKPAY_STATUS_SUCCESS_MANUAL = LinkPayUtils.getLinkPayStatusSuccessManual();
    public static final String LINKPAY_STATUS_FAIL_MANUAL = LinkPayUtils.getLinkPayStatusFailManual();
    public static final String LINKPAY_STATUS_UNKNOWN_TRANSDOWN = LinkPayUtils.getLinkPayStatusUnknownTransDown();
    public static final String LINKPAY_STATUS_UNKNOWN_PAY = LinkPayUtils.getLinkPayStatusUnknownPay();
    public static final String LINKPAY_STATUS_UNKNOWN_TRANSUP = LinkPayUtils.getLinkPayStatusUnknownTransUp();
    public static final String LINKPAY_STATUS_FAIL_TRANSUP = LinkPayUtils.getLinkPayStatusFailTransUp();
    public static final String LINKPAY_STATUS_FAIL_TRANSUP_FAIL = LinkPayUtils.getLinkPayStatusFailTransUpFail();
    public static final String LINKPAY_STATUS_FAIL_TRANSUP_SUCCESS_MANUAL = LinkPayUtils.getLinkpayStatusFailTransupSuccessManual();
    public static final String LINKPAY_STATUS_FAIL_TRANSUP_FAIL_MANUAL = LinkPayUtils.getLinkpayStatusFailTransupFailManual();
    public static final String LINKPAY_STATUS_FAIL_TRANSUP_SUCCESS = LinkPayUtils.getLinkPayStatusFailTransUpSuccess();
    public static final String LINKPAY_STATUS_FAIL_BATCH_FAIL = LinkPayUtils.getLinkPayStatusFailTBatchFail();
    public static final String LINKPAY_STATUS_ACCEPTED = LinkPayUtils.getLinkPayStatusAccepted();
    public static final String LINKPAY_STATUS_UNKNOWN = LinkPayUtils.getLinkPayStatusUnknown();
    public static final String LINKPAY_TRANSDOWN_CODE = "linkPay_transDown_RqstSerialNo";
    public static final String BIZ_TYPE_PAY = "pay";
    public static final String SUB_BIZ_TYPE_LINKPAY = "pay_for_linkpay";
    public static final String LINKPAY = "linkPay";

    public static String getLinkPayStatusProcessing() {
        return ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"LinkPayUtils_0", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusSuccess() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u5df2\u6210\u529f", (String)"LinkPayUtils_1", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusFail() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u5df2\u5931\u8d25", (String)"LinkPayUtils_2", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusSuccessManual() {
        return ResManager.loadKDString((String)"\u624b\u5de5\u4fee\u6539\uff0c\u652f\u4ed8\u5df2\u6210\u529f\u3002", (String)"LinkPayUtils_3", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusFailManual() {
        return ResManager.loadKDString((String)"\u624b\u5de5\u4fee\u6539\uff0c\u652f\u4ed8\u5df2\u5931\u8d25\u3002", (String)"LinkPayUtils_4", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusUnknownTransDown() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u7b2c\u4e00\u6b65\u8d44\u91d1\u4e0b\u62e8\u652f\u4ed8\u672a\u786e\u8ba4\u3002", (String)"LinkPayUtils_11", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusUnknownPay() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u7b2c\u4e00\u6b65\u8d44\u91d1\u4e0b\u62e8\u652f\u4ed8\u6210\u529f\uff0c\u5bf9\u5916\u652f\u4ed8\u672a\u786e\u8ba4\u3002", (String)"LinkPayUtils_12", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusUnknownTransUp() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u7b2c\u4e8c\u6b65\u5bf9\u5916\u652f\u4ed8\u5df2\u5931\u8d25\uff0c\u8d44\u91d1\u4e0a\u5212\u652f\u4ed8\u672a\u786e\u8ba4\u3002", (String)"LinkPayUtils_13", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusFailTransUp() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u7b2c\u4e8c\u6b65\u5bf9\u5916\u652f\u4ed8\u5df2\u5931\u8d25\uff0c\u8d44\u91d1\u6b63\u5728\u4e0a\u5212\u4e2d\u3002", (String)"LinkPayUtils_5", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusFailTransUpFail() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u7b2c\u4e8c\u6b65\u5bf9\u5916\u652f\u4ed8\u5df2\u5931\u8d25\uff0c\u4e14\u8d44\u91d1\u4e0a\u5212\u5931\u8d25\u3002", (String)"LinkPayUtils_6", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkpayStatusFailTransupSuccessManual() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u7b2c\u4e8c\u6b65\u5bf9\u5916\u652f\u4ed8\u5df2\u5931\u8d25\uff0c\u8d44\u91d1\u4e0a\u5212\u624b\u5de5\u4fee\u6539\u4e3a\u652f\u4ed8\u6210\u529f\u3002", (String)"LinkPayUtils_17", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkpayStatusFailTransupFailManual() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u7b2c\u4e8c\u6b65\u5bf9\u5916\u652f\u4ed8\u5df2\u5931\u8d25\uff0c\u8d44\u91d1\u4e0a\u5212\u624b\u5de5\u4fee\u6539\u4e3a\u652f\u4ed8\u5931\u8d25\u3002", (String)"LinkPayUtils_18", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusFailTransUpSuccess() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u7b2c\u4e8c\u6b65\u5bf9\u5916\u652f\u4ed8\u5df2\u5931\u8d25\uff0c\u8d44\u91d1\u4e0a\u5212\u6210\u529f\u3002", (String)"LinkPayUtils_7", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusFailTBatchFail() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8\u7b2c\u4e8c\u6b65\u652f\u4ed8\u5df2\u5931\u8d25\uff0c\u8d44\u91d1\u4e0d\u4e0a\u5212(\u6279\u91cf\u5bf9\u5916)\u3002", (String)"LinkPayUtils_8", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusAccepted() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u5df2\u63a5\u6536", (String)"LinkPayUtils_9", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String getLinkPayStatusUnknown() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"LinkPayUtils_10", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static void initLinkPaymentInfo(PaymentInfo paymentInfo, String currency) {
        LinkPayTempCache linkPayTempCache = LinkPayCacheFactory.getInstance().getLinkPayTempCache();
        String bankCurr = linkPayTempCache.getBankCurrency(currency);
        paymentInfo.setCurrency(bankCurr);
        LocalDateTime now = LocalDateTime.now();
        paymentInfo.setInsertTime(now);
        paymentInfo.setUpdateTime(now);
        paymentInfo.setLastSubmitRequestReq("00000000");
        paymentInfo.setLastSyncRequestReq("00000000");
    }

    public static BankAcnt convertAddress(BankAcnt bankAcnt) {
        String bankAddress = bankAcnt.getBankAddress();
        String city = bankAcnt.getCity();
        String province = bankAcnt.getProvince();
        String country = bankAcnt.getCountry();
        if (!StringUtils.isEmpty((String)bankAddress)) {
            return bankAcnt;
        }
        if (!StringUtils.isEmpty((String)city)) {
            bankAcnt.setBankAddress(city);
            return bankAcnt;
        }
        if (!StringUtils.isEmpty((String)province)) {
            bankAcnt.setBankAddress(province);
            return bankAcnt;
        }
        if (!StringUtils.isEmpty((String)country)) {
            bankAcnt.setBankAddress(country);
            return bankAcnt;
        }
        new EBExceiptionUtil();
        throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s", (String)"LinkPayUtils_14", (String)"ebg-aqap-business", (Object[])new Object[0]), bankAcnt.getBankName()) + String.format(ResManager.loadKDString((String)"\u8d26\u53f7%s\u7684\u5f00\u6237\u5730\u533a\u4fe1\u606f\u3002", (String)"LinkPayUtils_15", (String)"ebg-aqap-business", (Object[])new Object[0]), bankAcnt.getAccNo())));
    }

    public static String getLastChildAcnt(LinkPayRequest linkpayRequest) {
        LinkPayRequestBody body = linkpayRequest.getBody();
        String lastChildAcnt = null;
        if (body.getChildAcnt5() != null) {
            lastChildAcnt = body.getChildAcnt5();
        } else if (body.getChildAcnt4() != null) {
            lastChildAcnt = body.getChildAcnt4();
        } else if (body.getChildAcnt3() != null) {
            lastChildAcnt = body.getChildAcnt3();
        } else if (body.getChildAcnt2() != null) {
            lastChildAcnt = body.getChildAcnt2();
        } else if (body.getChildAcnt1() != null) {
            lastChildAcnt = body.getChildAcnt1();
        }
        return lastChildAcnt;
    }

    public static String getLastChildAcnt(LinkPaymentInfo linkPaymentInfo) {
        String lastChildAcnt = null;
        if (StringUtils.isNotEmpty((String)linkPaymentInfo.getChildAcnt5())) {
            lastChildAcnt = linkPaymentInfo.getChildAcnt5();
        } else if (StringUtils.isNotEmpty((String)linkPaymentInfo.getChildAcnt4())) {
            lastChildAcnt = linkPaymentInfo.getChildAcnt4();
        } else if (StringUtils.isNotEmpty((String)linkPaymentInfo.getChildAcnt3())) {
            lastChildAcnt = linkPaymentInfo.getChildAcnt3();
        } else if (StringUtils.isNotEmpty((String)linkPaymentInfo.getChildAcnt2())) {
            lastChildAcnt = linkPaymentInfo.getChildAcnt2();
        } else if (StringUtils.isNotEmpty((String)linkPaymentInfo.getChildAcnt1())) {
            lastChildAcnt = linkPaymentInfo.getChildAcnt1();
        }
        return lastChildAcnt;
    }

    public static void pretreatment(PaymentInfo info) {
        StringBuilder packageKey = new StringBuilder();
        packageKey.append("\r\n").append("--------").append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8def\u7531\u65e5\u5fd7", (String)"PaymentUtil_2", (String)"ebg-aqap-business", (Object[])new Object[0])).append("---------").append("\r\n").append("\r\n");
        packageKey.append(LinkPayUtils.getPaymentPropertyTranslate("bizType")).append(info.getBizType()).append(" | ");
        packageKey.append(LinkPayUtils.getPaymentPropertyTranslate("subBizType")).append(info.getSubBizType()).append("\r\n");
        packageKey.append(LinkPayUtils.getPaymentPropertyTranslate("individual")).append(info.is2Individual()).append("\r\n");
        packageKey.append(LinkPayUtils.getPaymentPropertyTranslate("sameBank")).append(info.is2SameBank()).append("\r\n");
        packageKey.append(LinkPayUtils.getPaymentPropertyTranslate("sameCity")).append(info.is2SameCity()).append("\r\n");
        packageKey.append(LinkPayUtils.getPaymentPropertyTranslate("urgent")).append(info.is2Urgent()).append("\r\n");
        packageKey.append(LinkPayUtils.getPaymentPropertyTranslate("is2Merge")).append(info.is2Merge()).append("\r\n");
        packageKey.append(LinkPayUtils.getPaymentPropertyTranslate("useCn")).append(info.getUseCN()).append("\r\n");
        packageKey.append("-----------").append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8def\u7531\u94fe\u8def", (String)"PaymentUtil_3", (String)"ebg-aqap-business", (Object[])new Object[0])).append("----------").append("\r\n");
        info.setPackageKey(packageKey.toString());
        if (BizName.Pay.INDIVIDUAL.name().equalsIgnoreCase(info.getSubBizType())) {
            info.setIndividual(Boolean.valueOf(true));
        } else if (BizName.Pay.COMPANY.name().equalsIgnoreCase(info.getSubBizType())) {
            info.setIndividual(Boolean.valueOf(false));
        } else if (BizName.Pay.PAY_FOR_CAPITAL_ALLOCATION.name().equalsIgnoreCase(info.getSubBizType())) {
            info.setIndividual(Boolean.valueOf(false));
        } else if (!BizName.Pay.INCOME.name().equalsIgnoreCase(info.getSubBizType())) {
            if (BizName.Pay.SALARY.name().equalsIgnoreCase(info.getSubBizType())) {
                info.setIndividual(Boolean.valueOf(true));
            } else if (!BizName.Pay.PAY_FOR_LINKPAY.name().equalsIgnoreCase(info.getSubBizType())) {
                if (BizName.Pay.PAY_FOR_AGENTPAY.name().equalsIgnoreCase(info.getSubBizType())) {
                    info.setIndividual(Boolean.valueOf(false));
                } else if (!BizName.PAY.name().equalsIgnoreCase(info.getSubBizType())) {
                    if (BizName.Pay.PAY_FOR_SALARY.name().equalsIgnoreCase(info.getSubBizType())) {
                        info.setIndividual(Boolean.valueOf(true));
                    } else if (!BizName.OVERSEAPAY.name().equalsIgnoreCase(info.getSubBizType())) {
                        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b50\u4e1a\u52a1\u7c7b\u578b:%s\u3002", (String)"LinkPayUtils_16", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getSubBizType()));
                    }
                }
            }
        }
    }

    private static String getPaymentPropertyTranslate(String key) {
        Map paymentPropertyTranslateMap = IPretreat.getPaymentPropertyTranslateMap();
        if (paymentPropertyTranslateMap.containsKey(key = key.replaceAll("=", ""))) {
            return (String)paymentPropertyTranslateMap.get(key) + "=";
        }
        return key + "=";
    }

    public static LinkPayDetail convertPaymentDetail2LinkPayDetail(PayDetail paymentDetail) {
        LinkPayDetail linkPayDetail = new LinkPayDetail();
        linkPayDetail.setDetailSeqID(paymentDetail.getDetailSeqID());
        linkPayDetail.setDetailBizNo(paymentDetail.getDetailBizNo());
        linkPayDetail.setIncomeAccNo(paymentDetail.getIncomeAccNo());
        linkPayDetail.setIncomeAccName(paymentDetail.getIncomeAccName());
        linkPayDetail.setIncomeType(paymentDetail.getIncomeType());
        linkPayDetail.setIncomeBankName(paymentDetail.getIncomeBankName());
        linkPayDetail.setIncomeBankAddress(paymentDetail.getIncomeBankAddress());
        linkPayDetail.setIncomeCountry(paymentDetail.getIncomeCountry());
        linkPayDetail.setIncomeProvince(paymentDetail.getIncomeProvince());
        linkPayDetail.setIncomeCity(paymentDetail.getIncomeCity());
        linkPayDetail.setIncomeAreaCode(paymentDetail.getIncomeAreaCode());
        linkPayDetail.setIncomeCnapsCode(paymentDetail.getIncomeCnapsCode());
        linkPayDetail.setIncomeSwiftCode(paymentDetail.getIncomeSwiftCode());
        linkPayDetail.setAmount(paymentDetail.getAmount());
        linkPayDetail.setBookingTime(paymentDetail.getBookingTime());
        linkPayDetail.setUrgent(paymentDetail.isUrgent());
        linkPayDetail.setForce(paymentDetail.isForce());
        linkPayDetail.setExplanation(paymentDetail.getExplanation());
        linkPayDetail.setMobile(paymentDetail.getMobile());
        linkPayDetail.setEmail(paymentDetail.getEmail());
        linkPayDetail.setVerifyField(paymentDetail.getVerifyField());
        linkPayDetail.setEbSeqId(paymentDetail.getEbSeqId());
        linkPayDetail.setEbStatus(paymentDetail.getEbStatus());
        linkPayDetail.setEbStatusMsg(paymentDetail.getEbStatusMsg());
        linkPayDetail.setBankBatchSeqId(paymentDetail.getBankBatchSeqId());
        linkPayDetail.setUseCode(paymentDetail.getUseCode());
        linkPayDetail.setUseCN(paymentDetail.getUseCN());
        linkPayDetail.setBankDetailSeqId(paymentDetail.getBankDetailSeqId());
        linkPayDetail.setResponseSerialNo(paymentDetail.getResponseSerialNo());
        return linkPayDetail;
    }

    public static void compensation(LinkPaymentInfo linkPaymentInfo, PaymentInfo paymentInfo) {
        if (LINKPAY_TYPE_PAY.equalsIgnoreCase(paymentInfo.getLinkpayType()) && !LINKPAY_TYPE_PAY.equalsIgnoreCase(linkPaymentInfo.getLinkpayType())) {
            linkPaymentInfo.setLinkpayType(LINKPAY_TYPE_PAY);
        } else if (LINKPAY_TYPE_TRANSUP.equalsIgnoreCase(paymentInfo.getLinkpayType()) && !LINKPAY_TYPE_TRANSUP.equalsIgnoreCase(linkPaymentInfo.getLinkpayType())) {
            linkPaymentInfo.setLinkpayType(LINKPAY_TYPE_TRANSUP);
        }
    }
}

