/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.business.payment.atomic.ICheck;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.exception.IllegalPaymentResult;
import kd.ebg.aqap.business.payment.exception.InvalidPaymentResult;
import kd.ebg.aqap.business.payment.priority.PayPriority;
import kd.ebg.aqap.business.payment.route.PayRouteEnum;
import kd.ebg.aqap.business.payment.route.PayTypeEnum;
import kd.ebg.aqap.business.payment.utils.CheckUtil;
import kd.ebg.aqap.business.payment.utils.PaymentAmountUtils;
import kd.ebg.aqap.business.payment.utils.SubmitPayRunnale;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.linkpay.LinkPayRequest;
import kd.ebg.aqap.common.entity.biz.pay.OverseaPayRequest;
import kd.ebg.aqap.common.entity.biz.pay.PayDetail;
import kd.ebg.aqap.common.entity.biz.pay.PayRequest;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.services.ObjectPropertyOpService;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.Rule;
import kd.ebg.aqap.common.utils.ReUtil;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;
import kd.sdk.annotation.SdkDeprecated;

public class PaymentUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentUtil.class);

    public static void preTreatment(List<PaymentInfo> paymentInfos) {
        logger.info("\u4ed8\u6b3e\u8def\u7531");
        for (PaymentInfo info : paymentInfos) {
            if (!StringUtils.isEmpty((String)info.getImplClassName())) continue;
            PaymentUtil.preTreatmentEach(info);
        }
    }

    public static void preTreatment(List<PaymentInfo> paymentInfos, InvalidPaymentResult paymentResult) {
        ObjectPropertyOpService objectPropertyService;
        String openPayForSalary;
        logger.info("\u94f6\u884c\u4ed8\u6b3e\u63a5\u53e3\u8def\u7531");
        IllegalPaymentResult illegalPaymentResult = new IllegalPaymentResult();
        for (PaymentInfo info : paymentInfos) {
            if (!StringUtils.isEmpty((String)info.getImplClassName())) continue;
            try {
                PaymentUtil.preTreatmentEach(info);
                if (!StringUtils.isEmpty((String)info.getImplClassName())) continue;
                String errorMsg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5206\u5f55\u4e3a%1$s\u7684\u4ed8\u6b3e\u8def\u7531\u7ed3\u679c\u4e3a\u7a7a\uff0c%2$s", (String)"PaymentUtil_4", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getDetailSeqID(), info.getPackageKey());
                logger.error(errorMsg);
                illegalPaymentResult.addIllegalPayment(info.getDetailSeqID(), PaymentUtil.getMissPayRouteTip(info));
            }
            catch (EBPreCheckException e) {
                illegalPaymentResult.addIllegalPayment(info.getDetailSeqID(), info.getBankName() + e.getMessage());
            }
            catch (Throwable e) {
                illegalPaymentResult.addIllegalPayment(info.getDetailSeqID(), PaymentUtil.getMissPayRouteTip(info));
            }
        }
        if (illegalPaymentResult.isHasIllegal() && paymentResult.isBatchRollBack()) {
            throw EBExceiptionUtil.preCheckException((String)illegalPaymentResult.toString());
        }
        paymentResult.addIllegalPaymentResult(illegalPaymentResult);
        if (UseConvertor.isSalary((PaymentInfo)paymentInfos.get(0)) && !StringUtils.equalsIgnoreCase((String)"true", (String)(openPayForSalary = (objectPropertyService = (ObjectPropertyOpService)SpringContextUtil.getBean(ObjectPropertyOpService.class)).isOpenPayForSalary(EBContext.getContext().getBankVersionID())))) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u672a\u542f\u7528\u6216\u6682\u4e0d\u652f\u6301\u4ee3\u53d1\u5de5\u8d44\uff0c\u8bf7\u5728\u67e5\u8be2\u4e0e\u652f\u4ed8-\u94f6\u884c\u53c2\u6570\u914d\u7f6e\u5185\u786e\u8ba4\u662f\u5426\u6709\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u53c2\u6570\uff0c\u786e\u8ba4\u5b8c\u6210\u53ef\u4ee5\u5f00\u542f\u4ee3\u53d1\u5de5\u8d44\u4e1a\u52a1\u5f00\u5173\u540e\u91cd\u8bd5\u3002", (String)"PaymentConvert_15", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }

    public static String getMissPayRouteTip(PaymentInfo paymentInfo) {
        String bankName = paymentInfo.getBankName();
        try {
            PayRouteEnum payRoute = PayTypeEnum.PAY_FOR_SALARY.getName().equalsIgnoreCase(paymentInfo.getSubBizType()) ? (UseConvertor.isReim((PaymentInfo)paymentInfo) ? PayRouteEnum.DFBX : PayRouteEnum.DFGZ) : (PayTypeEnum.PAY_FOR_CAPITAL_ALLOCATION.getName().equalsIgnoreCase(paymentInfo.getSubBizType()) ? (UseConvertor.isTransUp((PaymentInfo)paymentInfo) ? PayRouteEnum.ZJSH : PayRouteEnum.ZJXB) : (PayTypeEnum.PAY_FOR_LINKPAY.getName().equalsIgnoreCase(paymentInfo.getSubBizType()) ? PayRouteEnum.LDZF : (PayTypeEnum.OVERSEA_PAY.getName().equalsIgnoreCase(paymentInfo.getSubBizType()) ? PayRouteEnum.KJZF : (paymentInfo.is2Individual() ? PayRouteEnum.INDIVIDUAL : PayRouteEnum.DGFK))));
            return EBExceiptionUtil.missPayRoute((String)bankName, (String)payRoute.getDesc());
        }
        catch (EBServiceException e) {
            return e.getMessage();
        }
    }

    public static void execCheck(List<PaymentInfo> paymentInfos, InvalidPaymentResult paymentResult) {
        IllegalPaymentResult illegalPaymentResult = new IllegalPaymentResult();
        for (PaymentInfo info : paymentInfos) {
            try {
                PaymentUtil.execCheck(info);
            }
            catch (Throwable e) {
                illegalPaymentResult.addIllegalPayment(info.getDetailSeqID(), e.getMessage());
            }
        }
        if (illegalPaymentResult.isHasIllegal() && paymentResult.isBatchRollBack()) {
            throw EBExceiptionUtil.preCheckException((String)illegalPaymentResult.toString());
        }
        paymentResult.addIllegalPaymentResult(illegalPaymentResult);
    }

    public static void checkBookingTime(List<PaymentInfo> paymentInfos) {
        if (CollectionUtil.isEmpty(paymentInfos) || paymentInfos.size() == 1) {
            return;
        }
        IllegalPaymentResult illegalPaymentResult = new IllegalPaymentResult();
        String bankVersionID = paymentInfos.get(0).getBankVersionID();
        ICheck checker = (ICheck)BankBundleManager.getInstance().getImplOrNull(bankVersionID, ICheck.class);
        if (Objects.isNull(checker)) {
            return;
        }
        List<Rule> rules = checker.checkBatchBookingTime(paymentInfos);
        if (CollectionUtil.isEmpty(rules)) {
            return;
        }
        for (Rule rule : rules) {
            if (rule.isPass()) continue;
            illegalPaymentResult.addIllegalPayment(rule.getDetailSeqId(), rule.getMsgIfNotPass());
        }
        if (illegalPaymentResult.isHasIllegal()) {
            throw EBExceiptionUtil.preCheckException((String)illegalPaymentResult.toString());
        }
    }

    private static void execCheck(PaymentInfo info) {
        String bankVersionID = info.getBankVersionID();
        ICheck checker = (ICheck)BankBundleManager.getInstance().getImplOrNull(bankVersionID, ICheck.class);
        if (Objects.isNull(checker)) {
            return;
        }
        List<Rule> rules = checker.check(info);
        if (CollectionUtil.isEmpty(rules)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Rule rule : rules) {
            if (rule.isPass()) continue;
            sb.append(rule.getMsgIfNotPass()).append("\r\n");
        }
        String errorMsg = sb.toString();
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            throw EBExceiptionUtil.preCheckException((String)errorMsg);
        }
    }

    private static String getPaymentPropertyTranslate(String key) {
        Map paymentPropertyTranslateMap = IPretreat.getPaymentPropertyTranslateMap();
        if (paymentPropertyTranslateMap.containsKey(key = key.replaceAll("=", ""))) {
            return (String)paymentPropertyTranslateMap.get(key) + "=";
        }
        return key + "=";
    }

    private static void preTreatmentEach(PaymentInfo info) {
        if (BizName.Pay.INDIVIDUAL.name().equalsIgnoreCase(info.getSubBizType())) {
            info.setIndividual(Boolean.valueOf(true));
        } else if (BizName.Pay.COMPANY.name().equalsIgnoreCase(info.getSubBizType())) {
            info.setIndividual(Boolean.valueOf(false));
        } else if (BizName.Pay.PAY_FOR_CAPITAL_ALLOCATION.name().equalsIgnoreCase(info.getSubBizType())) {
            info.setIndividual(Boolean.valueOf(false));
        } else if (!BizName.Pay.INCOME.name().equalsIgnoreCase(info.getSubBizType())) {
            if (BizName.Pay.SALARY.name().equalsIgnoreCase(info.getSubBizType())) {
                info.setIndividual(Boolean.valueOf(true));
            } else if (!BizName.Pay.PAY_FOR_LINKPAY.name().equalsIgnoreCase(info.getSubBizType())) {
                if (BizName.Pay.PAY_FOR_AGENTPAY.name().equalsIgnoreCase(info.getSubBizType())) {
                    info.setIndividual(Boolean.valueOf(false));
                } else if (!BizName.PAY.name().equalsIgnoreCase(info.getSubBizType())) {
                    if (BizName.Pay.PAY_FOR_SALARY.name().equalsIgnoreCase(info.getSubBizType())) {
                        info.setIndividual(Boolean.valueOf(true));
                    } else if (!(BizName.OVERSEAPAY.name().equalsIgnoreCase(info.getSubBizType()) || BizName.Pay.RECHARGE.name().equalsIgnoreCase(info.getSubBizType()) || BizName.Pay.WITHDRAWAL.name().equalsIgnoreCase(info.getSubBizType()))) {
                        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b50\u4e1a\u52a1\u7c7b\u578b:%s\u3002", (String)"PaymentUtil_1", (String)"ebg-aqap-business", (Object[])new Object[0]), info.getSubBizType()));
                    }
                }
            }
        }
        String bankVersionID = info.getBankVersionID();
        IPretreat pretreat = (IPretreat)BankBundleManager.getInstance().getImpl(bankVersionID, IPretreat.class, (Object)info);
        if (pretreat == null) {
            IPay pay = (IPay)BankBundleManager.getInstance().getImpl(bankVersionID, IPay.class, (Object)info);
            Object queryPayImpl = null;
            if (pay != null) {
                Class<? extends IQueryPay> queryPayImplClass = pay.defaultQueryClass();
                info.setImplClassName(pay.getClass().getName());
                if (Objects.nonNull(queryPayImplClass)) {
                    queryPayImpl = (IQueryPay)BankBundleManager.getInstance().getImplByClassName(info.getBankVersionID(), IQueryPay.class, queryPayImplClass.getName());
                }
                if (Objects.isNull(queryPayImpl)) {
                    queryPayImpl = (IQueryPay)BankBundleManager.getInstance().getImpl(bankVersionID, IQueryPay.class, (Object)info);
                }
                if (queryPayImpl != null) {
                    info.setQueryImplClassName(queryPayImpl.getClass().getName());
                }
            }
        } else {
            pretreat.appendData(info);
        }
        info.setStatus(Integer.valueOf(PaymentState.PACKAGED.getId()));
        info.setStatusName(PaymentState.PACKAGED.getEnName());
        info.setStatusMsg(PaymentState.PACKAGED.getCnName());
        PaymentUtil.bigMoneyPaymentNotice(info);
    }

    public static void payPriority(List<PaymentInfo> paymentInfos) {
        logger.info("\u4ed8\u6b3e\u8def\u7531\u89c4\u5219");
        PayPriority payPriority = new PayPriority();
        for (PaymentInfo info : paymentInfos) {
            payPriority.match(info);
        }
        payPriority.release();
        logger.info("\u4ed8\u6b3e\u8def\u7531\u89c4\u5219\u5b8c\u6210");
    }

    public static void payRouteTrace(List<PaymentInfo> paymentInfoList) {
        for (PaymentInfo paymentInfo : paymentInfoList) {
            StringBuilder packageKey = new StringBuilder();
            packageKey.append("\r\n").append("--------").append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8def\u7531\u65e5\u5fd7", (String)"PaymentUtil_2", (String)"ebg-aqap-business", (Object[])new Object[0])).append("---------").append("\r\n").append("\r\n");
            packageKey.append(PaymentUtil.getPaymentPropertyTranslate("bizType")).append(paymentInfo.getBizType()).append(" | ");
            packageKey.append(PaymentUtil.getPaymentPropertyTranslate("subBizType")).append(paymentInfo.getSubBizType()).append("\r\n");
            packageKey.append(PaymentUtil.getPaymentPropertyTranslate("individual")).append(paymentInfo.is2Individual()).append("\r\n");
            packageKey.append(PaymentUtil.getPaymentPropertyTranslate("sameBank")).append(paymentInfo.is2SameBank()).append("\r\n");
            packageKey.append(PaymentUtil.getPaymentPropertyTranslate("sameCity")).append(paymentInfo.is2SameCity()).append("\r\n");
            packageKey.append(PaymentUtil.getPaymentPropertyTranslate("urgent")).append(paymentInfo.is2Urgent()).append("\r\n");
            packageKey.append(PaymentUtil.getPaymentPropertyTranslate("is2Merge")).append(paymentInfo.is2Merge()).append("\r\n");
            packageKey.append(PaymentUtil.getPaymentPropertyTranslate("useCn")).append(paymentInfo.getUseCN()).append("\r\n");
            packageKey.append("-----------").append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8def\u7531\u94fe\u8def", (String)"PaymentUtil_3", (String)"ebg-aqap-business", (Object[])new Object[0])).append("----------").append("\r\n");
            paymentInfo.setPackageKey(packageKey.toString());
        }
    }

    public static void setBankSerialNo(List<PaymentInfo> paymentInfos) {
        int bankSerialNo = 1;
        for (PaymentInfo paymentInfo : paymentInfos) {
            paymentInfo.setBankSerialNo(String.valueOf(bankSerialNo++));
        }
    }

    public static void setReDevResult(PaymentInfo paymentInfo) {
        EBContext ebContext = EBContext.getContext();
        if (ebContext == null) {
            ebContext = EBContext.builder().build();
            EBContext.setContext((EBContext)ebContext);
        }
        ebContext.setReDevResult((Object)paymentInfo);
    }

    public static void clearReDevResult() {
        EBContext ebContext = EBContext.getContext();
        if (ebContext != null) {
            ebContext.setReDevResult(null);
        }
    }

    public static Set<List<PaymentInfo>> packagePay(List<PaymentInfo> paymentInfos) {
        logger.info("\u5f00\u59cb\u6309\u94f6\u884c\u63a5\u53e3\u8fdb\u884c\u6253\u5305");
        HashSet<List<PaymentInfo>> result = new HashSet<List<PaymentInfo>>();
        if (paymentInfos != null && paymentInfos.size() > 0) {
            PaymentInfo paymentInfo = paymentInfos.get(0);
            PaymentUtil.setReDevResult(paymentInfo);
            String bankVersionID = paymentInfo.getBankVersionID();
            Map paymentGroupByMerge = paymentInfos.stream().collect(Collectors.groupingBy(PaymentInfo::is2Merge, LinkedHashMap::new, Collectors.toList()));
            for (Map.Entry groupEntry : paymentGroupByMerge.entrySet()) {
                LinkedHashMap maps = Maps.newLinkedHashMap();
                for (PaymentInfo info : (List)groupEntry.getValue()) {
                    List infos;
                    String implClassName = info.getImplClassName();
                    if (maps.containsKey(implClassName)) {
                        infos = (List)maps.get(implClassName);
                        infos.add(info);
                        continue;
                    }
                    infos = Lists.newArrayList((Object[])new PaymentInfo[]{info});
                    maps.put(implClassName, infos);
                }
                Map configBatchSizeByBank = PaymentUtil.getConfigBatchSizeByBank(bankVersionID);
                for (Map.Entry entry : maps.entrySet()) {
                    String implClass = (String)entry.getKey();
                    List infos = (List)entry.getValue();
                    IPay pay = (IPay)BankBundleManager.getInstance().getImplByClassName(bankVersionID, IPay.class, implClass);
                    int batchSize = pay.getBatchSize();
                    if (batchSize <= 1) {
                        batchSize = 1;
                    } else {
                        Integer configBatchSize = (Integer)configBatchSizeByBank.get(implClass);
                        if (configBatchSize != null && configBatchSize > 1) {
                            batchSize = configBatchSize;
                        }
                    }
                    if (infos.size() <= batchSize) {
                        PaymentUtil.addBankSeqID(bankVersionID, infos, batchSize);
                        PaymentUtil.setBankSerialNo(infos);
                        result.add(infos);
                        continue;
                    }
                    for (int startIndex = 0; startIndex < infos.size(); startIndex += batchSize) {
                        int endIndex = startIndex + batchSize;
                        if (endIndex > infos.size()) {
                            endIndex = infos.size();
                        }
                        List<PaymentInfo> temp = infos.subList(startIndex, endIndex);
                        PaymentUtil.setBankSerialNo(temp);
                        result.add(temp);
                        PaymentUtil.addBankSeqID(bankVersionID, temp, batchSize);
                    }
                }
            }
            PaymentUtil.clearReDevResult();
            logger.info("\u94f6\u884c\u63a5\u53e3\u6253\u5305\u5b8c\u6210");
        }
        return result;
    }

    public static void recountTotalAmount(Set<List<PaymentInfo>> paymentInfoSet) {
        for (List<PaymentInfo> paymentInfoList : paymentInfoSet) {
            BigDecimal totalAmount = PaymentAmountUtils.getTotalAmount(paymentInfoList);
            for (PaymentInfo info : paymentInfoList) {
                info.setTotalCount(Integer.valueOf(paymentInfoList.size()));
                info.setTotalAmount(totalAmount);
            }
        }
    }

    private static void addBankSeqID(String bankVersionID, List<PaymentInfo> infos, int ImplBatchSize) {
        String bankBatchSeqID = "";
        String bankDetailSeqID = "";
        if (ImplBatchSize == 1 || infos.size() == 1) {
            DynamicObject payObject;
            QFilter filter = QFilter.of((String)"attr_key=? and object_id=? and object_name=?", (Object[])new Object[]{"payment_fix_serial_num", bankVersionID, "BANK_BUSINESS"});
            boolean isPaymentFixSerialNum = false;
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_object_properties", (String)"attr_value", (QFilter[])filter.toArray());
            if (dynamicObject != null) {
                isPaymentFixSerialNum = dynamicObject.getBoolean("attr_value");
            }
            if (isPaymentFixSerialNum && (payObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aqap_bd_paymentinfo", (String)"bank_batch_seq_id,bank_detail_seq_id", (QFilter[])(filter = QFilter.of((String)"detail_biz_no=? and back_bank_status<>'1'", (Object[])new Object[]{infos.get(0).getDetailBizNo()})).toArray())) != null) {
                bankBatchSeqID = payObject.getString("bank_batch_seq_id");
                bankDetailSeqID = payObject.getString("bank_detail_seq_id");
                if (StringUtils.isNotEmpty((String)bankDetailSeqID) && StringUtils.isNotEmpty((String)bankBatchSeqID)) {
                    logger.info("\u94f6\u884c\u53c2\u6570-[\u540c\u7b14\u4ed8\u6b3e\u5355\u662f\u5426\u4f7f\u7528\u76f8\u540c\u94f6\u884c\u6d41\u6c34\u53f7]\u914d\u7f6e\u5df2\u5f00\u542f\uff0c\u5c06\u4f7f\u7528\u4e0a\u4e00\u7b14\u4ed8\u6b3e\u6d41\u6c34\u53f7");
                    infos.get(0).setBankBatchSeqID(bankBatchSeqID);
                    infos.get(0).setBankDetailSeqID(bankDetailSeqID);
                    infos.get(0).setStatus(Integer.valueOf(PaymentState.PACKAGED.getId()));
                    infos.get(0).setStatusName(PaymentState.PACKAGED.getEnName());
                    infos.get(0).setStatusMsg(PaymentState.PACKAGED.getCnName());
                    return;
                }
            }
        }
        IBankBatchSeqIDCreator bankBatchSeqIDCreator = (IBankBatchSeqIDCreator)BankBundleManager.getInstance().getBatchSeqIdImplOrNull(bankVersionID);
        if (StringUtils.isEmpty((String)bankBatchSeqID)) {
            bankBatchSeqID = Objects.nonNull(bankBatchSeqIDCreator) ? bankBatchSeqIDCreator.getBankBatchSeqID() : Sequence.gen16Sequence();
            EBContext.getContext().setBizSeqID(bankBatchSeqID);
        }
        for (PaymentInfo info : infos) {
            info.setBankBatchSeqID(bankBatchSeqID);
            info.setStatus(Integer.valueOf(PaymentState.PACKAGED.getId()));
            info.setStatusName(PaymentState.PACKAGED.getEnName());
            info.setStatusMsg(PaymentState.PACKAGED.getCnName());
            IBankDetailSeqIDCreator bankDetailSeqIDCreator = (IBankDetailSeqIDCreator)BankBundleManager.getInstance().getDetailSeqIdImplOrNull(bankVersionID);
            bankDetailSeqID = Objects.nonNull(bankDetailSeqIDCreator) ? bankDetailSeqIDCreator.getBankDetailSeqID() : Sequence.genSequence();
            info.setBankDetailSeqID(bankDetailSeqID);
        }
    }

    public static void insertPay(List<PaymentInfo> paymentInfos) {
        LocalDateTime insertTime = LocalDateTime.now();
        paymentInfos.forEach(info -> {
            info.setInsertTime(insertTime);
            info.setSyncCount(Integer.valueOf(0));
            info.setEbgID(((SingleNodeIDGetter)SpringContextUtil.getBean(SingleNodeIDGetter.class)).nodeID());
        });
        PaymentInfoService.getInstance().save(paymentInfos, true);
    }

    public static void checkExplanationSpecialCharPool(EBRequest request, InvalidPaymentResult paymentResult) {
        PayRequest payRequest;
        IllegalPaymentResult illegalPaymentResult = new IllegalPaymentResult();
        ArrayList payDetailList = new ArrayList(16);
        if (request instanceof PayRequest) {
            payRequest = (PayRequest)request;
            payDetailList.addAll(payRequest.getBody().getDetails());
        } else if (request instanceof OverseaPayRequest) {
            payRequest = (OverseaPayRequest)request;
            payDetailList.addAll(payRequest.getBody().getDetails());
        }
        for (PayDetail detail : payDetailList) {
            try {
                PaymentUtil.checkExplanationSpecialCharPool(EBContext.getContext().getBankVersionID(), detail.getExplanation());
            }
            catch (EBPreCheckException e) {
                illegalPaymentResult.addIllegalPayment(detail.getDetailSeqID(), e.getMessage());
            }
        }
        if (illegalPaymentResult.isHasIllegal() && paymentResult.isBatchRollBack()) {
            throw EBExceiptionUtil.preCheckException((String)illegalPaymentResult.toString());
        }
        paymentResult.addIllegalPaymentResult(illegalPaymentResult);
    }

    public static void checkExplanationSpecialCharPool(String bankVersionID, String explanation) {
        List pools;
        if (StringUtils.isNotEmpty((String)explanation) && CollectionUtil.isNotEmpty((Collection)(pools = BankPropertyConfig.getExplanationSpecialCharPool((String)bankVersionID)))) {
            for (String pool : pools) {
                if (!StringUtils.isNotEmpty((String)explanation) || !explanation.contains(pool)) continue;
                throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355\u5185\u586b\u5199\u7684\u6458\u8981\u5305\u542b\u4e0d\u89c4\u8303\u7684\u7279\u6b8a\u5b57\u7b26\u4fe1\u606f\uff1b\u8be6\u60c5\u53ef\u4ee5\u67e5\u770b\u67e5\u8be2\u4e0e\u652f\u4ed8-\u94f6\u884c\u53c2\u6570\u914d\u7f6e\u7684\u4ed8\u6b3e\u6458\u8981\u7279\u6b8a\u5b57\u7b26\u6c60\uff1b", (String)"AccessUtils_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
    }

    public static void checkInvalidPayments(List<PaymentInfo> paymentInfos, InvalidPaymentResult paymentResult) {
        IllegalPaymentResult illegalPaymentResult = new IllegalPaymentResult();
        HashSet<String> detailSeqIDSet = new HashSet<String>(16);
        for (PaymentInfo paymentInfo : paymentInfos) {
            try {
                CheckUtil.checkLength("explanation", paymentInfo.getExplanation(), 800);
                CheckUtil.checkLength("incomeAccName", paymentInfo.getIncomeAccName(), 255);
                CheckUtil.checkLength("incomeBankName", paymentInfo.getIncomeBankName(), 255);
                CheckUtil.checkLength("incomeBankAddress", paymentInfo.getIncomeBankAddress(), 255);
                String detailSeqID = paymentInfo.getDetailSeqID();
                Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)detailSeqID), (Object)ResManager.loadKDString((String)"detailSeqID \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentConvert_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
                Preconditions.checkState((!detailSeqIDSet.contains(detailSeqID) ? 1 : 0) != 0, (Object)String.format(ResManager.loadKDString((String)"detailSeqID \u91cd\u590d : %s\u3002", (String)"PaymentConvert_23", (String)"ebg-aqap-business", (Object[])new Object[0]), detailSeqID));
                detailSeqIDSet.add(detailSeqID);
                if ("overseaPay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.getBankVersionID().equalsIgnoreCase("BOCHK_DC") && StringUtils.isNotEmpty((String)paymentInfo.getUseCN()) && ResManager.loadKDString((String)"\u8f6c\u6570\u5feb", (String)"PaymentConvert_8", (String)"ebg-aqap-business", (Object[])new Object[0]).equalsIgnoreCase(paymentInfo.getUseCN().trim())) {
                    logger.info("skip check IncomeAccNo");
                } else {
                    Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)paymentInfo.getIncomeAccNo()), (Object)MultiLang.getIncomeAccountEmptyTip());
                    Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)paymentInfo.getIncomeBankName()), (Object)MultiLang.getIncomeBankEmptyTip());
                }
                Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)paymentInfo.getIncomeAccName()), (Object)ResManager.loadKDString((String)"\u6536\u6b3e\u6237\u540d[\u82f1\u6587\u7f16\u7801\uff1aincomeAccName]\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentConvert_9", (String)"ebg-aqap-business", (Object[])new Object[0]));
                Preconditions.checkArgument((boolean)Objects.nonNull(paymentInfo.getAmount()), (Object)ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d[\u82f1\u6587\u7f16\u7801\uff1aamount]\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentConvert_10", (String)"ebg-aqap-business", (Object[])new Object[0]));
                Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)paymentInfo.getExplanation()), (Object)ResManager.loadKDString((String)"\u8f6c\u8d26\u9644\u8a00[\u82f1\u6587\u7f16\u7801\uff1aexplanation]\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentConvert_11", (String)"ebg-aqap-business", (Object[])new Object[0]));
                if (PayTypeEnum.OVERSEA_PAY.getName().equalsIgnoreCase(paymentInfo.getSubBizType()) || StringUtils.isEmpty((String)paymentInfo.getIncomeCnaps())) continue;
                Preconditions.checkArgument((boolean)ReUtil.isMatch((String)"^\\d{1,12}$", (String)paymentInfo.getIncomeCnaps()), (Object)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u8054\u884c\u53f7[\u82f1\u6587\u7f16\u7801\uff1aincomeCnaps]\u5c5e\u6027\u503c\u201d%s\u201c\u7684\u683c\u5f0f\u4e0d\u6b63\u786e,\u53ea\u80fd\u4e3a\u4e0d\u5927\u4e8e12\u4f4d\u7684\u7eaf\u6570\u5b57\u3002", (String)"PaymentConvert_14", (String)"ebg-aqap-business", (Object[])new Object[0]), paymentInfo.getIncomeCnaps()));
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                illegalPaymentResult.addIllegalPayment(paymentInfo.getDetailSeqID(), e.getMessage());
            }
        }
        if (illegalPaymentResult.isHasIllegal() && paymentResult.isBatchRollBack()) {
            throw EBExceiptionUtil.preCheckException((String)illegalPaymentResult.toString());
        }
        paymentResult.addIllegalPaymentResult(illegalPaymentResult);
    }

    public static boolean isBatchPayRollBack(EBRequest request) {
        String subBizType = request.getHeader().getSubBizType();
        if (PayTypeEnum.SALARY.getName().equalsIgnoreCase(subBizType) || PayTypeEnum.PAY_FOR_SALARY.getName().equalsIgnoreCase(subBizType) || PayTypeEnum.ALLOCATION.getName().equalsIgnoreCase(subBizType) || PayTypeEnum.PAY_FOR_CAPITAL_ALLOCATION.getName().equalsIgnoreCase(subBizType)) {
            return true;
        }
        boolean isBatchRollBack = true;
        if (request instanceof PayRequest) {
            PayRequest payRequest = (PayRequest)request;
            isBatchRollBack = payRequest.getBody().isBatchRollBack();
        } else if (request instanceof OverseaPayRequest) {
            OverseaPayRequest payRequest = (OverseaPayRequest)request;
            isBatchRollBack = payRequest.getBody().isBatchRollBack();
        } else if (request instanceof LinkPayRequest) {
            LinkPayRequest payRequest = (LinkPayRequest)request;
            isBatchRollBack = payRequest.getBody().isBatchRollBack();
        }
        return isBatchRollBack;
    }

    public static void checkBizNO(EBRequest request) {
        JSONObject jsonObject;
        PayRequest payRequest;
        logger.info("\u68c0\u67e5\u4ed8\u6b3e\u5355\u636e\u4e1a\u52a1\u53f7\u662f\u5426\u91cd\u590d");
        String extData = "";
        String bodyExtData = "";
        ArrayList payDetailList = new ArrayList(16);
        if (request instanceof PayRequest) {
            payRequest = (PayRequest)request;
            extData = payRequest.getExtData();
            bodyExtData = payRequest.getBody().getExtData();
            payDetailList.addAll(payRequest.getBody().getDetails());
        } else if (request instanceof OverseaPayRequest) {
            payRequest = (OverseaPayRequest)request;
            extData = payRequest.getExtData();
            bodyExtData = payRequest.getBody().getExtData();
            payDetailList.addAll(payRequest.getBody().getDetails());
        }
        boolean idempotency = false;
        if (StringUtils.isNotEmpty((String)extData)) {
            jsonObject = JSONObject.parseObject((String)extData);
            if (jsonObject.containsKey((Object)"idempotency")) {
                idempotency = jsonObject.getBoolean("idempotency");
            }
        } else if (StringUtils.isNotEmpty((String)bodyExtData) && (jsonObject = JSONObject.parseObject((String)bodyExtData)).containsKey((Object)"idempotency")) {
            idempotency = jsonObject.getBoolean("idempotency");
        }
        if (idempotency) {
            int groupSize;
            ArrayList<String> detailBizNoList = new ArrayList<String>(16);
            ArrayList<String> checkRepeatBizNoList = new ArrayList<String>(16);
            int total = payDetailList.size();
            int groupNum = total % (groupSize = 200) == 0 ? total / groupSize : total / groupSize + 1;
            for (int i = 0; i < groupNum; ++i) {
                int start = i * groupSize;
                int end = (i + 1) * groupSize;
                if (end > total) {
                    end = total;
                }
                detailBizNoList.clear();
                for (int j = start; j < end; ++j) {
                    detailBizNoList.add(((PayDetail)payDetailList.get(j)).getDetailBizNo());
                }
                QFilter filter = QFilter.of((String)"back_bank_status='1'", (Object[])new Object[0]);
                filter.and(new QFilter("detail_biz_no", "in", detailBizNoList));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"aqap_bd_paymentinfo", (String)"detail_biz_no", (QFilter[])filter.toArray());
                if (!CollectionUtil.isNotEmpty((Collection)collection)) continue;
                for (DynamicObject dynamicObject : collection) {
                    checkRepeatBizNoList.add(dynamicObject.getString("detail_biz_no"));
                }
            }
            if (CollectionUtil.isNotEmpty(checkRepeatBizNoList)) {
                StringBuilder sb = new StringBuilder();
                for (int k = 0; k < checkRepeatBizNoList.size(); ++k) {
                    sb.append((String)checkRepeatBizNoList.get(k));
                    if (k >= checkRepeatBizNoList.size() - 1) continue;
                    sb.append(',');
                }
                String detailBizNo = sb.toString();
                throw EBExceiptionUtil.duplicateException((String)String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u8bf7\u6c42\u7591\u4f3c\u91cd\u590d\u88ab\u62e6\u622a\uff0c\u5df2\u5b58\u5728\u4ed8\u6b3e\u5b8c\u6210\u6216\u5728\u9014\u7684\u4e1a\u52a1\u53f7[%s]\u3002", (String)"PayMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]), detailBizNo));
            }
        } else {
            return;
        }
    }

    public static void async(Set<List<PaymentInfo>> set, EBRequest payRequest) {
        String name = "eb_pay_" + payRequest.getHeader().getCustomId() + "_" + payRequest.getHeader().getLogRequestSeqID();
        ThreadPools.executeOnceIncludeRequestContext((String)name, (Runnable)new SubmitPayRunnale(set, payRequest), (String)"aqap");
    }

    public static BankPayRequest prepareBankPayRequest(List<PaymentInfo> paymentInfos) {
        return PaymentUtil.prepareBankPayRequest(paymentInfos, null, null);
    }

    public static BankPayRequest prepareBankPayRequest(List<PaymentInfo> paymentInfos, BankAcnt bankAcnt, String bankCurrency) {
        BankPayRequest bankPayRequest = new BankPayRequest();
        if (paymentInfos.size() > 0) {
            PaymentInfo info = paymentInfos.get(0);
            bankPayRequest.setPaymentInfos(paymentInfos);
            bankPayRequest.setTotalCount(paymentInfos.size());
            bankPayRequest.setTotalAmount(PaymentAmountUtils.getTotalAmount(paymentInfos));
            bankPayRequest.setBankBatchSeqID(info.getBankBatchSeqID());
            bankPayRequest.setHeader(PaymentUtil.getHeader(info, bankAcnt, bankCurrency));
        }
        return bankPayRequest;
    }

    private static BankHeader getHeader(PaymentInfo info, BankAcnt bankAcnt, String bankCurrency) {
        BankHeader header = new BankHeader();
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        header.setCustomerID(info.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqID());
        header.setLogBizSeqID(info.getBatchSeqID());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(bankAcnt);
        header.setClientName("ebc_bankPayTask");
        header.setClientVersion("1.0");
        return header;
    }

    private static void bigMoneyPaymentNotice(PaymentInfo info) {
    }

    public static String substringChinese(boolean isNeedSubString, String srcStr, int maxByteLength, String charset) {
        if (StrUtil.isEmpty((String)srcStr)) {
            return "";
        }
        if (!isNeedSubString) {
            return srcStr;
        }
        int length = 0;
        if ("GBK".equalsIgnoreCase(charset) || "GB2312".equalsIgnoreCase(charset) || "GB18030".equalsIgnoreCase(charset)) {
            length = 2;
        } else if ("UTF-8".equalsIgnoreCase(charset) || "UTF8".equalsIgnoreCase(charset)) {
            length = 3;
        }
        if (srcStr.length() * length <= maxByteLength) {
            return srcStr;
        }
        char[] srcChrs = srcStr.toCharArray();
        int totalLength = 0;
        StringBuilder retStr = new StringBuilder();
        for (char chr : srcChrs) {
            try {
                totalLength += String.valueOf(chr).getBytes(charset).length;
            }
            catch (UnsupportedEncodingException e) {
                totalLength += chr > '\u00ff' ? 2 : 1;
            }
            if (totalLength > maxByteLength) break;
            retStr.append(chr);
        }
        return retStr.toString();
    }

    public static void setKdFlagID(PaymentInfo info, String kdFlagID) {
        info.setKdFlagID(kdFlagID);
    }

    public static void setKdFlagID(List<PaymentInfo> infos, String kdFlagID) {
        for (PaymentInfo info : infos) {
            info.setKdFlagID(kdFlagID);
        }
    }

    public static void setKdFlagID(PaymentInfo[] infos, String kdFlagID) {
        for (PaymentInfo info : infos) {
            info.setKdFlagID(kdFlagID);
        }
    }

    @SdkDeprecated
    public static void setKdFlagIDByBankDetailSeqID(PaymentInfo info) {
        info.setKdFlagID(info.getBankDetailSeqID());
    }

    @SdkDeprecated
    public static void setKdFlagIDByBankDetailSeqID(List<PaymentInfo> infos) {
        for (PaymentInfo info : infos) {
            info.setKdFlagID(info.getBankDetailSeqID());
        }
    }

    @SdkDeprecated
    public static void setKdFlagIDByBankDetailSeqID(PaymentInfo[] infos) {
        for (PaymentInfo info : infos) {
            info.setKdFlagID(info.getBankDetailSeqID());
        }
    }

    public static void setKdFlagIDByBankBatchSeqID(PaymentInfo info) {
        info.setKdFlagID(info.getBankBatchSeqID());
    }

    public static void setKdFlagIDByBankBatchSeqID(List<PaymentInfo> infos) {
        for (PaymentInfo info : infos) {
            info.setKdFlagID(info.getBankBatchSeqID());
        }
    }

    public static void setKdFlagIDByBankBatchSeqID(PaymentInfo[] infos) {
        for (PaymentInfo info : infos) {
            info.setKdFlagID(info.getBankBatchSeqID());
        }
    }

    public static void setBookPayFlag(PaymentInfo info) {
        if (info.getBookingTime() != null && info.getBookingTime().isAfter(LocalDateTime.now())) {
            info.setBookPayFlag(true);
        }
    }

    public static void setBookPayFlag(List<PaymentInfo> paymentInfos) {
        PaymentInfo info = paymentInfos.get(0);
        if (info.getBookingTime() != null && info.getBookingTime().isAfter(LocalDateTime.now())) {
            for (PaymentInfo paymentInfo : paymentInfos) {
                paymentInfo.setBookPayFlag(true);
            }
        }
    }

    public static void setBookPayFlag(PaymentInfo[] paymentInfos) {
        PaymentInfo info = paymentInfos[0];
        if (info.getBookingTime() != null && info.getBookingTime().isAfter(LocalDateTime.now())) {
            for (PaymentInfo paymentInfo : paymentInfos) {
                paymentInfo.setBookPayFlag(true);
            }
        }
    }

    public static List<String> checkRepeatRelativeIDs(List<PaymentInfo> paymentInfos) {
        QFilter filter;
        DynamicObjectCollection collection;
        ArrayList<String> repeatRelativeIDs = new ArrayList<String>(16);
        ArrayList<String> paymentRelativeIds = new ArrayList<String>(16);
        for (PaymentInfo paymentInfo : paymentInfos) {
            if (!StringUtils.isNotEmpty((String)paymentInfo.getRelativeId())) continue;
            paymentRelativeIds.add(paymentInfo.getRelativeId());
        }
        if (!paymentRelativeIds.isEmpty() && CollectionUtil.isNotEmpty((Collection)(collection = QueryServiceHelper.query((String)"aqap_bd_paymentinfo", (String)"relative_id", (QFilter[])(filter = new QFilter("relative_id", "in", paymentRelativeIds)).toArray())))) {
            for (DynamicObject dynamicObject : collection) {
                repeatRelativeIDs.add(dynamicObject.getString("relative_id"));
            }
        }
        return repeatRelativeIDs;
    }

    public static Map getConfigBatchSizeByBank(String bankVersion) {
        HashMap<String, Integer> bankBatchSizeMap = new HashMap<String, Integer>(12);
        try {
            DynamicObject[] dynamicObjects;
            QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{bankVersion});
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"t_aqap_pay_limit", (String)"limit,interface_id.class_name", (QFilter[])filter.toArray())) {
                if (dynamicObject == null) continue;
                int id = dynamicObject.getInt("limit");
                String class_name = dynamicObject.getString("interface_id.class_name");
                bankBatchSizeMap.put(class_name, id);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6279\u91cf\u4ed8\u6b3e\u6700\u5927\u7b14\u6570\u914d\u7f6e\u51fa\u9519====" + e.getMessage());
        }
        return bankBatchSizeMap;
    }

    public static void checkIsForeignCurrency(String currency) {
        Preconditions.checkState((boolean)"CNY".equals(currency), (Object)ResManager.loadKDString((String)"\u5f53\u524d\u4ed8\u6b3e\u5355\u636e\u9700\u8981\u4f7f\u7528\u8de8\u5883\u652f\u4ed8\u4e1a\u52a1\uff0c\u8bf7\u5728\u5355\u636e\u4e0a\u5f00\u542f\u201c\u5883\u5916/\u8de8\u5883\u652f\u4ed8\u201d\u53c2\u6570\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"PayMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
    }
}

