/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.util;

import com.google.common.io.Resources;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BalanceCurrencyModelUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceCurrencyModelUtil.class);
    private static final BalanceCurrencyModelUtil instance = new BalanceCurrencyModelUtil();
    private volatile Set<String> oneCurrencyClassSet = new HashSet<String>(16);
    private volatile Set<String> cnyCurrencyClassSet = new HashSet<String>(16);
    private static final String FILE_NAME = "balance_currency_model.properties";
    private static final String KEY_ONE = "balance.currency.model.one";
    private static final String KEY_CNY = "balance.currency.model.cny";

    public BalanceCurrencyModelUtil() {
        try {
            Properties props = new Properties();
            URL url = Resources.getResource((String)FILE_NAME);
            try (InputStream in = url.openStream();){
                props.load(new InputStreamReader(in, "utf-8"));
                String oneClassNames = props.getProperty(KEY_ONE);
                logger.monitorInfo(ResManager.loadKDString((String)"\u83b7\u53d6\u4f59\u989d\u5355\u5e01\u79cd\u6a21\u5f0f\u63a5\u53e3\u5b9e\u73b0\u7c7b\u96c6\u5408\u5f00\u59cb\u3002", (String)"BalanceCurrencyModelUtil_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
                if (StringUtils.isNotEmpty((String)oneClassNames)) {
                    this.oneCurrencyClassSet = StrUtil.commaDelimitedListToSet((String)oneClassNames);
                }
                logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4f59\u989d\u5355\u5e01\u79cd\u6a21\u5f0f\u63a5\u53e3\u5b9e\u73b0\u7c7b\u96c6\u5408\u5b8c\u6210\uff0c\u6570\u91cf\u4e3a%s\u3002", (String)"BalanceCurrencyModelUtil_2", (String)"ebg-aqap-business", (Object[])new Object[0]), this.oneCurrencyClassSet.size()));
                String cnyClassNames = props.getProperty(KEY_CNY);
                logger.monitorInfo(ResManager.loadKDString((String)"\u83b7\u53d6\u4f59\u989d\u4eba\u6c11\u5e01\u6a21\u5f0f\u63a5\u53e3\u5b9e\u73b0\u7c7b\u96c6\u5408\u5f00\u59cb\u3002", (String)"BalanceCurrencyModelUtil_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
                if (StringUtils.isNotEmpty((String)cnyClassNames)) {
                    this.cnyCurrencyClassSet = StrUtil.commaDelimitedListToSet((String)cnyClassNames);
                }
                logger.monitorInfo(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4f59\u989d\u4eba\u6c11\u5e01\u6a21\u5f0f\u63a5\u53e3\u5b9e\u73b0\u7c7b\u96c6\u5408\u5b8c\u6210\uff0c\u6570\u91cf\u4e3a%s\u3002", (String)"BalanceCurrencyModelUtil_4", (String)"ebg-aqap-business", (Object[])new Object[0]), this.cnyCurrencyClassSet.size()));
            }
        }
        catch (Exception var15) {
            logger.error("load balance_currency_model.properties exception", (Throwable)var15);
        }
    }

    public static BalanceCurrencyModelUtil getInstance() {
        return instance;
    }

    private Set<String> getOneCurrencyClassSet() {
        return this.oneCurrencyClassSet;
    }

    private Set<String> getCNYCurrencyClassSet() {
        return this.cnyCurrencyClassSet;
    }

    public static boolean isOneCurrencyModel(String className) {
        return BalanceCurrencyModelUtil.getInstance().getOneCurrencyClassSet().contains(className);
    }

    public static boolean isCNYCurrencyModel(String className) {
        return BalanceCurrencyModelUtil.getInstance().getCNYCurrencyClassSet().contains(className);
    }
}

