/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;

public class CommonPayStatusMatchUtil {
    public static List<PaymentInfo> HandlePayStatus(MatchPayStatusModel matchPayStatusModel, List<PaymentInfo> paymentInfoAll) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(CommonPayStatusMatchUtil.class);
        boolean isBothContain = "ACCOUNT_NAME_AMOUNT_EXP".equals(matchPayStatusModel.getMatchRule());
        boolean isContainSeq = "ACCOUNT_NAME_AMOUNT_SEQ".equals(matchPayStatusModel.getMatchRule()) || isBothContain;
        boolean isContainExp = "ACCOUNT_NAME_AMOUNT_EXP".equals(matchPayStatusModel.getMatchRule()) || isBothContain;
        boolean isContainIncomeName = !"ACCOUNT_AMOUNT".equals(matchPayStatusModel.getMatchRule());
        PayStatusMatchUtil.preBatchSameItemCheck(paymentInfoAll, isContainIncomeName, isContainSeq, isContainExp);
        HashMap<String, PaymentInfo> paymentInfoMap = new HashMap<String, PaymentInfo>(16);
        for (PaymentInfo paymentInfo : paymentInfoAll) {
            String keyByPaymentInfo = CommonPayStatusMatchUtil.getKeyByPaymentInfo(paymentInfo, matchPayStatusModel.getMatchRule());
            paymentInfoMap.put(keyByPaymentInfo, paymentInfo);
        }
        List<BankResPaymentInfo> BankResPaymentInfos = matchPayStatusModel.getBankResPaymentInfoList();
        ArrayList<BankResPaymentInfo> unMatchedPaymentInfoList = new ArrayList<BankResPaymentInfo>(16);
        for (BankResPaymentInfo bankResPaymentInfo : BankResPaymentInfos) {
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfoMap.get(bankResPaymentInfo.getBankMatchKey());
            if (paymentInfo == null) {
                unMatchedPaymentInfoList.add(bankResPaymentInfo);
                continue;
            }
            EBGBusinessUtils.setPaymentState(paymentInfo, bankResPaymentInfo.getPaymentState(), bankResPaymentInfo.getPaymentState().getCnName(), bankResPaymentInfo.getBankStatus(), bankResPaymentInfo.getBankMsg());
        }
        if (unMatchedPaymentInfoList.size() > 0) {
            logger.info("\u5b58\u5728\u65e0\u6cd5\u5339\u914d\u7684\u94f6\u884c\u8fd4\u56de\u4fe1\u606f===" + ((Object)unMatchedPaymentInfoList).toString());
        }
        CommonPayStatusMatchUtil.processingBankItemDataHandler(matchPayStatusModel);
        PayStatusMatchUtil.backBatchSameItemHandler(paymentInfoAll, isContainIncomeName, isContainSeq, isContainExp);
        return paymentInfoAll;
    }

    private static void processingBankItemDataHandler(MatchPayStatusModel matchPayStatusModel) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                List<BankResPaymentInfo> bankResPaymentInfoList = matchPayStatusModel.getBankResPaymentInfoList();
                for (BankResPaymentInfo bankResPaymentInfo : bankResPaymentInfoList) {
                    if (!HashSetKeys.contains(bankResPaymentInfo.getBankMatchKey())) continue;
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    EBGBusinessUtils.setPaymentState(tempInfo, bankResPaymentInfo.getPaymentState(), bankResPaymentInfo.getPaymentState().getCnName(), bankResPaymentInfo.getBankStatus(), bankResPaymentInfo.getBankMsg());
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankResPaymentInfo.getBankMatchKey());
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankResPaymentInfo.getBankMatchKey(), tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    public static String getKeyByPaymentInfo(PaymentInfo info, String matchRule) {
        StringBuilder buffer = new StringBuilder();
        if ("ACCOUNT_AMOUNT".equals(matchRule)) {
            buffer.append(info.getIncomeAccNo()).append(info.getAmount());
        } else if ("ACCOUNT_NAME_AMOUNT_SEQ".equals(matchRule)) {
            buffer.append(info.getBankSerialNo()).append(info.getIncomeAccNo()).append(info.getIncomeAccName()).append(info.getAmount());
        } else if ("ACCOUNT_NAME_AMOUNT_EXP".equals(matchRule)) {
            buffer.append(info.getIncomeAccNo()).append(info.getIncomeAccName()).append(info.getAmount()).append(info.getExplanation());
        } else if ("ACCOUNT_NAME_AMOUNT_EXP".equals(matchRule)) {
            buffer.append(info.getBankSerialNo()).append(info.getIncomeAccNo()).append(info.getIncomeAccName()).append(info.getAmount()).append(info.getExplanation());
        } else {
            buffer.append(info.getIncomeAccNo()).append(info.getIncomeAccName()).append(info.getAmount());
        }
        return buffer.toString();
    }

    public static List<PaymentInfo> getAllPaymentInfoByBankBatchNo(String bankBatchSeqID) {
        return PaymentInfoService.getInstance().selectByBankBatchSeqID(bankBatchSeqID);
    }

    public static int getAllPaymentInfoSize(String bankBatchSeqID) {
        if (EBContext.getContext().isUnitTest()) {
            return 100;
        }
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(bankBatchSeqID);
        return paymentInfos.size();
    }

    public static void checkPayStatusWith3Factor(PaymentInfo info, String incomeAcc, String incomeAccName, String amount, boolean isUse) {
        if (!isUse) {
            return;
        }
        CommonPayStatusMatchUtil.checkPayStatusWith3Factor(info, incomeAcc, incomeAccName, amount);
    }

    public static void checkPayStatusWith3Factor(PaymentInfo info, String incomeAcc, String incomeAccName, String amount) {
        BigDecimal bankAmount;
        EBGLogger logger = EBGLogger.getInstance().getLogger(CommonPayStatusMatchUtil.class);
        if (StringUtils.isNotEmpty((String)incomeAcc) && !incomeAcc.equals(info.getIncomeAccNo())) {
            logger.info("\u5f53\u524d\u94f6\u884c\u6536\u6b3e\u8d26\u6237{}\u548c\u94f6\u884c\u8fd4\u56de\u6536\u6b3e\u8d26\u6237\u53f7{}\u4e0d\u5339\u914d", new Object[]{info.getIncomeAccNo(), incomeAcc});
            EBGBusinessUtils.setPaymentState(info, PaymentState.SUBMITED, PaymentState.SUBMITED.getCnName(), info.getBankStatus(), ResManager.loadKDString((String)"\u7591\u4f3c\u94f6\u884c\u8fd4\u56de\u5e8f\u53f7\u6709\u8bef\uff0c\u94f6\u884c\u8fd4\u56de\u8d26\u6237\u53f7\u4e0d\u5339\u914d", (String)"CommonPayStatusMatchUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)incomeAccName) && !incomeAccName.equals(info.getIncomeAccName())) {
            logger.info("\u5f53\u524d\u94f6\u884c\u6536\u6b3e\u8d26\u6237\u540d{}\u548c\u94f6\u884c\u8fd4\u56de\u6536\u6b3e\u8d26\u6237\u540d{}\u4e0d\u5339\u914d", new Object[]{info.getIncomeAccName(), incomeAccName});
            EBGBusinessUtils.setPaymentState(info, PaymentState.SUBMITED, PaymentState.SUBMITED.getCnName(), info.getBankStatus(), ResManager.loadKDString((String)"\u7591\u4f3c\u94f6\u884c\u8fd4\u56de\u5e8f\u53f7\u6709\u8bef\uff0c\u94f6\u884c\u8fd4\u56de\u8d26\u6237\u540d\u79f0\u4e0d\u5339\u914d", (String)"CommonPayStatusMatchUtil_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)amount) && (bankAmount = new BigDecimal(amount).setScale(2)).compareTo(info.getAmount()) != 0) {
            logger.info("\u5f53\u524d\u94f6\u884c\u4ed8\u6b3e\u91d1\u989d{}\u548c\u94f6\u884c\u8fd4\u56de\u6536\u4ed8\u6b3e\u91d1\u989d{}\u4e0d\u5339\u914d", new Object[]{info.getAmount().toPlainString(), bankAmount.toPlainString()});
            EBGBusinessUtils.setPaymentState(info, PaymentState.SUBMITED, PaymentState.SUBMITED.getCnName(), info.getBankStatus(), ResManager.loadKDString((String)"\u7591\u4f3c\u94f6\u884c\u8fd4\u56de\u5e8f\u53f7\u6709\u8bef\uff0c\u94f6\u884c\u8fd4\u56de\u91d1\u989d\u4e0d\u5339\u914d", (String)"CommonPayStatusMatchUtil_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }
}

