/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.util.pojo;

import java.math.BigDecimal;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;

public class BankResPaymentInfo {
    private String bankMatchKey;
    private PaymentState paymentState;
    private String bankMsg;
    private String bankStatus;

    public BankResPaymentInfo() {
    }

    public BankResPaymentInfo(String incomeAccNo, String incomeAccName, String amount) {
        PaymentInfo tempInfo = new PaymentInfo();
        tempInfo.setIncomeAccNo(incomeAccNo);
        tempInfo.setIncomeAccName(incomeAccName);
        tempInfo.setAmount(new BigDecimal(amount).setScale(2));
        this.bankMatchKey = CommonPayStatusMatchUtil.getKeyByPaymentInfo(tempInfo, "ACCOUNT_NAME_AMOUNT");
    }

    public BankResPaymentInfo(String incomeAccNo, String amount) {
        PaymentInfo tempInfo = new PaymentInfo();
        tempInfo.setIncomeAccNo(incomeAccNo);
        tempInfo.setAmount(new BigDecimal(amount).setScale(2));
        this.bankMatchKey = CommonPayStatusMatchUtil.getKeyByPaymentInfo(tempInfo, "ACCOUNT_AMOUNT");
    }

    public PaymentState getPaymentState() {
        return this.paymentState;
    }

    public void setPaymentState(PaymentState paymentState) {
        this.paymentState = paymentState;
    }

    public String getBankMsg() {
        return this.bankMsg;
    }

    public void setBankMsg(String bankMsg) {
        this.bankMsg = bankMsg;
    }

    public String getBankStatus() {
        return this.bankStatus;
    }

    public void setBankStatus(String bankStatus) {
        this.bankStatus = bankStatus;
    }

    public String getBankMatchKey() {
        return this.bankMatchKey;
    }

    public void setBankMatchKey(String bankMatchKey) {
        this.bankMatchKey = bankMatchKey;
    }

    public String toString() {
        return "BankResPaymentInfo{bankMatchKey='" + this.bankMatchKey + '\'' + ", paymentState=" + this.paymentState + ", bankMsg='" + this.bankMsg + '\'' + ", bankStatus='" + this.bankStatus + '\'' + '}';
    }
}

