/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.common.framework.properties.LinkPayConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public class BankBusinessConfig
extends BankPropertyConfig {
    private static final PropertyConfigItem ccb_dc_isIndividualToCompany = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u5bf9\u79c1\u8f6c\u5bf9\u516c\u63a5\u53e3\u4ed8\u6b3e", "BankBusinessConfig_3", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_isIndividualToCompany").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u666e\u901a\u5bf9\u79c1\u4ed8\u6b3e\u662f\u5426\u4f7f\u7528\u5bf9\u516c\u63a5\u53e3\uff1a", "BankBusinessConfig_4", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("1)\u662f\uff1a\u666e\u901a\u5bf9\u79c1\u4ed8\u6b3e\u65f6\uff0c\u901a\u8fc7\u5bf9\u516c\u63a5\u53e3\uff086W8010\uff09\u5b9e\u73b0\uff1b", "BankBusinessConfig_5", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("2)\u5426\uff1a\u666e\u901a\u5bf9\u79c1\u4ed8\u6b3e\u901a\u8fc7\u5bf9\u79c1\u63a5\u53e3\uff086W1303\uff09\u5b9e\u73b0\uff0c\u3010\u5bf9\u79c1\u6279\u91cf\u4ee3\u53d1\u3011\u53c2\u6570\u4f1a\u8fdb\u4e00\u6b65\u5f71\u54cd\u4ed8\u6b3e\u8def\u7531\uff0c\u9ed8\u8ba4\u65b9\u5f0f\u3002", "BankBusinessConfig_6", "ebg-aqap-banks-ccb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankBusinessConfig_7", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5426", "BankBusinessConfig_8", "ebg-aqap-banks-ccb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"false"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem ccb_dc_isBatchIndividualPay = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u5bf9\u79c1\u6279\u91cf\u4ee3\u53d1", "BankBusinessConfig_9", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_isBatchIndividualPay").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5bf9\u79c1/\u4ee3\u53d1\u4ed8\u6b3e(6W1303)\u662f\u5426\u4f7f\u7528\u6279\u91cf\u4ee3\u53d1(6W1301)\u63a5\u53e3:", "BankBusinessConfig_10", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("1)\u662f\uff1a\u6279\u91cf\u4ee3\u53d1\u63a5\u53e3(6W1301)\uff1b", "BankBusinessConfig_11", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("2)\u5426\uff1a\u975e\u6279\u91cf\u4ee3\u53d1\u63a5\u53e3(6W1303)\uff0c\u9ed8\u8ba4\u65b9\u5f0f\u3002", "BankBusinessConfig_12", "ebg-aqap-banks-ccb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankBusinessConfig_7", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5426", "BankBusinessConfig_8", "ebg-aqap-banks-ccb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"false"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem ccb_dc_needPaymentConfirm = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u662f\u5426\u9700\u8981\u7f51\u94f6\u4e8c\u6b21\u5ba1\u6838", "BankBusinessConfig_13", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_needPaymentConfirm").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u662f\u5426\u9700\u8981\u7f51\u94f6\u4e8c\u6b21\u5ba1\u6838:", "BankBusinessConfig_14", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("1)\u662f\uff1a\u4ed8\u6b3e\u8bf7\u6c42\u63d0\u4ea4\u94f6\u884c\u540e\uff0c\u5982\u679c\u94f6\u884c\u8fd4\u56de\u5904\u7406\u6210\u529f\uff0c\u5219\u8ba4\u4e3a\u63d0\u4ea4\u6210\u529f\uff0c\u4e4b\u540e\u9700\u8981\u8fdb\u884c\u4ed8\u6b3e\u72b6\u6001\u67e5\u8be2\uff1b", "BankBusinessConfig_15", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("2)\u5426\uff1a\u4ed8\u6b3e\u8bf7\u6c42\u63d0\u4ea4\u94f6\u884c\u540e\uff0c\u5982\u679c\u94f6\u884c\u8fd4\u56de\u5904\u7406\u6210\u529f\uff0c\u5219\u8ba4\u4e3a\u4ea4\u6613\u6210\u529f\uff0c\u9ed8\u8ba4\u65b9\u5f0f\u3002", "BankBusinessConfig_16", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u4ed8\u6b3e\u63a5\u53e3\u53ca\u5b57\u6bb5\u6709:6W1303(FLOW_FLAG\u7f51\u94f6\u5ba1\u6279\u6807\u8bc6)\u3002", "BankBusinessConfig_161", "ebg-aqap-banks-ccb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankBusinessConfig_7", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5426", "BankBusinessConfig_8", "ebg-aqap-banks-ccb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"false"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem ccb_dc_needAcntValidate = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u540c\u884c\u4ed8\u6b3e\u662f\u5426\u6821\u9a8c\u8d26\u53f7\u6237\u540d\u3002", "BankBusinessConfig_17", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_needAcntValidate").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u540c\u884c\u4ed8\u6b3e\u662f\u5426\u9700\u8981\u8d26\u53f7\u6237\u540d\u5339\u914d\u6821\u9a8c:", "BankBusinessConfig_18", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("1)\u662f\uff1a\u63d0\u4ea4\u540c\u884c\u4ed8\u6b3e\u8bf7\u6c42\u524d\uff0c\u8c03\u75286W1101\u63a5\u53e3\u6821\u9a8c\u8d26\u53f7\u3001\u6237\u540d\u662f\u5426\u5339\u914d\uff1b", "BankBusinessConfig_19", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("2)\u5426\uff1a\u4e0d\u6821\u9a8c\u8d26\u53f7\u3001\u6237\u540d\u662f\u5426\u5339\u914d\uff0c\u9ed8\u8ba4\u65b9\u5f0f\u3002", "BankBusinessConfig_20", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u5f00\u542f\u540e\uff0c\u4f1a\u57286W1303\u30016W8010\u63a5\u53e3\u4ed8\u6b3e\u524d\u6821\u9a8c\u8d26\u53f7\u6237\u540d\u662f\u5426\u5339\u914d\u3002", "BankBusinessConfig_201", "ebg-aqap-banks-ccb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankBusinessConfig_7", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5426", "BankBusinessConfig_8", "ebg-aqap-banks-ccb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"false"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem ccb_dc_isAddKDFlagToPay = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u652f\u4ed8\u662f\u5426\u9700\u8981KD\u6807\u8bb0", "BankBusinessConfig_21", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_isAddKDFlagToPay").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u652f\u4ed8\u662f\u5426\u9700\u8981KD\u6807\u8bb0\uff0c\u7528\u4e8e\u4ed8\u6b3e\u5355\u4e0e\u4ea4\u6613\u660e\u7ec6\u8fdb\u884c\u5339\u914d\u3002", "BankBusinessConfig_22", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("1)\u662f\uff1a\u6458\u8981\u52a0\u5165KD\u6807\u8bb0\uff1b", "BankBusinessConfig_221", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("2)\u5426\uff1a\u6458\u8981\u4e0d\u52a0\u5165KD\u6807\u8bb0\uff0c\u9ed8\u8ba4\u65b9\u5f0f\u3002", "BankBusinessConfig_222", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u4ed8\u6b3e\u63a5\u53e3\uff1a6W2100\u30016W8020\u30016W1303\u30016W8010\u3002", "BankBusinessConfig_23", "ebg-aqap-banks-ccb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankBusinessConfig_7", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5426", "BankBusinessConfig_8", "ebg-aqap-banks-ccb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"addKDFlag", "normal"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"normal"})).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem ccb_dc_InnerSalaryBillCode = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u540c\u884c\u4ee3\u53d1\u7f16\u53f7", "BankBusinessConfig_29", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_InnerSalaryBillCode").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u540c\u884c\u4ee3\u53d1\u7f16\u53f7\uff08BILL_CODE\uff09\uff1a\u4ee3\u53d1/\u5bf9\u79c1\u4ed8\u6b3e\u4e1a\u52a1\u4f7f\u7528\u3002", "BankBusinessConfig_30", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u4ed8\u6b3e\u63a5\u53e3\u53ca\u5b57\u6bb5\u6709\uff1a6W1303\uff08\u5355\u7b14\u4ee3\u53d1\u4ee3\u6263\u4ea4\u6613\uff09\u63a5\u53e3BILL_CODE\uff08\u4ee3\u53d1\u4ee3\u6263\u7f16\u53f7\uff09\u3002", "BankBusinessConfig_301", "ebg-aqap-banks-ccb-dc")})).isAccNo(true).defaultValues(null).build();
    private static final PropertyConfigItem ccb_dc_OutterSalaryBillCode = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u8de8\u884c\u4ee3\u53d1\u7f16\u53f7", "BankBusinessConfig_31", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_OutterSalaryBillCode").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u53d1\u7f16\u53f7\uff08BILL_CODE\uff09\uff1a\u4ee3\u53d1/\u5bf9\u79c1\u4ed8\u6b3e\u4e1a\u52a1\u4f7f\u7528\uff0c\u6b64\u914d\u7f6e\u4f7f\u7528\u4ed8\u6b3e\u63a5\u53e3\u53ca\u5b57\u6bb5\u6709\uff1a6W2100\uff08\u5168\u56fd\u6279\u91cf\u4ee3\u53d1\u4ee3\u6263\u4ea4\u6613\uff09\u63a5\u53e3BILL_CODE(\u4ee3\u53d1\u4ee3\u6263\u7f16\u53f7)\u3002", "BankBusinessConfig_32", "ebg-aqap-banks-ccb-dc")})).isAccNo(true).defaultValues(null).build();
    private static final PropertyConfigItem ccb_dc_SalaryUseofCode = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u4ee3\u53d1\u7528\u9014\u7f16\u53f7", "BankBusinessConfig_33", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_SalaryUseofCode").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u53d1\u7528\u9014\u7f16\u53f7\uff0c\u4ee3\u53d1/\u5bf9\u79c1\u4e1a\u52a1\u4f7f\u7528\u3002\u6b64\u914d\u7f6e\u4f7f\u7528\u4ed8\u6b3e\u63a5\u53e3\u53ca\u5b57\u6bb5\u6709\uff1a6W1303\uff08\u5355\u7b14\u4ee3\u53d1\u4ee3\u6263\u4ea4\u6613\uff09\u63a5\u53e3USEOF_CODE(\u4ee3\u6263\u7528\u9014\u7f16\u53f7)\u3002", "BankBusinessConfig_34", "ebg-aqap-banks-ccb-dc")})).isAccNo(true).defaultValues((List)Lists.newArrayList((Object[])new String[]{"99999998"})).build();
    private static final PropertyConfigItem ccb_dc_BatchPayFileType = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u5efa\u884c\u6279\u91cf\u4ee3\u53d1\u6587\u4ef6\u683c\u5f0f", "BankBusinessConfig_35", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_BatchPayFileType").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5efa\u884c\u6279\u91cf\u4ee3\u53d1\u6587\u4ef6\u683c\u5f0f)\u6309\u7701\u4efd\u5730\u533a\u5212\u5206", "BankBusinessConfig_36", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u4e0a\u6d77\uff08\u9996\u884c\u7a7a\uff09\uff1a\u9996\u884c\u7a7a\uff0c\u5b57\u6bb5\u683c\u5f0f\u4e3a\u91d1\u989d(\u6570\u503c\u683c\u5f0f\uff0c\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570)|\u4ed8\u6b3e\u65b9\u8d26\u53f7|\u6536\u6b3e\u65b9\u8d26\u53f7|\u6536\u6b3e\u65b9\u540d\u79f0|\u6536\u6b3e\u65b9\u5f00\u6237\u884c\u540d\u79f0|\u6458\u8981", "BankBusinessConfig_88", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u56db\u5ddd\uff08\u9996\u884c\u4e0d\u7a7a\uff09\uff1a\u9996\u884c\u4e0d\u7a7a\uff0c\u5b57\u6bb5\u683c\u5f0f\u4e3a\u5e8f\u53f7|\u8d26\u53f7|\u6237\u540d|\u91d1\u989d|\u6458\u8981|\u5907\u6ce8", "BankBusinessConfig_89", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5e7f\u4e1c\uff08\u9996\u884c\u7a7a\uff09\uff1a\u9996\u884c\u7a7a\uff0c\u5b57\u6bb5\u683c\u5f0f\u4e3a\u5e8f\u53f7\uff08\u5fc5\u586b\uff09|\u8d26\u53f7\uff08\u5fc5\u586b\uff09|\u6237\u540d\uff08\u5fc5\u586b\uff09|\u91d1\u989d\uff08\u5fc5\u586b\uff09|\u8de8\u884c\u6807\u8bc6\uff08\u5efa\u884c\u586b0, \u4ed6\u884c\u586b1\uff09|\u884c\u540d|\u8054\u884c\u53f7\uff08\u8de8\u884c\u4e0d\u4e3a\u7a7a\uff09|\u6458\u8981|\u5907\u6ce8", "BankBusinessConfig_90", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5e7f\u4e1c\uff08\u9996\u884c\u4e0d\u7a7a\uff09\uff1a\u9996\u884c\u4e0d\u7a7a\uff0c\u5b57\u6bb5\u683c\u5f0f\u4e3a\u5e8f\u53f7\uff08\u5fc5\u586b\uff09|\u8d26\u53f7\uff08\u5fc5\u586b\uff09|\u6237\u540d\uff08\u5fc5\u586b\uff09|\u91d1\u989d\uff08\u5fc5\u586b\uff09|\u8de8\u884c\u6807\u8bc6\uff08\u5efa\u884c\u586b0, \u4ed6\u884c\u586b1\uff09|\u884c\u540d|\u8054\u884c\u53f7\uff08\u8de8\u884c\u4e0d\u4e3a\u7a7a\uff09|\u6458\u8981|\u5907\u6ce8", "BankBusinessConfig_91", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u65e7\u7248\uff08\u9996\u884c\u4e0d\u7a7a\uff09\uff1a\u9996\u884c\u4e0d\u7a7a\uff0c\u5b57\u6bb5\u683c\u5f0f\u4e3a\u4ed8\u6b3e\u8d26\u53f7\uff08\u5fc5\u586b\uff09,\u91d1\u989d\uff08\u5fc5\u586b\uff09,\u6536\u6b3e\u8d26\u53f7\uff08\u5fc5\u586b\uff09\uff0c\u6536\u6b3e\u6237\u540d\uff08\u5fc5\u586b\uff09\uff0c\u884c\u522b\uff08\u6df1\u5733\u5efa\u884c\uff09,\u6458\u8981\uff08\u5fc5\u586b\uff09", "BankBusinessConfig_92", "ebg-aqap-banks-ccb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4e0a\u6d77\uff08\u9996\u884c\u7a7a\uff09", "BankBusinessConfig_37", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u56db\u5ddd\uff08\u9996\u884c\u4e0d\u7a7a\uff09", "BankBusinessConfig_38", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5e7f\u4e1c\uff08\u9996\u884c\u7a7a\uff09", "BankBusinessConfig_39", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5e7f\u4e1c\uff08\u9996\u884c\u4e0d\u7a7a\uff09", "BankBusinessConfig_86", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u65e7\u7248", "BankBusinessConfig_40", "ebg-aqap-banks-ccb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"shanghai", "sichuan", "guangdong", "guangdong_new", "old"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"guangdong"})).isAccNo(true).build();
    private static final PropertyConfigItem ccb_dc_TemplateType = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u5efa\u884c\u6279\u91cf\u4ee3\u53d1\u6587\u4ef6\u6a21\u677f\u662f\u5426\u4f7f\u7528\u65e7\u7248\u3002", "BankBusinessConfig_41", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_TemplateType").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5efa\u884c\u6279\u91cf\u4ee3\u53d1\u6587\u4ef6\u6a21\u677f\u662f\u5426\u9700\u8981\u4f7f\u7528\u65e7\u7248\uff0c\u5efa\u884c\u8001\u5ba2\u6237\u65e0\u6cd5\u5347\u7ea7\u5230\u65b0\u6a21\u677f\uff0c\u9700\u8981\u914d\u7f6e\u4e3a\u2018\u662f\u2019\u3002", "BankBusinessConfig_42", "ebg-aqap-banks-ccb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankBusinessConfig_7", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5426", "BankBusinessConfig_8", "ebg-aqap-banks-ccb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"false"})).mustInput(Boolean.TRUE.booleanValue()).type(BankPropertyConfigType.PAY_BIZ_PARAM.getName()).build();
    private static final PropertyConfigItem ccb_dc_isShowLinkDetail = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u662f\u5426\u5c55\u793a\u96c6\u56e2\u8054\u52a8\u4ea4\u6613", "BankBusinessConfig_43", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_isShowLinkDetail").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5efa\u884c\u8d22\u8d44\u7c7b\u8d26\u6237\u660e\u7ec6\u662f\u5426\u5c55\u793a\u96c6\u56e2\u8054\u52a8\u4ea4\u6613:", "BankBusinessConfig_44", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("1)\u662f\uff1a", "BankBusinessConfig_45", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("2)\u5426\uff1a\u9ed8\u8ba4\u91c7\u7528", "BankBusinessConfig_46", "ebg-aqap-banks-ccb-dc")})).mlSourceNames(mlFalseTrueCN).sourceValues(falseTrueEN).defaultValues(defaultFalse).mustInput(Boolean.TRUE.booleanValue()).build();
    private static final PropertyConfigItem ccb_dc_MainAccount = PropertyConfigItem.builder().mlName(new MultiLangEnumBridge("\u8d22\u8d44\u8d26\u53f7", "BankBusinessConfig_47", "ebg-aqap-banks-ccb-dc")).key("ccb_dc_MainAccount").mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u8d22\u8d44\u8d26\u53f7\uff1a\u8d22\u8d44\u7c7b\u8d26\u53f7\u67e5\u8be2\u65f6\u9700\u8981\u4f7f\u7528\u8d22\u8d44\u8d26\u53f7\u3002", "BankBusinessConfig_471", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u63a5\u53e3\u53ca\u5b57\u6bb5\u6709\uff1a6WY108\uff08\u8d22\u8d44\u8d26\u6237\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\uff09\u63a5\u53e3CZ_ACC_NO(\u8d22\u8d44\u8d26\u53f7)\uff0c\uff086WCZ02\uff09\u8d26\u6237\u4f59\u989d\u67e5\u8be2\uff08ACC_NO\uff08\u4e3b\u8d26\u53f7\uff09\uff09\u3002", "BankBusinessConfig_472", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5907\u6ce8\uff1a\u8d26\u6237\u4e3a\u8d22\u8d44\u7c7b\u65f6\uff0c\u6b64\u5185\u5bb9\u5fc5\u586b\u3002\u8d26\u6237\u4e3a\u5176\u4ed6\u7c7b\u578b\u65f6\u65e0\u9700\u914d\u7f6e\u8be5\u53c2\u6570\uff0c\u5982\u4e0d\u586b\u5199\u8be5\u4fe1\u606f\uff0c\u4f1a\u4f7f\u7528\u8d26\u53f7\u4fe1\u606f\u4f5c\u4e3a\u8d22\u8d44\u8d26\u53f7\u3002", "BankBusinessConfig_473", "ebg-aqap-banks-ccb-dc")})).isAccNo(true).defaultValues(null).build();
    private static final PropertyConfigItem ccb_dc_SALARY_SELECT = PropertyConfigItem.builder().key("SALARY_SELECT").mlName(new MultiLangEnumBridge("\u5173\u8054\u63a5\u53e3", "BankBusinessConfig_48", "ebg-aqap-banks-ccb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5df2\u5bf9\u63a5\u7684\u4ee3\u53d1\u4e1a\u52a1\u63a5\u53e3:", "BankBusinessConfig_49", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("1)\u5355\u7b14\u4ee3\u53d1\u4ee3\u6263\u4ea4\u6613(6W1303\u4ea4\u6613);", "BankBusinessConfig_66", "ebg-aqap-banks-ccb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5355\u7b14\u4ee3\u53d1\u4ee3\u6263\u4ea4\u6613(6W1303\u4ea4\u6613)", "BankBusinessConfig_51", "ebg-aqap-banks-ccb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5355\u7b14\u4ee3\u53d1\u4ee3\u6263\u4ea4\u6613(6W1303\u4ea4\u6613)", (String)"BankBusinessConfig_51", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0])})).defaultValues((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5355\u7b14\u4ee3\u53d1\u4ee3\u6263\u4ea4\u6613(6W1303\u4ea4\u6613)", (String)"BankBusinessConfig_51", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0])})).mustInput(true).type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName()).build();
    private static final PropertyConfigItem ccb_dc_SALARY_SAME_BANK = PropertyConfigItem.builder().key("SALARY_SAME_BANK").mlName(new MultiLangEnumBridge("\u662f\u5426\u652f\u6301\u540c\u884c\u4ee3\u53d1\u5de5\u8d44", "BankBusinessConfig_52", "ebg-aqap-banks-ccb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f\u5426\u652f\u6301\u540c\u884c\u4ee3\u53d1\u5de5\u8d44:", "BankBusinessConfig_53", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("1)\u662f;", "BankBusinessConfig_67", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("2)\u5426;", "BankBusinessConfig_68", "ebg-aqap-banks-ccb-dc")})).mlSourceNames(mlTrueFalseCN).sourceValues(trueFalseEN).defaultValues(defaultTrue).readonly(true).isHide(true).type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName()).build();
    private static final PropertyConfigItem ccb_dc_SALARY_OTHER_BANK = PropertyConfigItem.builder().key("SALARY_OTHER_BANK").mlName(new MultiLangEnumBridge("\u662f\u5426\u652f\u6301\u8de8\u884c\u4ee3\u53d1\u5de5\u8d44", "BankBusinessConfig_56", "ebg-aqap-banks-ccb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f\u5426\u652f\u6301\u8de8\u884c\u4ee3\u53d1\u5de5\u8d44:", "BankBusinessConfig_57", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("1)\u662f;", "BankBusinessConfig_67", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("2)\u5426;", "BankBusinessConfig_68", "ebg-aqap-banks-ccb-dc")})).mlSourceNames(mlTrueFalseCN).sourceValues(trueFalseEN).defaultValues(defaultTrue).readonly(true).isHide(true).type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName()).build();
    private static final PropertyConfigItem ccb_dc_SALARY_BATCH_SIZE = PropertyConfigItem.builder().key("SALARY_BATCH_SIZE").mlName(new MultiLangEnumBridge("\u6bcf\u6279\u7b14\u6570", "BankBusinessConfig_58", "ebg-aqap-banks-ccb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ee3\u53d1\u63a5\u53e3\u6bcf\u4e2a\u6279\u6b21\u652f\u6301\u7684\u7b14\u6570\u3002", "BankBusinessConfig_59", "ebg-aqap-banks-ccb-dc")})).sourceNames((List)Lists.newArrayList((Object[])new String[]{"1"})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"1"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"1"})).isHide(true).readonly(true).type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName()).build();
    private static final PropertyConfigItem ccb_dc_SALARY_DETAIL = PropertyConfigItem.builder().key("SALARY_DETAIL").mlName(new MultiLangEnumBridge("\u94f6\u4f01\u4ea4\u6613\u660e\u7ec6\u662f\u5426\u6c47\u603b\u4e00\u6761\u660e\u7ec6\u3002", "BankBusinessConfig_60", "ebg-aqap-banks-ccb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u94f6\u4f01\u4ea4\u6613\u660e\u7ec6\u662f\u5426\u6c47\u603b\u4e00\u6761\u660e\u7ec6:\u3002", "BankBusinessConfig_61", "ebg-aqap-banks-ccb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f85\u8865\u5145", "BankBusinessConfig_62", "ebg-aqap-banks-ccb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5f85\u8865\u5145", (String)"BankBusinessConfig_62", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0])})).defaultValues((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5f85\u8865\u5145", (String)"BankBusinessConfig_62", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0])})).readonly(true).type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName()).build();
    private static final PropertyConfigItem ccb_dc_SALARY_DETAIL_BANK = PropertyConfigItem.builder().key("SALARY_DETAIL_BANK").mlName(new MultiLangEnumBridge("\u7f51\u94f6\u4ea4\u6613\u660e\u7ec6\u662f\u5426\u6c47\u603b\u4e00\u6761\u660e\u7ec6\u3002", "BankBusinessConfig_63", "ebg-aqap-banks-ccb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u7f51\u94f6\u4ea4\u6613\u660e\u7ec6\u662f\u5426\u6c47\u603b\u4e00\u6761\u660e\u7ec6:", "BankBusinessConfig_64", "ebg-aqap-banks-ccb-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5f85\u8865\u5145", "BankBusinessConfig_62", "ebg-aqap-banks-ccb-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5f85\u8865\u5145", (String)"BankBusinessConfig_62", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0])})).defaultValues((List)Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5f85\u8865\u5145", (String)"BankBusinessConfig_62", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0])})).readonly(true).type(BankPropertyConfigType.PAY_FOR_SALARY_PARAM.getName()).build();
    private static final PropertyConfigItem ccb_dc_detail_choose = PropertyConfigItem.builder().key("detail_note_select").mlName(new MultiLangEnumBridge("\u4ea4\u6613\u660e\u7ec6\u6458\u8981\u53d6\u503c\u3002", "BankBusinessConfig_65", "ebg-aqap-banks-ccb-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ea4\u6613\u660e\u7ec6\u6458\u8981\u53d6\u503c\u3002", "BankBusinessConfig_65", "ebg-aqap-banks-ccb-dc")})).inputType(ConfigInputType.CLICK_TEXT.getInputType()).isHide(true).build();
    private static final PropertyConfigItem QueryDepositBalance = PropertyConfigItem.builder().key("QueryDepositBalance").mlName(new MultiLangEnumBridge("\u662f\u5426\u9700\u8981\u67e5\u8be2\u4e0a\u5b58\u4f59\u989d", "BankBusinessConfig_55", "ebg-aqap-banks-ccb-dc")).mlDesc(new MultiLangEnumBridge("\u5f53\u8bbe\u7f6e\u4e3a\u662f\u65f6\uff0c\u67e5\u8be2\u5f53\u65e5\u4f59\u989d\u65f6\u9700\u8981\u8fd4\u56de\u4e0a\u5b58\u4f59\u989d\u3002\u6b64\u914d\u7f6e\u4f7f\u7528\u63a5\u53e3\u53ca\u5b57\u6bb5\u6709\uff1a\uff086WCZ02\uff09\u3002", "BankBusinessConfig_54", "ebg-aqap-banks-ccb-dc")).mlSourceNames(mlFalseTrueCN).sourceValues(falseTrueEN).defaultValues(defaultFalse).isAccNo(true).mustInput(true).build();

    public String getBankVersionID() {
        return "CCB_DC";
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List list = this.getBankAddtionalPropertyConfigItems(true, false, false, true, true);
        list.addAll(Lists.newArrayList((Object[])new PropertyConfigItem[]{ccb_dc_isIndividualToCompany, ccb_dc_isBatchIndividualPay, ccb_dc_needPaymentConfirm, ccb_dc_needAcntValidate, ccb_dc_isAddKDFlagToPay, ccb_dc_InnerSalaryBillCode, ccb_dc_OutterSalaryBillCode, ccb_dc_SalaryUseofCode, ccb_dc_BatchPayFileType, ccb_dc_TemplateType, ccb_dc_isShowLinkDetail, ccb_dc_MainAccount, ccb_dc_SALARY_SELECT, ccb_dc_SALARY_SAME_BANK, ccb_dc_SALARY_OTHER_BANK, ccb_dc_SALARY_BATCH_SIZE, ccb_dc_detail_choose, QueryDepositBalance}));
        BankBusinessConfig.specialAccNoTypeMl((List)list, (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u666e\u901a\u7c7b", "BankBusinessConfig_0", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u8d22\u8d44\u7c7b", "BankBusinessConfig_1", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u5b9a\u671f\u6237", "BankBusinessConfig_2", "ebg-aqap-banks-ccb-dc")}), (List)Lists.newArrayList((Object[])new String[]{"normal", "caizi", "fixed"}));
        BankBusinessConfig.setAccTypeDesc((List)list, (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u8d26\u6237\u7c7b\u522b\uff1a\u8d26\u6237\u5207\u6362\u540e\u5bf9\u4e1a\u52a1\u7684\u5904\u7406\u5dee\u5f02\u5982\u4e0b", "AccountTypeTips_0", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("1\uff09\u666e\u901a\u7c7b\uff1a\u666e\u901a\u8d26\u6237\u7c7b\u578b\uff0c\u4f7f\u7528\u6807\u51c6\u63a5\u53e3\u5b8c\u6210\u4e1a\u52a1\u5904\u7406\u3002", "AccountTypeTips_1", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("2\uff09\u8d22\u8d44\u7c7b\uff1a\u8d22\u8d44\u8d26\u6237\u660e\u7ec6\u67e5\u8be2\u5c06\u5207\u6362\u4f7f\u75286WY108\u63a5\u53e3\u5b8c\u6210\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u3002", "AccountTypeTips_2", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("3\uff09\u5b9a\u671f\u6237\uff1a\u5b9a\u671f\u8d26\u6237\u4f59\u989d\u67e5\u8be2\u5c06\u5207\u6362\u4f7f\u75286WD401\u5b8c\u6210", "AccountTypeTips_3", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u6ce8\uff1a\u5982\u9700\u66f4\u6539\u8d26\u6237\u7c7b\u578b\uff0c\u8d26\u6237\u7c7b\u578b\u540c\u6b65\u9700\u8981\u4ece\u201c\u8d26\u6237\u7ba1\u7406\u201d\u6a21\u5757\u53d8\u66f4\u3002", "AccountTypeTips_4", "ebg-aqap-banks-ccb-dc"), new MultiLangEnumBridge("\u4e1a\u52a1\u63a5\u53e3\u53ef\u4ee5\u67e5\u770b\u94f6\u884c\u63a5\u53e3\u652f\u6301\u5217\u8868\u3002", "AccountTypeTips_5", "ebg-aqap-banks-ccb-dc")}));
        return list;
    }

    public static boolean isUseOldTemplate() {
        return ccb_dc_TemplateType.getCurrentValueAsBoolean();
    }

    public static boolean isAddKDFlagToPay() throws EBServiceException {
        return "addKDFlag".equalsIgnoreCase(ccb_dc_isAddKDFlagToPay.getCurrentValue());
    }

    public static boolean isIndividualToCompany() throws EBServiceException {
        return "true".equalsIgnoreCase(ccb_dc_isIndividualToCompany.getCurrentValue());
    }

    public static boolean isBatchIndividualPay() throws EBServiceException {
        return "true".equalsIgnoreCase(ccb_dc_isBatchIndividualPay.getCurrentValue());
    }

    public static boolean needPaymentConfirm() throws EBServiceException {
        return "true".equalsIgnoreCase(ccb_dc_needPaymentConfirm.getCurrentValue());
    }

    public static boolean needAcntValidate() throws EBServiceException {
        return "true".equalsIgnoreCase(ccb_dc_needAcntValidate.getCurrentValue());
    }

    public static String getIncomeBillCode(String payAccNo) throws EBServiceException {
        return "";
    }

    public static String getInnerSalaryBillCode(String payAccNo) throws EBServiceException {
        return ccb_dc_InnerSalaryBillCode.getCurrentValueWithObjectID(payAccNo);
    }

    public static String getOutterSalaryBillCode(String payAccNo) throws EBServiceException {
        return ccb_dc_OutterSalaryBillCode.getCurrentValueWithObjectID(payAccNo);
    }

    public static String getIncomeUseofCode(String payAccNo) throws EBServiceException {
        return "";
    }

    public static String getSalaryUseofCode(String payAccNo) throws EBServiceException {
        return ccb_dc_SalaryUseofCode.getCurrentValueWithObjectID(payAccNo);
    }

    public static String getBatchPayFileType(String payAccNo) throws EBServiceException {
        return ccb_dc_BatchPayFileType.getCurrentValueWithObjectID(payAccNo);
    }

    public static boolean isCaiZiAcnt(String accNo) throws EBServiceException {
        return "caizi".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)accNo));
    }

    public static boolean isShowLinkDetail() {
        return ccb_dc_isShowLinkDetail.getCurrentValueAsBoolean();
    }

    public static String getMainAccount(String accNo) {
        return ccb_dc_MainAccount.getCurrentValueWithObjectID(accNo);
    }

    public List<LinkPayConfig> getLinkPayConfigs() {
        return Lists.newArrayList((Object[])new LinkPayConfig[]{LinkPayConfig.ALLOCATION_AND_PAY});
    }

    public static boolean isQueryDepositBal(String accNo) {
        return "true".equals(QueryDepositBalance.getCurrentValueWithObjectID(accNo));
    }
}

