/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.List;
import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayDepositBalBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DepositBalanceImpl
extends AbstractBalanceImpl
implements ITodayDepositBalBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        String request_sn = String.valueOf(Sequence.gen16NumSequence());
        Element header = CCB_DC_Packer.createTransactionHeader((String)"6WCZ02", (String)request_sn);
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"ACC_NO", (String)BankBusinessConfig.getMainAccount(acnt.getAccNo()));
        JDomUtils.addChild((Element)txInfo, (String)"ACCT_NO", (String)acnt.getAccNo());
        return CCB_DC_Packer.packAll2XML((Element)header, (Element)txInfo);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        Element root = CCB_DC_Parser.parseString2Root((String)rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse((Element)root);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        Element txInfo = root.getChild("TX_INFO");
        Element detaillist = txInfo.getChild("DETAILLIST");
        List children = detaillist.getChildren();
        for (Element detailInfo : children) {
            String braAcctNo = detailInfo.getChildText("BRA_ACCT_NO");
            String depositBalance = detailInfo.getChildText("FATH_RELATED_AMT");
            String freezeAmt = detailInfo.getChildText("FRZN_AMT");
            if (!bankBalanceRequest.getAcnt().getAccNo().equals(braAcctNo)) continue;
            BalanceInfo balance = new BalanceInfo();
            this.setDepositBalance(balance, depositBalance);
            this.setFreezeBalance(balance, freezeAmt);
            this.setBankAcnt(balance, bankBalanceRequest.getAcnt());
            this.setBankCurrency(balance, bankBalanceRequest.getBankCurrency());
            return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
        }
        return new EBBankBalanceResponse();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "6WCZ02";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(BankBalanceRequest request) {
        LocalDate today = LocalDate.now();
        boolean matchTime = today.equals(request.getStartDate()) && today.equals(request.getEndDate());
        boolean matchConfig = BankBusinessConfig.isQueryDepositBal(((BankAcnt)request.getBankAcntList().get(0)).getAccNo());
        boolean isFixedAcnt = BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo());
        return matchTime && matchConfig && !isFixedAcnt;
    }
}

