/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.detail;

import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailPacker {
    public String packHisDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        return this.packDetail(rqst, pageTag);
    }

    public String packTodayDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        return this.packDetail(rqst, pageTag);
    }

    private String packDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        if (BankBusinessConfig.isCaiZiAcnt(rqst.getAcnt().getAccNo())) {
            return this.packCaiZiDetail(rqst, pageTag);
        }
        return this.packNormalDetail(rqst, pageTag);
    }

    public String packNormalDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        BankAcnt acnt = rqst.getAcnt();
        String request_sn = String.valueOf(Sequence.gen16NumSequence());
        Element header = CCB_DC_Packer.createTransactionHeader((String)"6WY101", (String)request_sn);
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"ACCNO1", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)txInfo, (String)"STARTDATE", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txInfo, (String)"ENDDATE", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txInfo, (String)"BARGAIN_FLAG", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"CHECK_ACC_NO", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"CHECK_ACC_NAME", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"REMARK", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"LOW_AMT", (String)"-999999999999.99");
        JDomUtils.addChild((Element)txInfo, (String)"HIGH_AMT", (String)"999999999999.99");
        int index = pageTag.indexOf("_");
        JDomUtils.addChild((Element)txInfo, (String)"PAGE", (String)pageTag.substring(0, index));
        JDomUtils.addChild((Element)txInfo, (String)"POSTSTR", (String)pageTag.substring(index + 1));
        JDomUtils.addChild((Element)txInfo, (String)"TOTAL_RECORD", (String)"100");
        return CCB_DC_Packer.packAll2XML((Element)header, (Element)txInfo);
    }

    public String packCaiZiDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        BankAcnt acnt = rqst.getAcnt();
        String request_sn = String.valueOf(Sequence.gen16NumSequence());
        Element header = CCB_DC_Packer.createTransactionHeader((String)"6WY108", (String)request_sn);
        Element txInfo = new Element("TX_INFO");
        String mainAccount = BankBusinessConfig.getMainAccount(acnt.getAccNo());
        if (StringUtils.isEmpty((String)mainAccount)) {
            JDomUtils.addChild((Element)txInfo, (String)"CZ_ACC_NO", (String)acnt.getAccNo());
            JDomUtils.addChild((Element)txInfo, (String)"MEMB_ACC_NO", (String)"");
        } else {
            JDomUtils.addChild((Element)txInfo, (String)"CZ_ACC_NO", (String)mainAccount);
            JDomUtils.addChild((Element)txInfo, (String)"MEMB_ACC_NO", (String)acnt.getAccNo());
        }
        JDomUtils.addChild((Element)txInfo, (String)"STARTDATE", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txInfo, (String)"ENDDATE", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        boolean showLinkDetail = BankBusinessConfig.isShowLinkDetail();
        JDomUtils.addChild((Element)txInfo, (String)"IS_SHOW_EXD", (String)(showLinkDetail ? "1" : "0"));
        JDomUtils.addChild((Element)txInfo, (String)"BARGAIN_FLAG", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"CHECK_ACC_NO", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"CHECK_ACC_NAME", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"REMARK", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"LOW_AMT", (String)"-9999999999999");
        JDomUtils.addChild((Element)txInfo, (String)"HIGH_AMT", (String)"9999999999999.99");
        int index = pageTag.indexOf("_");
        JDomUtils.addChild((Element)txInfo, (String)"PAGE", (String)pageTag.substring(0, index));
        JDomUtils.addChild((Element)txInfo, (String)"POSTSTR", (String)pageTag.substring(index + 1));
        JDomUtils.addChild((Element)txInfo, (String)"TOTAL_RECORD", (String)"100");
        return CCB_DC_Packer.packAll2XML((Element)header, (Element)txInfo);
    }
}

