/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.global.service.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.global.utils.ABC_Global_Packer;
import kd.ebg.aqap.banks.abc.global.utils.ABC_Global_Parser;
import kd.ebg.aqap.banks.abc.global.utils.ResponseFileUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public boolean isSupportPage() {
        return true;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = ABC_Global_Packer.createABCRoot4New("GQRA39", Sequence.genSequence());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"StartDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)corp, (String)"EndDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)bankDetailRequest.getBankCurrency());
        Element business = JDomUtils.addChild((Element)root, (String)"Business");
        JDomUtils.addChild((Element)business, (String)"id", (String)("0".equalsIgnoreCase(this.getCurrentPage()) ? "" : this.getCurrentPage()));
        return ABC_Global_Packer.covert2ABCMessage(root);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        String[] splits;
        this.setLastPage(true);
        Element root = ABC_Global_Parser.parseString2Root(s);
        BankResponse bankResponse = ABC_Global_Parser.parseHeader(root);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        String respCode = root.getChildTextTrim("RespCode");
        String RespInfo = root.getChildTextTrim("RespInfo");
        if (PropertiesConstants.getValue((String)"NOT_RECORD").equalsIgnoreCase(RespInfo)) {
            return new EBBankDetailResponse(detailList);
        }
        if ("EOSRT00077".equals(respCode)) {
            return new EBBankDetailResponse(detailList);
        }
        if (!"0000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%1$s %2$s", (String)"DetailImpl_0", (String)"ebg-aqap-banks-abc-global", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element cme = root.getChild("Cme");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return new EBBankDetailResponse(detailList);
        }
        String fileFlag = JDomUtils.getChildText((Element)root, (String)"FileFlag");
        Element cmp = root.getChild("Cmp");
        if ("1".equalsIgnoreCase(fileFlag)) {
            String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            splits = ResponseFileUtils.getDetailRspRecords(fileName, "");
        } else {
            String respPrvData = ParserUtils.checkUnNullableElement((Element)cmp, (String)"RespPrvData");
            splits = StringUtils.split((String)respPrvData, (String)"|_|");
        }
        String contFlag = JDomUtils.getChildText((Element)cmp, (String)"ContFlag");
        if ("1".equalsIgnoreCase(contFlag)) {
            this.setLastPage(false);
            Element business = root.getChild("Business");
            String id = JDomUtils.getChildText((Element)business, (String)"id");
            this.setCurrentPage(id);
        }
        int fieldNum = Integer.parseInt(fieldNumStr);
        for (int i = 0; i < recordNum; ++i) {
            String id = splits[fieldNum * i];
            String customNo = splits[fieldNum * i + 1];
            String accNo = splits[fieldNum * i + 2];
            String currency = splits[fieldNum * i + 3];
            String transNo = splits[fieldNum * i + 4];
            String transDate = splits[fieldNum * i + 5];
            String submitDate = splits[fieldNum * i + 6];
            String transAmount = splits[fieldNum * i + 7];
            String balance = splits[fieldNum * i + 9];
            String transDesc = splits[fieldNum * i + 10];
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(accNo);
            detail.setCurrency(currency);
            detail.setTransDate(LocalDate.parse(submitDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setTransTime(LocalDateTime.parse(submitDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            BigDecimal amout = new BigDecimal(transAmount);
            if (amout.compareTo(BigDecimal.ZERO) > 0) {
                detail.setDebitAmount(BigDecimal.ZERO);
                detail.setCreditAmount(amout.abs());
            } else {
                detail.setDebitAmount(amout.abs());
                detail.setCreditAmount(BigDecimal.ZERO);
            }
            detail.setExplanation(transDesc);
            if (StringUtils.isNotEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            JSONObject json = new JSONObject();
            json.put("id", (Object)id);
            json.put("customNo", (Object)customNo);
            json.put("accNo", (Object)accNo);
            json.put("currency", (Object)currency);
            json.put("transNo", (Object)transNo);
            json.put("transDate", (Object)transDate);
            json.put("submitDate", (Object)submitDate);
            json.put("transAmount", (Object)transAmount);
            json.put("balance", (Object)balance);
            json.put("transDesc", (Object)transDesc);
            detail.setJsonMap(json.toJSONString());
            detail.setReceiptNo(id);
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GQRA39";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u5883\u5b9e\u65f6\u67e5\u8be2\u660e\u7ec6", (String)"DetailImpl_1", (String)"ebg-aqap-banks-abc-global", (Object[])new Object[0]);
    }
}

