/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.global.service.payment;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.global.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.global.service.payment.QueryPayImpl;
import kd.ebg.aqap.banks.abc.global.utils.ABC_Global_Packer;
import kd.ebg.aqap.banks.abc.global.utils.ABC_Global_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = ABC_Global_Packer.createABCRoot4New("GFRT02", paymentInfo.getBankDetailSeqID());
        Element gcs = JDomUtils.addChild((Element)root, (String)"gcs");
        JDomUtils.addChild((Element)gcs, (String)"CustRefFlag", (String)"0");
        JDomUtils.addChild((Element)gcs, (String)"CustRef", (String)"");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfo.getCurrency());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        String accName = bankPayRequest.getAcnt().getEnAccName();
        if (StringUtils.isEmpty((String)accName)) {
            accName = paymentInfo.getAccName();
        }
        JDomUtils.addChild((Element)corp, (String)"DbAccName", (String)accName);
        JDomUtils.addChild((Element)corp, (String)"DbBankNo", (String)BankBusinessConfig.getBicCode(paymentInfo.getAccNo()));
        if (paymentInfo.getBookingTime() != null && paymentInfo.getBookingTime().isAfter(LocalDateTime.now())) {
            JDomUtils.addChild((Element)gcs, (String)"ReqExecDate", (String)paymentInfo.getBookingTime().toLocalDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            PaymentUtil.setBookPayFlag((PaymentInfo)paymentInfo);
        } else {
            JDomUtils.addChild((Element)gcs, (String)"ReqExecDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        JDomUtils.addChild((Element)gcs, (String)"ActualCcy", (String)paymentInfo.getPayCurrency());
        JDomUtils.addChild((Element)gcs, (String)"ActualAmt", (String)paymentInfo.getActualAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)gcs, (String)"ExRateFlag", (String)"0");
        JDomUtils.addChild((Element)gcs, (String)"ExRate", (String)"");
        JDomUtils.addChild((Element)gcs, (String)"FXDealRefFlg", (String)"0");
        JDomUtils.addChild((Element)gcs, (String)"FXDealRef", (String)"");
        JDomUtils.addChild((Element)root, (String)"Amt", (String)"");
        JDomUtils.addChild((Element)gcs, (String)"UseParentAccFlag", (String)"0");
        JDomUtils.addChild((Element)gcs, (String)"SubCompName", (String)"");
        JDomUtils.addChild((Element)corp, (String)"CrBankNo", (String)paymentInfo.getIncomeSwiftCode());
        JDomUtils.addChild((Element)corp, (String)"CrBankName", (String)paymentInfo.getIncomeBankAddress());
        JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)corp, (String)"CrAccName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)corp, (String)"Postscript", (String)paymentInfo.getExplanation());
        String feeMode = "OUR";
        if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeMode = "BEN";
        } else if ("03".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
            feeMode = "SHA";
        }
        JDomUtils.addChild((Element)gcs, (String)"ChargeDtl", (String)feeMode);
        JDomUtils.addChild((Element)gcs, (String)"FeeAccFlag", (String)(StringUtils.equalsIgnoreCase((String)paymentInfo.getAccNo(), (String)paymentInfo.getPayerFeeAccNo()) ? "0" : "1"));
        JDomUtils.addChild((Element)gcs, (String)"FeeAccNo", (String)paymentInfo.getPayerFeeAccNo());
        JDomUtils.addChild((Element)gcs, (String)"CodeType", (String)"02");
        return ABC_Global_Packer.covert2ABCMessage(root);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = ABC_Global_Parser.parseString2Root(s);
        BankResponse bankResponse = ABC_Global_Parser.parseHeader(root);
        if ("0000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u519c\u884c\u5df2\u53d7\u7406\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-abc-global", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-abc-global", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GFRT02";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u5883\u8d26\u6237\u5355\u7b14\u652f\u4ed8\u7533\u8bf7", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-abc-global", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

