/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.global.utils;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ABC_Global_Packer {
    public static Element createABCRoot4New(String transCode) {
        return ABC_Global_Packer.createABCRoot4New(transCode, Sequence.genSequence());
    }

    public static Element createABCRoot4New(String transCode, String reqSeqNo) {
        Element element = new Element("ap");
        JDomUtils.addChild((Element)element, (String)"CCTransCode", (String)transCode);
        JDomUtils.addChild((Element)element, (String)"ProductID", (String)"ICC");
        JDomUtils.addChild((Element)element, (String)"ChannelType", (String)"ERP");
        JDomUtils.addChild((Element)element, (String)"CorpNo", (String)RequestContextUtils.getBankParameterValue((String)"CorpNo"));
        JDomUtils.addChild((Element)element, (String)"OpNo", (String)RequestContextUtils.getBankParameterValue((String)"OpNo"));
        JDomUtils.addChild((Element)element, (String)"AuthNo", (String)"");
        JDomUtils.addChild((Element)element, (String)"ReqSeqNo", (String)reqSeqNo);
        JDomUtils.addChild((Element)element, (String)"ReqDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)element, (String)"ReqTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)element, (String)"Sign", (String)"");
        return element;
    }

    public static Element createABCRoot(String tradeCode) {
        return ABC_Global_Packer.createABCRoot(tradeCode, Sequence.genSequence());
    }

    public static Element createABCRoot(String tradeCode, String seqno) {
        Element root = JDomUtils.createRoot((String)"ap");
        JDomUtils.addChild((Element)root, (String)"TransCode", (String)tradeCode);
        JDomUtils.addChild((Element)root, (String)"ChannelType", (String)"0");
        JDomUtils.addChild((Element)root, (String)"CorpNo", (String)RequestContextUtils.getBankParameterValue((String)"CorpNo"));
        JDomUtils.addChild((Element)root, (String)"OpNo", (String)RequestContextUtils.getBankParameterValue((String)"OpNo"));
        JDomUtils.addChild((Element)root, (String)"AuthNo", (String)"");
        JDomUtils.addChild((Element)root, (String)"ReqSeqNo", (String)seqno);
        JDomUtils.addChild((Element)root, (String)"ReqDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)root, (String)"ReqTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)root, (String)"Sign", (String)"");
        return root;
    }

    public static String covert2ABCMessage(Element root) {
        String encoding = RequestContextUtils.getCharset();
        return ABC_Global_Packer.appendABCHead(JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding));
    }

    private static String appendABCHead(String str) {
        String charsetName = RequestContextUtils.getCharset();
        byte[] bytes = StrUtil.bytes((CharSequence)str, (String)charsetName);
        String head = StrUtil.padEnd((CharSequence)("0" + bytes.length), (int)7, (char)' ');
        return head + str;
    }

    public static Element packCorp(Element root) {
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"BookingDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)corp, (String)"BookingTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)corp, (String)"BookingFlag", (String)"0");
        return corp;
    }

    public static String checkNotNull(String value, String message) {
        if (StringUtils.isEmpty((String)value)) {
            throw EBExceiptionUtil.payFailException((String)message);
        }
        return value;
    }
}

