/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zyb.dc.services.payment.otherbank;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zyb.dc.services.payment.otherbank.OtherBankPacker;
import kd.ebg.aqap.banks.zyb.dc.services.payment.otherbank.OtherBankParser;
import kd.ebg.aqap.banks.zyb.dc.services.payment.otherbank.OtherBankPayQueryImpl;
import kd.ebg.aqap.banks.zyb.dc.utils.Utils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class OtherBankPayImpl
extends AbstractPayImpl
implements IPay {
    OtherBankPacker otherBankPacker = new OtherBankPacker();
    OtherBankParser otherBankParser = new OtherBankParser();

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return OtherBankPayQueryImpl.class;
    }

    public String getDeveloper() {
        return "jiewen_liang";
    }

    public String getBizCode() {
        return "01B2ECrossBankTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u8d26", (String)"OtherBankPayImpl_0", (String)"ebg-aqap-banks-zyb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equals(paymentInfo.getSubBizType()) && !paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        return this.otherBankPacker.packPay(Utils.listToArray((List)request.getPaymentInfos()));
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return this.otherBankParser.parsePay(Utils.listToArray((List)request.getPaymentInfos()), responseStr);
    }

    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/bte-ebte/pay/n/crossBankTransfer?").append("userPassword=").append(RequestContextUtils.getParameter().getBankParameter("Password")).append("&SIGDATA=1");
        factory.setUri(sb.toString());
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
    }
}

