/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.dc.service.payment.company.outer;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.dc.Packer;
import kd.ebg.aqap.banks.xmb.dc.Parser;
import kd.ebg.aqap.banks.xmb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.banks.xmb.dc.service.payment.allocation.transdown.QueryPayImpl;
import kd.ebg.aqap.banks.xmb.dc.service.sign.SignService;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay,
IQueryPay {
    public String getDeveloper() {
        return "mukan_huang";
    }

    public String getBizCode() {
        return "CBE007";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u4ed8\u6b3e", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=GBK");
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfoList = bankPayRequest.getPaymentInfoAsArray();
        if (paymentInfoList.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8de8\u884c\u4ed8\u6b3e\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"PaymentImpl_5", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]));
        }
        Element XCCBEBankData = new Element("XCCBEBankData");
        Element opReq = JDomUtils.addChild((Element)XCCBEBankData, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)paymentInfoList[0].getPackageId());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"FKZH", (String)paymentInfoList[0].getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"SKZH", (String)paymentInfoList[0].getIncomeAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"SKHM", (String)paymentInfoList[0].getIncomeAccName());
        JDomUtils.addChild((Element)ReqParam, (String)"SKYH", (String)paymentInfoList[0].getIncomeBankName());
        JDomUtils.addChild((Element)ReqParam, (String)"LHNO", (String)paymentInfoList[0].getIncomeCnaps());
        JDomUtils.addChild((Element)ReqParam, (String)"JYJE", (String)paymentInfoList[0].getAmount().toString());
        JDomUtils.addChild((Element)ReqParam, (String)"BIZH", (String)paymentInfoList[0].getCurrency());
        String zzlb = "0";
        zzlb = paymentInfoList[0].is2Urgent() ? "1" : "0";
        BigDecimal amout = paymentInfoList[0].getAmount();
        zzlb = 0 < amout.compareTo(BigDecimal.valueOf(20000.0)) ? "1" : "0";
        JDomUtils.addChild((Element)ReqParam, (String)"ZZLB", (String)zzlb);
        JDomUtils.addChild((Element)ReqParam, (String)"YOTU", (String)paymentInfoList[0].getExplanation());
        String xmlMessage = Packer.packFormatXmlMsg(XCCBEBankData, "GBK");
        String signData = SignService.sign(xmlMessage);
        String sessionId = LoginAndOut.getLoginAndOut().getLoginSessionId();
        return Packer.packAll(sessionId, "CBE007", signData);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfoList = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = paymentInfoList.toArray(new PaymentInfo[paymentInfoList.size()]);
        Parser.parsePayRsp(paymentInfos, s);
        EBBankPayResponse response = new EBBankPayResponse();
        response.setPaymentInfos(Arrays.asList(paymentInfos));
        return response;
    }

    public boolean match(PaymentInfo info) {
        return false;
    }
}

