/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.dc.service.payment.individual.salary;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xmb.dc.Packer;
import kd.ebg.aqap.banks.xmb.dc.Parser;
import kd.ebg.aqap.banks.xmb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.banks.xmb.dc.service.payment.individual.salary.QueryPayImpl;
import kd.ebg.aqap.banks.xmb.dc.service.sign.SignService;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element XCCBEBankData = new Element("XCCBEBankData");
        Element opReq = JDomUtils.addChild((Element)XCCBEBankData, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)paymentInfos[0].getPackageId());
        String testTime = RequestContextUtils.getBankParameterValue((String)"TEST_TIME");
        if (StringUtils.isEmpty((String)testTime)) {
            JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        } else {
            JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)(testTime + DateUtil.formatDate((Date)new Date(), (String)"HHmmss")));
        }
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"payAccount", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"compNo", (String)RequestContextUtils.getBankParameterValue((String)"compNo"));
        JDomUtils.addChild((Element)ReqParam, (String)"type", (String)"1006");
        JDomUtils.addChild((Element)ReqParam, (String)"totalNum", (String)String.valueOf(paymentInfos.length));
        Element totalAmtElement = JDomUtils.addChild((Element)ReqParam, (String)"totalAmt");
        BigDecimal totalAmt = new BigDecimal("0.00");
        JDomUtils.addChild((Element)ReqParam, (String)"summary", (String)paymentInfos[0].getExplanation());
        Element listElement = JDomUtils.addChild((Element)ReqParam, (String)"list");
        int len = paymentInfos.length;
        for (int i = 0; i < len; ++i) {
            totalAmt = totalAmt.add(paymentInfos[i].getAmount());
            Element row = JDomUtils.addChild((Element)listElement, (String)"row");
            JDomUtils.addChild((Element)row, (String)"recAccount", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"recAccountName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"amount", (String)paymentInfos[i].getAmount().toString());
            JDomUtils.addChild((Element)row, (String)"thirdNo", (String)"");
        }
        totalAmtElement.setText(totalAmt.toString());
        String xmlMessage = Packer.packFormatXmlMsg(XCCBEBankData, "GBK");
        String signData = SignService.sign(xmlMessage);
        String sessionId = LoginAndOut.getLoginAndOut().getLoginSessionId();
        return Packer.packAll(sessionId, "CBE012", signData);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfoList = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = paymentInfoList.toArray(new PaymentInfo[paymentInfoList.size()]);
        BankResponse response = Parser.parserMsgHead(rspStr);
        if (!"0000".equalsIgnoreCase(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return new EBBankPayResponse(Arrays.asList(paymentInfos));
        }
        Element root = Parser.getXmlRoot(rspStr);
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String hostReturnCode = opResult.getChildTextTrim("hostReturnCode");
        String hostErrorMessage = opResult.getChildTextTrim("hostErrorMessage");
        Element listElement = opResult.getChild("list");
        List rowList = listElement.getChildren("row");
        if ("0000".equalsIgnoreCase(hostReturnCode) && (null == rowList || rowList.size() == 0)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentImpl_7", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)hostReturnCode, (String)hostErrorMessage);
            return new EBBankPayResponse(Arrays.asList(paymentInfos));
        }
        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u7591\u4f3c\u6574\u6279\u4ea4\u6613\u5931\u8d25\uff0c\u8bf7\u540c\u6b65\u4ea4\u6613\u7ed3\u679c\u3002", (String)"PaymentImpl_8", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)hostReturnCode, (String)"");
        int len = rowList.size();
        for (int i = 0; i < len; ++i) {
            Element row = (Element)rowList.get(i);
            String recAccount = row.getChildTextTrim("recAccount");
            String recAccName = row.getChildTextTrim("recAccName");
            String amount = row.getChildTextTrim("amount");
            String errorMsg = row.getChildTextTrim("errorMsg");
            PaymentInfo payInfo = Parser.findPaymentInfo(paymentInfos, recAccount, amount);
            if (null == payInfo) {
                errorMsg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u7b14\u4ea4\u6613\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u5931\u8d25\u7684\u9519\u8bef\u4fe1\u606f\u3002", (String)"PaymentImpl_9", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u7591\u4f3c\u6574\u6279\u4ea4\u6613\u5931\u8d25\uff0c\u8bf7\u540c\u6b65\u4ea4\u6613\u7ed3\u679c\u3002", (String)"PaymentImpl_8", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)hostReturnCode, (String)errorMsg);
        }
        return new EBBankPayResponse(Arrays.asList(paymentInfos));
    }

    public String getBizCode() {
        return "CBE012";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"PaymentImpl_10", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=GBK");
    }

    public String getDeveloper() {
        return "mukan_huang";
    }
}

