/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bcs.cmp.services.balance;

import java.io.InputStream;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bcs.cmp.utils.Constant;
import kd.ebg.aqap.banks.bcs.cmp.utils.Packer;
import kd.ebg.aqap.banks.bcs.cmp.utils.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg((String)super.recv(inputStream));
    }

    public String pack(BankBalanceRequest rqst) {
        String accNo = rqst.getAcnt().getAccNo();
        Element root = Packer.buildHead((String)"0000304T012A0016", (String)Sequence.genSequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"startDate", (String)rqst.getStartDate().format(Constant.dateFormat));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)rqst.getEndDate().format(Constant.dateFormat));
        JDomUtils.addChild((Element)body, (String)"curCode", (String)rqst.getBankCurrency());
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg((String)xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser((Element)root);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        Element body = root.getChild("body");
        LinkedList<BalanceInfo> hisBalanceInfos = new LinkedList<BalanceInfo>();
        if (body == null || body.getChild("array") == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u54cd\u5e94\u62a5\u6587\u4e2d\u7f3a\u5c11\u4f59\u989d\u4fe1\u606f\u3002", (String)"HisBalanceImpl_1", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
        }
        List dtoList = body.getChild("array").getChildren("dto");
        for (Element dto : dtoList) {
            String acctNo = dto.getChildTextTrim("acctNo");
            String acDate = dto.getChildTextTrim("acDate");
            String balance = dto.getChildTextTrim("balance");
            String currency = dto.getChildTextTrim("currency");
            BalanceInfo balanceInfo = new BalanceInfo();
            this.setBankCurrency(balanceInfo, rqst.getBankCurrency(), currency);
            this.setBankAcnt(balanceInfo, rqst.getBankAcntList(), acctNo);
            this.setCurrentBalance(balanceInfo, balance);
            this.setAvailableBalance(balanceInfo, balance);
            this.setBalanceDateTime(balanceInfo, acDate + "000000", Constant.dateTimeFormat);
            hisBalanceInfos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(hisBalanceInfos);
    }

    public LocalDate limitDate() {
        return LocalDate.now().minusDays(29L);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "0000304T012A0016";
    }

    public String getBizDesc() {
        return null;
    }
}

