/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bcs.cmp.services.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bcs.cmp.utils.Constant;
import kd.ebg.aqap.banks.bcs.cmp.utils.Packer;
import kd.ebg.aqap.banks.bcs.cmp.utils.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = Packer.buildHead((String)"00003020101A0007", (String)Sequence.genSequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"currency", (String)request.getBankCurrency());
        String TESTDATE = RequestContextUtils.getBankParameterValue((String)"testdate");
        if (StringUtils.isEmpty((String)TESTDATE)) {
            JDomUtils.addChild((Element)body, (String)"startDate", (String)request.getStartDate().format(Constant.dateFormat));
            JDomUtils.addChild((Element)body, (String)"endDate", (String)request.getEndDate().format(Constant.dateFormat));
        } else {
            JDomUtils.addChild((Element)body, (String)"startDate", (String)TESTDATE);
            JDomUtils.addChild((Element)body, (String)"endDate", (String)TESTDATE);
        }
        int pageNum = Integer.parseInt(this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"start", (String)(1 + pageNum * 10 + ""));
        JDomUtils.addChild((Element)body, (String)"size", (String)"10");
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg((String)xmlStr);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>();
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser((Element)root);
        if ("0_0000".equals(bankResponse.getResponseCode())) {
            int pageNum;
            Element body = root.getChild("body");
            if (body == null || body.getChild("array") == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672c\u6b21\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38\uff0c\u54cd\u5e94\u62a5\u6587\u660e\u7ec6\u4fe1\u606f\u5b57\u6bb5\u7f3a\u5931\uff01", (String)"DetailImpl_0", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]));
            }
            int total = Integer.parseInt(body.getChildTextTrim("TotRcrdCnt"));
            if (total >= 10 * (pageNum = Integer.parseInt(this.getCurrentPage()) + 1)) {
                this.setLastPage(false);
                this.setCurrentPage(pageNum);
            }
            List dtoList = body.getChild("array").getChildren("dto");
            for (Element dto : dtoList) {
                DetailInfo detail = new DetailInfo();
                detail.setCurrency(dto.getChildTextTrim("currency"));
                detail.setOppAccNo(dto.getChildTextTrim("oppAcctNo"));
                detail.setOppAccName(dto.getChildTextTrim("oppAcctName"));
                detail.setOppBankName(dto.getChildTextTrim("oppBankName"));
                detail.setAccName(dto.getChildTextTrim("acctName"));
                detail.setAccNo(dto.getChildTextTrim("acctNo"));
                String hostSerialNo = dto.getChildText("hostSerialNo");
                String mxixuhao = dto.getChildText("mxixuhao");
                String transferDate = dto.getChildTextTrim("trDate");
                String transferTime = dto.getChildTextTrim("trTime");
                LocalDateTime transferDateTime = LocalDateTime.parse(transferDate + transferTime.substring(0, 6), Constant.dateTimeFormat);
                detail.setTransDate(transferDateTime.toLocalDate());
                detail.setTransTime(transferDateTime);
                BigDecimal amount = new BigDecimal(dto.getChildTextTrim("amt"));
                String CDFlag = dto.getChildTextTrim("drcrFlag");
                if (CDFlag.equalsIgnoreCase("D")) {
                    detail.setDebitAmount(amount);
                    detail.setCreditAmount(BigDecimal.ZERO);
                } else if (CDFlag.equalsIgnoreCase("C")) {
                    detail.setDebitAmount(BigDecimal.ZERO);
                    detail.setCreditAmount(amount);
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(dto);
                JSONObject jsonObject = JSON.parseObject((String)jsonStr);
                jsonObject.put("innerNo", (Object)hostSerialNo);
                jsonObject.put("innerNo2", (Object)hostSerialNo);
                if (hostSerialNo.endsWith(mxixuhao)) {
                    jsonObject.put("innerNo2", (Object)hostSerialNo.substring(0, hostSerialNo.length() - mxixuhao.length()));
                }
                String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), detail.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE), jsonObject.toJSONString());
                detail.setReceiptNo(receiptNo);
                detail.setJsonMap(jsonObject.toJSONString());
                String summary = dto.getChildTextTrim("summary");
                String postscript = dto.getChildTextTrim("postscript");
                if (StringUtils.isEmpty((String)postscript)) {
                    detail.setExplanation(summary);
                } else {
                    detail.setExplanation(postscript);
                }
                detail.setBalance(new BigDecimal(dto.getChildTextTrim("balance")));
                detailInfos.add(detail);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]), bankResponse.getResponseMessage()));
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "00003020101A0007";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean isSupportPage() {
        return true;
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg((String)super.recv(inputStream));
    }
}

