/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bcs.cmp.services.payment.batch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bcs.cmp.services.payment.ProxyUpload;
import kd.ebg.aqap.banks.bcs.cmp.services.payment.query.SalaryAndBatchPaymentQueryImpl;
import kd.ebg.aqap.banks.bcs.cmp.utils.Packer;
import kd.ebg.aqap.banks.bcs.cmp.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg((String)super.recv(inputStream));
    }

    public int getBatchSize() {
        return 300;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryAndBatchPaymentQueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        BigDecimal totalAmt = BigDecimal.ZERO;
        LinkedList cellValues = new LinkedList();
        for (PaymentInfo info : paymentInfos) {
            HashMap<String, String> cell = new HashMap<String, String>();
            cell.put("0", info.getIncomeAccNo());
            cell.put("1", info.getIncomeAccName());
            cell.put("2", info.getIncomeCnaps());
            cell.put("3", info.getIncomeBankName());
            cell.put("4", "1");
            cell.put("5", info.getAmount().toPlainString());
            cell.put("6", "");
            cell.put("7", "");
            cell.put("8", "");
            cell.put("9", info.getExplanation());
            cell.put("10", "");
            cellValues.add(cell);
            totalAmt = totalAmt.add(info.getAmount());
        }
        String exceleHeader = ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7|\u6536\u6b3e\u6237\u540d|\u6536\u6b3e\u884c\u53f7|\u6536\u6b3e\u94f6\u884c|\u8f6c\u8d26\u65b9\u5f0f|\u8f6c\u8d26\u91d1\u989d|\u51ed\u8bc1\u79cd\u7c7b|\u51ed\u8bc1\u53f7\u7801|\u6536\u6b3e\u4eba\u624b\u673a\u53f7|\u6458\u8981|\u9644\u8a00", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]);
        String fileName = paymentInfo.getBankBatchSeqId() + ".xlsx";
        ProxyUpload proxyUpload = new ProxyUpload();
        proxyUpload.setFileContent(Base64.getEncoder().encodeToString(JSON.toJSONBytes(cellValues, (SerializerFeature[])new SerializerFeature[0])));
        proxyUpload.setExcelHeader(Base64.getEncoder().encodeToString(exceleHeader.getBytes()));
        proxyUpload.doBiz(fileName);
        Element root = Packer.buildHead((String)"00003020104B0212", (String)paymentInfo.getBankBatchSeqId(), (String)"0", (String)"1");
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"tfrType", (String)"1");
        JDomUtils.addChild((Element)body, (String)"currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"acctName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"totalCount", (String)(paymentInfos.size() + ""));
        JDomUtils.addChild((Element)body, (String)"totalAmt", (String)totalAmt.toPlainString());
        JDomUtils.addChild((Element)body, (String)"summary", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)"");
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg((String)xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return Parser.payResponse((BankPayRequest)bankPayRequest, (String)s);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "00003020104B0212";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"00003020104B0212 \u6279\u91cf\u8f6c\u8d26", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-bcs-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

