/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import kd.ebg.aqap.banks.ccb.ccip.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.ccip.services.balance.HisBalanceImpl;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;

public class AggregateHisBalanceImpl
extends HisBalanceImpl {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(AggregateHisBalanceImpl.class);

    @Override
    public String pack(BankBalanceRequest bankBalanceRequest) {
        String bankRequest = this.isUsed_P1CMSERA6() ? this.packNomalHisBalance(bankBalanceRequest) : this.packCaiziHisBalance(bankBalanceRequest);
        return bankRequest;
    }

    @Override
    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        EBBankBalanceResponse response = this.isUsed_P1CMSERA6() ? this.parseNormalHisBalance(bankBalanceRequest, responseStr) : this.parseCaiziHisBalance(bankBalanceRequest, responseStr);
        return response;
    }

    @Override
    public EBBankBalanceResponse hisBalance(BankBalanceRequest request) {
        LocalDateTime dateTime;
        HashMap<String, BigDecimal> tempCurrentBalanceMap = new HashMap<String, BigDecimal>(1);
        RequestContextUtils.setRunningParam((String)"AggregateHisBalance", (String)"P1CMSERA6");
        EBBankBalanceResponse response = this.doBiz(request);
        List balanceInfoList = response.getBalances();
        for (BalanceInfo balanceInfo : balanceInfoList) {
            dateTime = balanceInfo.getBalanceDateTime();
            tempCurrentBalanceMap.putIfAbsent(this.getLocalDateTimeStr(dateTime), balanceInfo.getCurrentBalance());
        }
        RequestContextUtils.setRunningParam((String)"AggregateHisBalance", (String)"P1CMSERC4");
        response = this.doBiz(request);
        balanceInfoList = response.getBalances();
        for (BalanceInfo balanceInfo : balanceInfoList) {
            dateTime = balanceInfo.getBalanceDateTime();
            balanceInfo.setCurrentBalance(tempCurrentBalanceMap.getOrDefault(this.getLocalDateTimeStr(dateTime), BigDecimal.ZERO));
        }
        return response;
    }

    private String getLocalDateTimeStr(LocalDateTime dateTime) {
        return dateTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    public boolean isUsed_P1CMSERA6() {
        return "P1CMSERA6".equals(RequestContextUtils.getRunningParam((String)"AggregateHisBalance"));
    }

    @Override
    public String getDeveloper() {
        return "sk";
    }

    @Override
    public String getBizCode() {
        return "P1CMSERA6 & P1CMSERC4";
    }

    @Override
    public String getBizDesc() {
        return "Inquiry of historical balance for a aggregate account.";
    }

    @Override
    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.isAggregateAcnt(request.getHeader().getAcnt().getAccNo());
    }
}

