/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.ccip.services.payment.authority.AuthorityPayImpl;
import kd.ebg.aqap.banks.ccb.ccip.services.payment.company.CompanyPayImpl;
import kd.ebg.aqap.banks.ccb.ccip.services.payment.individual.IndividualPayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) {
        this.getBusiImplInfo(paymentInfo);
        this.setPayRouteTrace(paymentInfo);
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        String subBizType = paymentInfo.getSubBizType();
        if (this.isPay_for_linkPay(paymentInfo)) {
            this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
        } else if (this.isPay(paymentInfo)) {
            if (this.isAuthority()) {
                this.setImplClassName(paymentInfo, AuthorityPayImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
            }
        } else if (this.isPay_for_capital_allocation(paymentInfo)) {
            paymentInfo.setIndividual(Boolean.valueOf(false));
            this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
        } else if (this.isPay_for_salary(paymentInfo)) {
            paymentInfo.setIndividual(Boolean.valueOf(true));
            if (this.isIndividualToCompany()) {
                this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
            } else {
                String Entrst_Prj_ID = BankBusinessConfig.getPrjofCode(paymentInfo.getAccNo());
                if (StringUtils.isEmpty((String)Entrst_Prj_ID)) {
                    throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u4e1a\u52a1\u9700\u8981\u5148\u5728\u201c\u8d26\u53f7\u7ba1\u7406>\u9644\u52a0\u5c5e\u6027\u201d\u4e2d\u914d\u7f6e\u201c\u59d4\u6258\u9879\u76ee\u7f16\u53f7\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PretreatmentImpl_0", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]));
                }
                this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
            }
        } else {
            this.setImplClassName(paymentInfo, null);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s, \u8bf7\u68c0\u67e5\u8be5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_4", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), subBizType));
        }
        return busiImplInfo;
    }

    private boolean isAuthority() {
        return this.assertBusinessConfig("CCB_CCIP_IS_AUTHORITY", "true");
    }

    private boolean isIndividualToCompany() {
        return this.assertBusinessConfig("CCB_CCIP_IndividualToCompany", "true");
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        return null;
    }

    public String getDeveloper() {
        return "hpf";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5efa\u884cccip\u4ed8\u6b3e\u8def\u7531", (String)"PretreatmentImpl_3", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

