/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.payment.individual;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccb.ccip.services.LoginUtils;
import kd.ebg.aqap.banks.ccb.ccip.services.common.FileInfoNode;
import kd.ebg.aqap.banks.ccb.ccip.services.payment.CommonPayImpl;
import kd.ebg.aqap.banks.ccb.ccip.services.payment.individual.IndividualQueryPayImpl;
import kd.ebg.aqap.banks.ccb.ccip.utils.FileUtils;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class IndividualPayImpl
extends CommonPayImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(IndividualPayImpl.class);

    public int getBatchSize() {
        return BankBusinessConfig.getBatchSize();
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IndividualQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CLP1051";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"CCB_CCIP_\u94f6\u4f01\u76f4\u8054\u5ba2\u6237\u4ea4\u6613\u63a5\u53e3\u8bf4\u660e_\u4ee3\u6536\u4ee3\u4ed8_V1.0_20160728.pdf", (String)"IndividualPayImpl_0", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.getIndividual();
    }

    public String pack(BankPayRequest request) {
        String bizSeqId = request.getHeader().getBizSeqID();
        List paymentInfos = request.getPaymentInfos();
        LoginUtils.login((EBGLogger)this.logger);
        FileUtils fileUtils = new FileUtils();
        FileInfoNode fileInfoNode = fileUtils.getFileInfoNodes(paymentInfos);
        String message = "";
        try {
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb:\u6587\u4ef6\u540d=" + fileInfoNode.getFileName() + "");
            message = fileUtils.uploadFile(bizSeqId, fileInfoNode);
            this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6210\u529f.\u6587\u4ef6\u5185\u5bb9\uff1a");
            this.logger.info(fileInfoNode.getFileContent());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002", (String)"IndividualPayImpl_1", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (Throwable)e);
        }
        Element root = new Element("Transaction");
        Element header = CommonPacker.packCommonHeader((String)"P1CLP1051", (String)Sequence.genSequence());
        root.addContent((Content)header);
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element req = CommonPacker.packFileEntity((FileInfoNode)fileInfoNode, (String)message);
        body.addContent((Content)req);
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        String accNo = info.getAccNo();
        JDomExtUtils.addChildCDData((Element)req, (String)"Txn_SN", (String)info.getBankBatchSeqId());
        JDomExtUtils.addChildCDData((Element)req, (String)"EBnk_SvAr_ID", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
        JDomExtUtils.addChildCDData((Element)req, (String)"Entrst_Prj_ID", (String)BankBusinessConfig.getPrjofCode(accNo));
        String prj_use_id = RequestContextUtils.getBankParameterValue((String)"prj_use_id");
        if (StringUtils.isEmpty((String)prj_use_id)) {
            JDomExtUtils.addChildCDData((Element)req, (String)"Prj_Use_ID", (String)"zldf00001");
        } else {
            JDomExtUtils.addChildCDData((Element)req, (String)"Prj_Use_ID", (String)prj_use_id);
        }
        JDomExtUtils.addChildCDData((Element)req, (String)"EtrUnt_AccNo", (String)accNo);
        JDomExtUtils.addChildCDData((Element)req, (String)"TDP_ID", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
        JDomExtUtils.addChildCDData((Element)req, (String)"TDP_Nm", (String)"");
        if (paymentInfos.size() == 1) {
            JDomExtUtils.addChildCDData((Element)req, (String)"CntprtAcc", (String)info.getIncomeAccNo());
            JDomExtUtils.addChildCDData((Element)req, (String)"Cntrprt_AccNm", (String)info.getIncomeAccName());
            if (info.is2SameBank()) {
                JDomExtUtils.addChildCDData((Element)req, (String)"IwBk_BrNo", (String)"");
                JDomExtUtils.addChildCDData((Element)req, (String)"IwBk_BkNm", (String)"");
                JDomExtUtils.addChildCDData((Element)req, (String)"MltltAgrm_No", (String)"");
            } else {
                JDomExtUtils.addChildCDData((Element)req, (String)"IwBk_BrNo", (String)info.getIncomeCnaps());
                JDomExtUtils.addChildCDData((Element)req, (String)"IwBk_BkNm", (String)info.getIncomeBankName());
                JDomExtUtils.addChildCDData((Element)req, (String)"MltltAgrm_No", (String)"");
            }
            JDomExtUtils.addChildCDData((Element)req, (String)"SRP_TxnAmt", (String)BigDecimalHelper.plain2((BigDecimal)info.getAmount()));
            JDomExtUtils.addChildCDData((Element)req, (String)"VCHR_TP_CODE", (String)"0");
        } else {
            JDomExtUtils.addChildCDData((Element)req, (String)"CntprtAcc", (String)"");
            JDomExtUtils.addChildCDData((Element)req, (String)"Cntrprt_AccNm", (String)"");
            JDomExtUtils.addChildCDData((Element)req, (String)"IwBk_BrNo", (String)"");
            JDomExtUtils.addChildCDData((Element)req, (String)"IwBk_BkNm", (String)"");
            JDomExtUtils.addChildCDData((Element)req, (String)"SRP_TxnAmt", (String)"");
            JDomExtUtils.addChildCDData((Element)req, (String)"MltltAgrm_No", (String)"");
            JDomExtUtils.addChildCDData((Element)req, (String)"VCHR_TP_CODE", (String)"1");
        }
        JDomExtUtils.addChildCDData((Element)req, (String)"CCY_ID", (String)info.getCurrency());
        JDomExtUtils.addChildCDData((Element)req, (String)"Orig_File_Nm", (String)fileInfoNode.getFileName());
        JDomExtUtils.addChildCDData((Element)req, (String)"SCSP_Smy_Dsc", (String)((PaymentInfo)paymentInfos.get(0)).getAbstractMsg());
        JDomExtUtils.addChildCDData((Element)req, (String)"Rvw_Ind", (String)"1");
        BigDecimal totalAmout = BigDecimal.valueOf(0.0);
        for (PaymentInfo paymentInfo : paymentInfos) {
            totalAmout = totalAmout.add(paymentInfo.getAmount());
        }
        JDomExtUtils.addChildCDData((Element)req, (String)"TAmt", (String)BigDecimalHelper.plain2((BigDecimal)totalAmout));
        JDomExtUtils.addChildCDData((Element)req, (String)"TDnum", (String)String.valueOf(paymentInfos.size()));
        JDomExtUtils.addChildCDData((Element)req, (String)"Lng_Vrsn", (String)"1");
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        EBBankPayResponse ebBankPayResponse = new EBBankPayResponse();
        List paymentInfos = request.getPaymentInfos();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse((String)responseStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"IndividualPayImpl_2", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return ebBankPayResponse;
        }
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String RDsc = JDomExtUtils.getChildText((Element)body, (String)"RDsc");
        String Vchr_St = JDomExtUtils.getChildText((Element)response, (String)"Vchr_St");
        if ("800".equalsIgnoreCase(Vchr_St)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"IndividualPayImpl_2", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)Vchr_St, (String)RDsc);
        } else if ("700".equalsIgnoreCase(Vchr_St)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"IndividualPayImpl_3", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)Vchr_St, (String)RDsc);
        } else if ("400".equalsIgnoreCase(Vchr_St) || "401".equalsIgnoreCase(Vchr_St)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"IndividualPayImpl_4", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), (String)Vchr_St, (String)RDsc);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5\uff0c\u94f6\u884c\u54cd\u5e94\u72b6\u6001\u7801Vchr_St=%s\u3002", (String)"IndividualPayImpl_6", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), Vchr_St), (String)Vchr_St, (String)RDsc);
        }
        ebBankPayResponse.setPaymentInfos(paymentInfos);
        return ebBankPayResponse;
    }
}

