/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fbbk.api;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fbbk.api.BankBusinessConfig;
import kd.ebg.aqap.banks.fbbk.api.services.balance.BalanceImpl;
import kd.ebg.aqap.banks.fbbk.api.services.balance.HisBalanceImpl;
import kd.ebg.aqap.banks.fbbk.api.services.detail.DetailImpl;
import kd.ebg.aqap.banks.fbbk.api.services.payment.PayImpl;
import kd.ebg.aqap.banks.fbbk.api.services.payment.PretreatmentImpl;
import kd.ebg.aqap.banks.fbbk.api.services.payment.QueryPayImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.template.FBEMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class FBBKMetaDataImpl
extends FBEMetaDataTemplate
implements BankMetaDataCollector {
    public static final String APP_ID = "app_id";
    public static final String CHANNEL_ID = "channel_id";
    public static final String BRANCH_ID = "branch_id";
    public static final String MERCHANT_PRIVATE_KEY = "merchant_private_key";
    public static final String BANK_PUBLIC_KEY = "bank_public_key";

    public void baseConfigInit() {
        this.setExchangeProtocol("HTTPS", true);
        this.setTimeOut(3);
        this.setCharSet("GB18030");
        this.builder().ipName(new MultiLangEnumBridge(ResManager.loadKDString((String)"API\u63a5\u53e3\u7684IP\u6216\u57df\u540d", (String)"FBBKMetaDataImpl_0", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), "FBBKMetaDataImpl_0", "ebg-aqap-banks-fbbk-api")).portName(new MultiLangEnumBridge(ResManager.loadKDString((String)"API\u63a5\u53e3\u7684\u7aef\u53e3\u53f7", (String)"FBBKMetaDataImpl_1", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), "FBBKMetaDataImpl_1", "ebg-aqap-banks-fbbk-api")).build();
    }

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u5bcc\u90a6\u534e\u4e00\u94f6\u884c", (String)"FBBKMetaDataImpl_2", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]));
        this.setBankVersionID("FBBK_API");
        this.setBankShortName("FBBK");
        this.setBankVersionName(ResManager.loadKDString((String)"\u5bcc\u90a6\u534e\u4e00\u94f6\u884cAPI\u7248", (String)"FBBKMetaDataImpl_3", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u5bcc\u90a6\u534e\u4e00\u94f6\u884cAPI\u7248", (String)"FBBKMetaDataImpl_3", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList());
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)APP_ID, (MultiLangEnumBridge)new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5546\u6237\u53f7", (String)"FBBKMetaDataImpl_4", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), "FBBKMetaDataImpl_4", "ebg-aqap-banks-fbbk-api"), (MultiLangEnumBridge)new MultiLangEnumBridge("", "", "ebg-aqap-banks-fbbk-api"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)CHANNEL_ID, (MultiLangEnumBridge)new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6e20\u9053\u53f7", (String)"FBBKMetaDataImpl_5", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), "FBBKMetaDataImpl_5", "ebg-aqap-banks-fbbk-api"), (MultiLangEnumBridge)new MultiLangEnumBridge("", "", "ebg-aqap-banks-fbbk-api"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)BRANCH_ID, (MultiLangEnumBridge)new MultiLangEnumBridge(ResManager.loadKDString((String)"\u673a\u6784\u53f7", (String)"FBBKMetaDataImpl_6", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), "FBBKMetaDataImpl_6", "ebg-aqap-banks-fbbk-api"), (MultiLangEnumBridge)new MultiLangEnumBridge("", "", "ebg-aqap-banks-fbbk-api"), (String)"", (boolean)false, (boolean)false)});
    }

    public List<BankLoginConfig> getBankLoginConfig() {
        List<BankLoginConfig> loginConfigs = super.getBankLoginConfig();
        loginConfigs = loginConfigs.stream().filter(l -> !MetaDataConfigType.PGP_CONFIG.getName().equals(l.getType())).collect(Collectors.toList());
        List configs = this.getBankPGPConfig().stream().map(b -> {
            b.setType(MetaDataConfigType.PGP_CONFIG.getName());
            return b;
        }).collect(Collectors.toList());
        loginConfigs.addAll(configs);
        return loginConfigs;
    }

    private List<BankLoginConfig> getBankPGPConfig() {
        BankLoginConfig privateKey = BankLoginConfigUtil.getMlBankLoginConfig((String)MERCHANT_PRIVATE_KEY, (MultiLangEnumBridge)new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5546\u6237\u79c1\u94a5", (String)"FBBKMetaDataImpl_7", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), "FBBKMetaDataImpl_7", "ebg-aqap-banks-fbbk-api"), (String)"", (boolean)false, (boolean)false, (String)"upload");
        privateKey.setMlDesc(new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5546\u6237\u7684\u79c1\u94a5", (String)"FBBKMetaDataImpl_8", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), "FBBKMetaDataImpl_8", "ebg-aqap-banks-fbbk-api"));
        BankLoginConfig bankPublicKey = BankLoginConfigUtil.getMlBankLoginConfig((String)BANK_PUBLIC_KEY, (MultiLangEnumBridge)new MultiLangEnumBridge(ResManager.loadKDString((String)"\u94f6\u884c\u516c\u94a5", (String)"FBBKMetaDataImpl_9", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), "FBBKMetaDataImpl_10", "ebg-aqap-banks-fbbk-api"), (String)"", (boolean)false, (boolean)false, (String)"upload");
        bankPublicKey.setMlDesc(new MultiLangEnumBridge(ResManager.loadKDString((String)"\u5bcc\u90a6\u534e\u4e00\u5f00\u653e\u5e73\u53f0\u7684\u516c\u94a5", (String)"FBBKMetaDataImpl_10", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), "FBBKMetaDataImpl_11", "ebg-aqap-banks-fbbk-api"));
        return Lists.newArrayList((Object[])new BankLoginConfig[]{privateKey, bankPublicKey});
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{BalanceImpl.class, HisBalanceImpl.class, DetailImpl.class, PayImpl.class, QueryPayImpl.class, PretreatmentImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("transDate", DetailUniqueTypeEnum.STRING.getType());
        result.put("serialNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("oppAccNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("tranAmt", DetailUniqueTypeEnum.STRING.getType());
        result.put("cdFlag", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }
}

