/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fbbk.api.services.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Packer;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        String s = "/openApi/balanceQuery";
        factory.setUri(s);
        super.configFactory(factory);
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        JSONObject headJson = Packer.packHeader();
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("queryType", (Object)"3");
        bodyJson.put("accountType", (Object)"");
        bodyJson.put("queryParameter", (Object)bankAcnt.getAccNo());
        bodyJson.put("maxReNum", (Object)"25");
        bodyJson.put("pageNo", (Object)"1");
        bodyJson.put("lastPageLineAcct", (Object)"");
        bodyJson.put("lastPageLineCcy", (Object)"");
        bodyJson.put("lastPageLineMark", (Object)"");
        JSONObject reqJson = new JSONObject();
        reqJson.put("head", (Object)headJson);
        reqJson.put("body", (Object)bodyJson);
        String reqData = reqJson.toJSONString();
        try {
            return Packer.encrytAndSign(reqData);
        }
        catch (IOException e) {
            this.logger.info("\u4f59\u989d\u62a5\u6587\u52a0\u5bc6\u5f02\u5e38", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        String response;
        try {
            response = Parser.decryAndSignCheck(responseStr);
        }
        catch (IOException e) {
            this.logger.error("\u67e5\u8be2\u4f59\u989d\u62a5\u6587\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        BankResponse bankResponse = Parser.getResponse(response);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseMessage(), (String)bankResponse.getResponseCode()));
        }
        JSONObject resJson = JSONObject.parseObject((String)response);
        JSONObject resp = resJson.getJSONObject("data");
        JSONArray acctBalanceList = resp.getJSONArray("acctBalanceList");
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(1);
        for (int i = 0; i < acctBalanceList.size(); ++i) {
            BalanceInfo balanceInfo = new BalanceInfo();
            JSONObject acctBalance = acctBalanceList.getJSONObject(i);
            JSONObject detail = acctBalance.getJSONArray("acctBalance").getJSONObject(0);
            String acct = detail.getString("acct");
            String ccy = detail.getString("ccy");
            String bookAmt = detail.getString("bookAmt");
            bookAmt = bookAmt.endsWith("+") ? bookAmt.replace("+", "") : "-" + bookAmt.replace("-", "");
            String avaibleAmt = detail.getString("avaibleAmt");
            avaibleAmt = avaibleAmt.endsWith("+") ? avaibleAmt.replace("+", "") : "-" + avaibleAmt.replace("-", "");
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            if (StringUtils.isNotEmpty((String)avaibleAmt)) {
                balanceInfo.setAvailableBalance(new BigDecimal(avaibleAmt).divide(new BigDecimal(100)));
            }
            if (StringUtils.isNotEmpty((String)bookAmt)) {
                balanceInfo.setCurrentBalance(new BigDecimal(bookAmt).divide(new BigDecimal(100)));
            }
            this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), acct);
            if ("RMB".equalsIgnoreCase(ccy)) {
                ccy = "CNY";
            }
            this.setBankCurrency(balanceInfo, ccy);
            balanceInfoList.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balanceInfoList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "balanceQuery";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]);
    }
}

