/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fbbk.api.services.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Packer;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        String s = "/openApi/dayBalQryYQAPI";
        factory.setUri(s);
        super.configFactory(factory);
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        JSONObject headJson = Packer.packHeader();
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("account", (Object)bankAcnt.getAccNo());
        bodyJson.put("beginDate", (Object)bankBalanceRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        bodyJson.put("endDate", (Object)bankBalanceRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JSONObject reqJson = new JSONObject();
        reqJson.put("head", (Object)headJson);
        reqJson.put("body", (Object)bodyJson);
        String reqData = reqJson.toJSONString();
        try {
            return Packer.encrytAndSign(reqData);
        }
        catch (IOException e) {
            this.logger.info("\u62a5\u6587\u52a0\u5bc6\u5f02\u5e38", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        String response;
        try {
            response = Parser.decryAndSignCheck(responseStr);
        }
        catch (IOException e) {
            this.logger.error("\u67e5\u8be2\u5386\u53f2\u4f59\u989d\u62a5\u6587\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        BankResponse bankResponse = Parser.getResponse(response);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseMessage(), (String)bankResponse.getResponseCode()));
        }
        JSONObject resJson = JSONObject.parseObject((String)response);
        JSONObject resp = resJson.getJSONObject("data");
        JSONArray acctBalanceList = resp.getJSONArray("acctBalanceList");
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(1);
        for (int i = 0; i < acctBalanceList.size(); ++i) {
            JSONArray jsonArray = acctBalanceList.getJSONObject(i).getJSONArray("acctBalance");
            for (int j = 0; j < jsonArray.size(); ++j) {
                BalanceInfo balanceInfo = new BalanceInfo();
                JSONObject jsonObject = jsonArray.getJSONObject(j);
                String entrydate = jsonObject.getString("entrydate");
                String bookAmt = jsonObject.getString("bookAmt");
                String useAmt = jsonObject.getString("useAmt");
                String cur = jsonObject.getString("cur");
                balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
                balanceInfo.setBankCurrency(cur);
                balanceInfo.setBalanceDateTime(LocalDate.parse(entrydate, DateTimeFormatter.ofPattern("yyyyMMdd")).atStartOfDay());
                if (StringUtils.isNotEmpty((String)bookAmt)) {
                    balanceInfo.setCurrentBalance(new BigDecimal(bookAmt));
                }
                if (StringUtils.isNotEmpty((String)useAmt)) {
                    balanceInfo.setAvailableBalance(new BigDecimal(useAmt));
                }
                balanceInfoList.add(balanceInfo);
            }
        }
        return new EBBankBalanceResponse(balanceInfoList);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "dayBalQryYQAPI";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u65e5\u7ec8\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_1", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]);
    }
}

