/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fbbk.api.services.payment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Packer;
import kd.ebg.aqap.banks.fbbk.api.services.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public void configFactory(ConnectionFactory factory) {
        String s = "/openApi/statusQueryAPI";
        factory.setUri(s);
        super.configFactory(factory);
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List payments = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)payments.get(0);
        JSONObject headJson = Packer.packHeader();
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("ref_no", (Object)info.getBankRefID());
        JSONObject reqJson = new JSONObject();
        reqJson.put("head", (Object)headJson);
        reqJson.put("body", (Object)bodyJson);
        String reqData = reqJson.toJSONString();
        try {
            return Packer.encrytAndSign(reqData);
        }
        catch (IOException e) {
            this.logger.error("\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u62a5\u6587\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        JSONArray tran_arr;
        JSONObject stateJson;
        String response;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        try {
            response = Parser.decryAndSignCheck(responseStr);
        }
        catch (IOException e) {
            this.logger.error("\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u62a5\u6587\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        BankResponse bankResponse = Parser.getResponse(response);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        JSONObject resJson = JSONObject.parseObject((String)response);
        JSONObject resp = resJson.getJSONObject("data");
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        if (resp.containsKey((Object)"tran_array") && (stateJson = (tran_arr = resp.getJSONArray("tran_array")).getJSONObject(0)).getString("ref_no").equals(info.getBankRefID())) {
            String stat = stateJson.getString("busi_status");
            String error_info = stateJson.getString("error_reason");
            if ("0".equalsIgnoreCase(stat) || "3".equalsIgnoreCase(stat) || "4".equalsIgnoreCase(stat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), (String)stat, (String)error_info);
            } else if ("1".equalsIgnoreCase(stat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), (String)stat, (String)error_info);
            } else if ("2".equalsIgnoreCase(stat)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), (String)stat, (String)error_info);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]), (String)stat, (String)error_info);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "statusQueryAPI";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8f6c\u8d26\u4ea4\u6613\u72b6\u6001\u67e5\u8be2", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-fbbk-api", (Object[])new Object[0]);
    }
}

