/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynnx.dc.services.detail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynnx.dc.services.Packer;
import kd.ebg.aqap.banks.ynnx.dc.services.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    public boolean isSupportPage() {
        return true;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String currentPage = this.getCurrentPage();
        if ("0".equals(currentPage)) {
            currentPage = "1";
            this.setCurrentPage(currentPage);
        }
        return Packer.packDetail(bankDetailRequest, this.getBizCode(), currentPage);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        this.setLastPage(true);
        Element root = Parser.parseString2Root(rspStr);
        Element head = JDomUtils.getChildElement((Element)root, (String)"Head");
        boolean success = Parser.parseRspHead(head);
        ArrayList<DetailInfo> lists = new ArrayList<DetailInfo>(16);
        if (success) {
            Element Body = JDomUtils.getChildElement((Element)root, (String)"Body");
            Element map = JDomUtils.getChildElement((Element)Body, (String)"Map");
            String currentCount = JDomUtils.getChildText((Element)map, (String)"CurrentCount");
            String totalCount = JDomUtils.getChildText((Element)map, (String)"TotalCount");
            if (StringUtils.isNotEmpty((String)totalCount)) {
                int nextPage = Integer.parseInt(this.getCurrentPage()) + 100;
                if (Integer.parseInt(totalCount) >= nextPage) {
                    this.setLastPage(false);
                    this.setCurrentPage(String.valueOf(nextPage));
                }
            }
            Element Lists2 = JDomUtils.getChildElement((Element)Body, (String)"List");
            List maps = Lists2.getChildren("Map");
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
            for (int i = 0; i < maps.size(); ++i) {
                Element Map2 = (Element)maps.get(i);
                String currency = JDomUtils.getChildText((Element)Map2, (String)"Currency");
                String jnlDate = JDomUtils.getChildText((Element)Map2, (String)"JnlDate");
                String jnlTime = JDomUtils.getChildText((Element)Map2, (String)"JnlTime");
                String transJnlNo = JDomUtils.getChildText((Element)Map2, (String)"TransJnlNo");
                String ebankJnlNo = JDomUtils.getChildText((Element)Map2, (String)"EbankJnlNo");
                String DCFlag = JDomUtils.getChildText((Element)Map2, (String)"DCFlag");
                String amount = JDomUtils.getChildText((Element)Map2, (String)"Amount");
                String channelId = JDomUtils.getChildText((Element)Map2, (String)"ChannelId");
                String balance = JDomUtils.getChildText((Element)Map2, (String)"Balance");
                String transInfo = JDomUtils.getChildText((Element)Map2, (String)"TransInfo");
                String acctOrgan = JDomUtils.getChildText((Element)Map2, (String)"AcctOrgan");
                String payeeAcName = JDomUtils.getChildText((Element)Map2, (String)"PayeeAcName");
                String payeeAcNo = JDomUtils.getChildText((Element)Map2, (String)"PayeeAcNo");
                String payeeBankName = JDomUtils.getChildText((Element)Map2, (String)"PayeeBankName");
                DetailInfo detail = new DetailInfo();
                if (StringUtils.isNotEmpty((String)balance)) {
                    detail.setBalance(new BigDecimal(balance));
                }
                detail.setAccName(bankDetailRequest.getAcnt().getAccName());
                detail.setAccNo(bankDetailRequest.getAcnt().getAccNo());
                detail.setBankName(bankDetailRequest.getAcnt().getBankName());
                detail.setCurrency(currency);
                if ("D".equals(DCFlag)) {
                    detail.setCreditAmount(BigDecimal.ZERO);
                    detail.setDebitAmount(new BigDecimal(amount));
                } else if ("C".equals(DCFlag)) {
                    detail.setCreditAmount(new BigDecimal(amount));
                    detail.setDebitAmount(BigDecimal.ZERO);
                }
                detail.setTransDate(LocalDate.parse(jnlDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                detail.setTransTime(LocalDateTime.parse(jnlDate + " " + jnlTime, DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss")));
                detail.setOppAccName(payeeAcName);
                detail.setOppAccNo(payeeAcNo);
                detail.setOppBankName(payeeBankName);
                detail.setExplanation(transInfo);
                if (transInfo.contains(PropertiesConstants.getValue((String)"STMTS_ZJSH"))) {
                    detail.markTransUp();
                } else if (transInfo.contains(PropertiesConstants.getValue((String)"STMTS_ZJXB"))) {
                    detail.markTransDown();
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(Map2);
                String accNo = bankDetailRequest.getAcnt().getAccNo();
                String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDateStr, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                detail.setJsonMap(jsonStr);
                lists.add(detail);
            }
        }
        return new EBBankDetailResponse(lists);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EActTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-aqap-banks-ynnx-dc", (Object[])new Object[0]);
    }
}

