/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynnx.dc.services.payment;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynnx.dc.services.Packer;
import kd.ebg.aqap.banks.ynnx.dc.services.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = Packer.packRoot();
        Packer.packHead(root, this.getBizCode());
        Element body = Packer.packBody(root);
        Element map = Packer.packMap(body);
        JDomUtils.addChild((Element)map, (String)"BeginDate", (String)"");
        JDomUtils.addChild((Element)map, (String)"EndDate", (String)"");
        JDomUtils.addChild((Element)map, (String)"TransJnlNo", (String)paymentInfo.getBankDetailSeqID());
        JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = Parser.parseString2Root(rspStr);
        Element head = JDomUtils.getChildElement((Element)root, (String)"Head");
        String rspCode = JDomUtils.getChildTextTrim((Element)head, (String)"ReturnCode");
        String rspMsg = JDomUtils.getChildTextTrim((Element)head, (String)"ReturnMsg");
        if (!"000000".equals(rspCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspCode, (String)rspMsg);
        } else {
            Element Body = JDomUtils.getChildElement((Element)root, (String)"Body");
            Element list = Body.getChild("List");
            List maps = list.getChildren();
            Element element = (Element)maps.get(0);
            String returnCode = JDomUtils.getChildText((Element)element, (String)"ReturnCode");
            String returnMsg = JDomUtils.getChildText((Element)element, (String)"ReturnMsg");
            String jnlState = JDomUtils.getChildText((Element)element, (String)"JnlState");
            if ("0".equals(jnlState)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-ynnx-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
            } else if ("2".equals(jnlState)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-ynnx-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
            } else if ("8".equals(jnlState)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5f85\u5904\u7406", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-ynnx-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-ynnx-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2ETrsResultQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u5b8c\u6210\u60c5\u51b5\u67e5\u8be2", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-ynnx-dc", (Object[])new Object[0]);
    }
}

