/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynnx.dc.services.payment.salary;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynnx.dc.services.Packer;
import kd.ebg.aqap.banks.ynnx.dc.services.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QuerySalaryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1000;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = Packer.packRoot();
        Packer.packHead(root, this.getBizCode());
        Element body = Packer.packBody(root);
        Element map = Packer.packMap(body);
        JDomUtils.addChild((Element)map, (String)"BatchNo", (String)paymentInfo.getBankBatchSeqID());
        JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = Parser.parseString2Root(rspStr);
        Element head = JDomUtils.getChildElement((Element)root, (String)"Head");
        String rspCode = JDomUtils.getChildTextTrim((Element)head, (String)"ReturnCode");
        String rspMsg = JDomUtils.getChildTextTrim((Element)head, (String)"ReturnMsg");
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        if (!"000000".equals(rspCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rspCode, (String)rspMsg);
            return new EBBankPayResponse(paymentInfos);
        }
        Element Lists2 = JDomUtils.getChildElement((Element)body, (String)"List");
        List maps = Lists2.getChildren("Map");
        ArrayList<BankResPaymentInfo> bankResPaymentInfos = new ArrayList<BankResPaymentInfo>(16);
        for (int i = 0; i < maps.size(); ++i) {
            Element element = (Element)maps.get(i);
            String payeeAcNo = JDomUtils.getChildText((Element)element, (String)"PayeeAcNo");
            String payeeAcName = JDomUtils.getChildText((Element)element, (String)"PayeeAcName");
            String amount = JDomUtils.getChildText((Element)element, (String)"Amount");
            String jnlState = JDomUtils.getChildText((Element)element, (String)"JnlState");
            String returnMsg = JDomUtils.getChildText((Element)element, (String)"ReturnMsg");
            BankResPaymentInfo bankResPaymentInfo = new BankResPaymentInfo(payeeAcNo, payeeAcName, amount);
            bankResPaymentInfo.setBankStatus(jnlState);
            bankResPaymentInfo.setBankMsg(returnMsg);
            if ("0".equals(jnlState)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUBMITED);
            } else if ("1".equals(jnlState)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUCCESS);
            } else if ("2".equals(jnlState) || "3".equals(jnlState)) {
                bankResPaymentInfo.setPaymentState(PaymentState.FAIL);
            } else {
                bankResPaymentInfo.setPaymentState(PaymentState.UNKNOWN);
            }
            bankResPaymentInfos.add(bankResPaymentInfo);
        }
        MatchPayStatusModel matchPayStatusModel = new MatchPayStatusModel();
        matchPayStatusModel.setMatchRule("ACCOUNT_NAME_AMOUNT");
        matchPayStatusModel.setBankResPaymentInfoList(bankResPaymentInfos);
        List allPaymentInfoByBankBatchNo = CommonPayStatusMatchUtil.getAllPaymentInfoByBankBatchNo((String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        return new EBBankPayResponse(CommonPayStatusMatchUtil.HandlePayStatus((MatchPayStatusModel)matchPayStatusModel, (List)allPaymentInfoByBankBatchNo));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EQryAgentData2Host";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u4ea4\u6613\u67e5\u8be2", (String)"QuerySalaryImpl_0", (String)"ebg-aqap-banks-ynnx-dc", (Object[])new Object[0]);
    }
}

